/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ehrbase.opt.TermDefinition;
import org.ehrbase.opt.ValuePoint;
import org.openehr.schemas.v1.CCODEPHRASE;
import org.openehr.schemas.v1.TERMINOLOGYID;

public class CodePhrase {
    final String type = "CODE_PHRASE";
    CCODEPHRASE ccodephrase;
    Map<String, TermDefinition> termDef;

    public CodePhrase(CCODEPHRASE ccodephrase, Map<String, TermDefinition> termDef) {
        this.ccodephrase = ccodephrase;
        this.termDef = termDef;
    }

    public Map toMap(String name) {
        HashMap<String, Object> retmap = new HashMap<String, Object>();
        retmap.put("mandatory_attributes", new ValuePoint("CODE_PHRASE").attributes());
        retmap.put("type", "CODE_PHRASE");
        retmap.put("attribute_name", name);
        TERMINOLOGYID tid = this.ccodephrase.getTerminologyId();
        String[] codeList = this.ccodephrase.getCodeListArray();
        ArrayList attributeList = new ArrayList();
        if (tid != null) {
            retmap.put("terminology", tid.getValue());
        }
        retmap.put("constraint", attributeList);
        for (String code : codeList) {
            HashMap<String, String> codeMap = new HashMap<String, String>();
            codeMap.put("value", code);
            if (this.termDef.get(code) != null) {
                codeMap.put("label", this.termDef.get(code).getValue());
                codeMap.put("description", this.termDef.get(code).getDescription());
            }
            attributeList.add(codeMap);
        }
        return retmap;
    }
}

