/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ehrbase.opt.TermDefinition;
import org.ehrbase.opt.ValuePoint;
import org.ehrbase.service.TerminologyServiceImp;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CCODEPHRASE;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.COBJECT;
import org.openehr.schemas.v1.CONSTRAINTREF;

public class CodedText {
    final String type = "DV_CODED_TEXT";
    CCOMPLEXOBJECT ccomplexobject;
    Map<String, TermDefinition> termDef;

    public CodedText(CCOMPLEXOBJECT ccomplexobject, Map<String, TermDefinition> termDef) {
        this.ccomplexobject = ccomplexobject;
        this.termDef = termDef;
    }

    public Map<String, Object> toMap(String name) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        HashMap<String, Cloneable> constraintsMap = new HashMap<String, Cloneable>();
        boolean isComplete = false;
        COBJECT[] defining_codes = null;
        for (CATTRIBUTE cattribute : this.ccomplexobject.getAttributesArray()) {
            if (!cattribute.getRmAttributeName().equals("defining_code")) continue;
            defining_codes = cattribute.getChildrenArray();
        }
        ArrayList valueList = new ArrayList();
        if (defining_codes != null) {
            for (COBJECT cobject : defining_codes) {
                if (cobject instanceof CCODEPHRASE) {
                    attributeMap.put("type", "DV_CODED_TEXT");
                    isComplete = true;
                    for (String code : ((CCODEPHRASE)cobject).getCodeListArray()) {
                        HashMap<String, String> codeMap = new HashMap<String, String>();
                        codeMap.put("code_string", code);
                        codeMap.put("terminology", ((CCODEPHRASE)cobject).getTerminologyId().getValue());
                        if (this.termDef.get(code) != null) {
                            codeMap.put("value", this.termDef.get(code).getValue());
                            codeMap.put("description", this.termDef.get(code).getDescription());
                        } else if (((CCODEPHRASE)cobject).getTerminologyId() != null && "openehr".equals(((CCODEPHRASE)cobject).getTerminologyId().getValue()) && TerminologyServiceImp.getInstance() != null) {
                            codeMap.put("value", TerminologyServiceImp.getInstance().getLabelForCode(code, "en"));
                        }
                        valueList.add(codeMap);
                    }
                    continue;
                }
                if (!(cobject instanceof CONSTRAINTREF)) continue;
                CONSTRAINTREF constraintref = (CONSTRAINTREF)cobject;
                String string = constraintref.getReference();
            }
        }
        if (valueList.size() > 0) {
            constraintsMap.put("defining_code", valueList);
        }
        HashMap<String, Object> range = new HashMap<String, Object>();
        attributeMap.put("constraint", constraintsMap);
        constraintsMap.put("occurrence", range);
        range.put("min_op", this.ccomplexobject.getOccurrences().isSetLowerIncluded() ? ">=" : ">");
        range.put("min", this.ccomplexobject.getOccurrences().isSetLower() ? this.ccomplexobject.getOccurrences().getLower() : -1);
        range.put("max_op", this.ccomplexobject.getOccurrences().isSetUpperIncluded() ? "<=" : "<");
        range.put("max", this.ccomplexobject.getOccurrences().isSetUpper() ? this.ccomplexobject.getOccurrences().getUpper() : -1);
        if (!isComplete) {
            return null;
        }
        attributeMap.put("mandatory_attributes", new ValuePoint("DV_CODED_TEXT").attributes());
        attributeMap.put("attribute_name", name);
        return attributeMap;
    }
}

