/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt.mapper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ehrbase.opt.TermDefinition;
import org.ehrbase.opt.ValuePoint;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.CINTEGER;
import org.openehr.schemas.v1.COBJECT;
import org.openehr.schemas.v1.CPRIMITIVEOBJECT;

public class Count {
    static final String type = "DV_COUNT";
    CCOMPLEXOBJECT ccomplexobject;
    Map<String, TermDefinition> termDef;

    public Count(CCOMPLEXOBJECT ccomplexobject, Map<String, TermDefinition> termDef) {
        this.ccomplexobject = ccomplexobject;
        this.termDef = termDef;
    }

    public Map<String, Object> toMap(String name) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put("type", type);
        attributeMap.put("attribute_name", name);
        attributeMap.put("mandatory_attributes", new ValuePoint(type).attributes());
        ArrayList<HashMap<String, Object>> valueList = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Serializable> constraintsMap = new HashMap<String, Serializable>();
        attributeMap.put("constraint", constraintsMap);
        for (CATTRIBUTE attribute : this.ccomplexobject.getAttributesArray()) {
            if (!attribute.getRmAttributeName().equals("magnitude")) continue;
            for (COBJECT cobject : attribute.getChildrenArray()) {
                if (!cobject.getRmTypeName().equals("INTEGER")) continue;
                CPRIMITIVEOBJECT cprimitiveobject = (CPRIMITIVEOBJECT)cobject;
                CINTEGER cprimitive = (CINTEGER)cprimitiveobject.getItem();
                if (cprimitive.isSetRange()) {
                    if (cprimitive.getRange().isSetLower()) {
                        constraintsMap.put("min", Integer.valueOf(cprimitive.getRange().getLower()));
                    }
                    if (cprimitive.getRange().isSetUpper()) {
                        constraintsMap.put("max", Integer.valueOf(cprimitive.getRange().getUpper()));
                    }
                }
                if (!cprimitive.isSetAssumedValue()) continue;
                constraintsMap.put("assumed_value", Integer.valueOf(cprimitive.getAssumedValue()));
            }
        }
        HashMap<String, Object> range = new HashMap<String, Object>();
        constraintsMap.put("occurrence", range);
        range.put("min_op", this.ccomplexobject.getOccurrences().isSetLowerIncluded() ? ">=" : ">");
        range.put("min", this.ccomplexobject.getOccurrences().isSetLower() ? this.ccomplexobject.getOccurrences().getLower() : -1);
        range.put("max_op", this.ccomplexobject.getOccurrences().isSetUpperIncluded() ? "<=" : "<");
        range.put("max", this.ccomplexobject.getOccurrences().isSetUpper() ? this.ccomplexobject.getOccurrences().getUpper() : -1);
        valueList.add(attributeMap);
        return attributeMap;
    }
}

