/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ehrbase.opt.TermDefinition;
import org.ehrbase.opt.ValuePoint;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.CDATETIME;
import org.openehr.schemas.v1.COBJECT;
import org.openehr.schemas.v1.CPRIMITIVEOBJECT;

public class DateTime {
    static final String type = "DV_DATE_TIME";
    CCOMPLEXOBJECT ccomplexobject;
    Map<String, TermDefinition> termDef;

    public DateTime(CCOMPLEXOBJECT ccomplexobject, Map<String, TermDefinition> termDef) {
        this.ccomplexobject = ccomplexobject;
        this.termDef = termDef;
    }

    public Map<String, Object> toMap(String name) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put("type", type);
        attributeMap.put("attribute_name", name);
        attributeMap.put("mandatory_attributes", new ValuePoint(type).attributes());
        ArrayList<HashMap<String, Object>> valueList = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Object> constraintsMap = new HashMap<String, Object>();
        attributeMap.put("constraint", constraintsMap);
        for (CATTRIBUTE attribute : this.ccomplexobject.getAttributesArray()) {
            if (!attribute.getRmAttributeName().equals("value")) continue;
            for (COBJECT cobject : attribute.getChildrenArray()) {
                if (!cobject.getRmTypeName().equals("DATE_TIME")) continue;
                CPRIMITIVEOBJECT cprimitiveobject = (CPRIMITIVEOBJECT)cobject;
                CDATETIME cprimitive = (CDATETIME)cprimitiveobject.getItem();
                if (cprimitive.isSetRange()) {
                    if (cprimitive.getRange().isSetLower()) {
                        constraintsMap.put("min", cprimitive.getRange().getLower());
                    }
                    if (cprimitive.getRange().isSetUpper()) {
                        constraintsMap.put("max", cprimitive.getRange().getUpper());
                    }
                }
                if (cprimitive.isSetAssumedValue()) {
                    constraintsMap.put("assumed_value", cprimitive.getAssumedValue());
                }
                if (cprimitive.getPattern() == null) continue;
                constraintsMap.put("pattern", cprimitive.getPattern());
            }
        }
        HashMap<String, Object> range = new HashMap<String, Object>();
        constraintsMap.put("occurrence", range);
        range.put("min_op", this.ccomplexobject.getOccurrences().isSetLowerIncluded() ? ">=" : ">");
        range.put("min", this.ccomplexobject.getOccurrences().isSetLower() ? this.ccomplexobject.getOccurrences().getLower() : -1);
        range.put("max_op", this.ccomplexobject.getOccurrences().isSetUpperIncluded() ? "<=" : "<");
        range.put("max", this.ccomplexobject.getOccurrences().isSetUpper() ? this.ccomplexobject.getOccurrences().getUpper() : -1);
        valueList.add(attributeMap);
        return attributeMap;
    }
}

