/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ehrbase.opt.NodeId;
import org.ehrbase.opt.TermDefinition;
import org.ehrbase.opt.mapper.Constants;
import org.ehrbase.opt.mapper.NodeNameAttribute;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.COBJECT;
import org.openehr.schemas.v1.CSINGLEATTRIBUTE;
import org.openehr.schemas.v1.IntervalOfInteger;

public class Element {
    CCOMPLEXOBJECT ccomplexobject;
    Map<String, TermDefinition> termDef;

    public Element(CCOMPLEXOBJECT ccomplexobject, Map<String, TermDefinition> termDef) {
        this.ccomplexobject = ccomplexobject;
        this.termDef = termDef;
    }

    public Map<String, Object> toMap(String nodeId, String path, List<Map<String, Object>> embedded) {
        HashMap<String, Object> elementMap = new HashMap<String, Object>();
        HashMap validationMap = new HashMap();
        elementMap.put("aql_path", path);
        elementMap.put("category", Constants.LITTERAL_ELEMENT);
        if (validationMap.size() > 0) {
            elementMap.put("validation", validationMap);
        }
        elementMap.put("node_id", nodeId);
        elementMap.put("name", this.termDef.get(nodeId).getValue());
        elementMap.put("id", new NodeId(this.termDef.get(nodeId).getValue()).ehrscape());
        elementMap.put("description", this.termDef.get(nodeId).getDescription());
        if (this.ccomplexobject.getOccurrences() != null) {
            elementMap.put("min", this.ccomplexobject.getOccurrences().getLower() == 0 ? (this.ccomplexobject.getOccurrences().getLowerUnbounded() ? -1 : 0) : this.ccomplexobject.getOccurrences().getLower());
            elementMap.put("max", this.ccomplexobject.getOccurrences().getUpper() == 0 ? (this.ccomplexobject.getOccurrences().getUpperUnbounded() ? -1 : 0) : this.ccomplexobject.getOccurrences().getUpper());
        }
        HashMap<String, Object> rangeMap = new HashMap<String, Object>();
        for (CATTRIBUTE cattribute : this.ccomplexobject.getAttributesArray()) {
            String overridenName;
            if (cattribute.getRmAttributeName().equals("value")) {
                validationMap.put("occurrence", rangeMap);
                rangeMap.put("min_op", cattribute.getExistence().isSetLowerIncluded() ? ">=" : ">");
                rangeMap.put("min", cattribute.getExistence().isSetLower() ? cattribute.getExistence().getLower() : -1);
                rangeMap.put("max_op", cattribute.getExistence().isSetUpperIncluded() ? "<=" : "<");
                rangeMap.put("max", cattribute.getExistence().isSetUpper() ? cattribute.getExistence().getUpper() : -1);
            } else if (cattribute instanceof CSINGLEATTRIBUTE && cattribute.getRmAttributeName().equals("name") && (overridenName = new NodeNameAttribute(cattribute).staticName()) != null) {
                elementMap.put("name", overridenName);
                elementMap.put("id", new NodeId(overridenName).ehrscape());
            }
            if (cattribute.getChildrenArray().length <= 0) continue;
            ArrayList children = new ArrayList();
            HashMap<String, Object> childrenMap = new HashMap<String, Object>();
            for (COBJECT cobj : cattribute.getChildrenArray()) {
                IntervalOfInteger occurrence = cobj.getOccurrences();
                rangeMap = new HashMap();
                childrenMap.put("limits", rangeMap);
                rangeMap.put("min_op", occurrence.isSetLowerIncluded() ? ">=" : ">");
                rangeMap.put("min", occurrence.isSetLower() ? occurrence.getLower() : -1);
                rangeMap.put("max_op", occurrence.isSetUpperIncluded() ? "<=" : "<");
                rangeMap.put("max", occurrence.isSetUpper() ? occurrence.getUpper() : -1);
                elementMap.put("type", cobj.getRmTypeName());
                if (embedded != null && !embedded.isEmpty()) {
                    childrenMap.put("constraint", embedded);
                }
                children.add(childrenMap);
            }
            if (children.size() <= 0) continue;
            elementMap.put(Constants.CONSTRAINTS, children);
        }
        return elementMap;
    }
}

