/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ehrbase.opt.TermDefinition;
import org.ehrbase.opt.ValuePoint;
import org.ehrbase.opt.mapper.Count;
import org.ehrbase.opt.mapper.Duration;
import org.ehrbase.opt.mapper.Ordinal;
import org.ehrbase.opt.mapper.Proportion;
import org.ehrbase.opt.mapper.Quantity;
import org.ehrbase.opt.mapper.ValueType;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.CDVORDINAL;
import org.openehr.schemas.v1.CDVQUANTITY;
import org.openehr.schemas.v1.COBJECT;

public class Interval {
    static final String type = "DV_INTERVAL";
    CCOMPLEXOBJECT ccomplexobject;
    Map<String, TermDefinition> termDef;

    public Interval(CCOMPLEXOBJECT ccomplexobject, Map<String, TermDefinition> termDef) {
        this.ccomplexobject = ccomplexobject;
        this.termDef = termDef;
    }

    public Map<String, Object> toMap(String name) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put("type", type);
        attributeMap.put("attribute_name", name);
        ArrayList<HashMap<String, Object>> valueList = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Object> constraintsMap = new HashMap<String, Object>();
        attributeMap.put("constraint", constraintsMap);
        ArrayList<String> valuePoints = new ArrayList<String>();
        for (CATTRIBUTE attribute : this.ccomplexobject.getAttributesArray()) {
            HashMap map = new HashMap();
            if (attribute.getRmAttributeName().equals("upper")) {
                for (COBJECT cobject : attribute.getChildrenArray()) {
                    this.putInnerType(constraintsMap, cobject, "upper");
                    valuePoints.add("upper");
                    valuePoints.add((String)((Map)constraintsMap.get("upper")).get("type"));
                }
                continue;
            }
            if (!attribute.getRmAttributeName().equals("lower")) continue;
            for (COBJECT cobject : attribute.getChildrenArray()) {
                this.putInnerType(constraintsMap, cobject, "lower");
                valuePoints.add("lower");
                valuePoints.add((String)((Map)constraintsMap.get("lower")).get("type"));
            }
        }
        attributeMap.put("mandatory_attributes", new ValuePoint(type).attributes(valuePoints.toArray(new String[0])));
        HashMap<String, Object> range = new HashMap<String, Object>();
        constraintsMap.put("occurrence", range);
        range.put("min_op", this.ccomplexobject.getOccurrences().isSetLowerIncluded() ? ">=" : ">");
        range.put("min", this.ccomplexobject.getOccurrences().isSetLower() ? this.ccomplexobject.getOccurrences().getLower() : -1);
        range.put("max_op", this.ccomplexobject.getOccurrences().isSetUpperIncluded() ? "<=" : "<");
        range.put("max", this.ccomplexobject.getOccurrences().isSetUpper() ? this.ccomplexobject.getOccurrences().getUpper() : -1);
        valueList.add(attributeMap);
        return attributeMap;
    }

    private void putInnerType(Map<String, Object> map, COBJECT cobject, String attributeName) {
        if (cobject.getRmTypeName().equals("DV_QUANTITY")) {
            map.put(attributeName, new Quantity((CDVQUANTITY)cobject, this.termDef).toMap(attributeName));
        } else if (cobject.getRmTypeName().equals("DV_COUNT")) {
            map.put(attributeName, new Count((CCOMPLEXOBJECT)cobject, this.termDef).toMap(attributeName));
        } else if (cobject.getRmTypeName().equals("DV_DATE") || cobject.getRmTypeName().equals("DV_DATE_TIME") || cobject.getRmTypeName().equals("DV_TIME")) {
            map.put(attributeName, new ValueType((CCOMPLEXOBJECT)cobject, this.termDef).toMap(cobject.getRmTypeName(), attributeName));
        } else if (cobject.getRmTypeName().equals("DV_DURATION")) {
            map.put(attributeName, new Duration((CCOMPLEXOBJECT)cobject, this.termDef).toMap(attributeName));
        } else if (cobject.getRmTypeName().equals("DV_ORDINAL")) {
            map.put(attributeName, new Ordinal((CDVORDINAL)cobject, this.termDef).toMap(attributeName));
        } else if (cobject.getRmTypeName().equals("DV_PROPORTION")) {
            map.put(attributeName, new Proportion((CCOMPLEXOBJECT)cobject, this.termDef).toMap(attributeName));
        }
    }

    private String[] valuePointType(COBJECT cobject) {
        ArrayList<String> arraySpec = new ArrayList<String>();
        if (cobject.getRmTypeName().equals("DV_QUANTITY") || cobject.getRmTypeName().equals("DV_COUNT")) {
            arraySpec.add("magnitude");
            arraySpec.add("REAL");
        } else if (cobject.getRmTypeName().equals("DV_DATE") || cobject.getRmTypeName().equals("DV_DATE_TIME") || cobject.getRmTypeName().equals("DV_TIME") || cobject.getRmTypeName().equals("DV_DURATION")) {
            arraySpec.add("value");
            arraySpec.add("STRING");
        } else if (cobject.getRmTypeName().equals("DV_ORDINAL")) {
            arraySpec.add("value");
            arraySpec.add("INTEGER");
        } else if (cobject.getRmTypeName().equals("DV_PROPORTION")) {
            arraySpec.add("lower");
            arraySpec.add("REAL");
            arraySpec.add("upper");
            arraySpec.add("REAL");
        }
        return arraySpec.toArray(new String[0]);
    }
}

