/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ehrbase.opt.TermDefinition;
import org.ehrbase.opt.ValuePoint;
import org.ehrbase.opt.mapper.CodedText;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.COBJECT;

public class IsmTransition {
    static final String type = "ISM_TRANSITION";
    CCOMPLEXOBJECT ccomplexobject;
    Map<String, TermDefinition> termDef;

    public IsmTransition(CCOMPLEXOBJECT ccomplexobject, Map<String, TermDefinition> termDef) {
        this.ccomplexobject = ccomplexobject;
        this.termDef = termDef;
    }

    public Map<String, Object> toMap(String name) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put("type", type);
        attributeMap.put("attribute_name", name);
        attributeMap.put("mandatory_attributes", new ValuePoint(type).attributes());
        ArrayList<HashMap<String, Object>> valueList = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Map<String, Object>> constraintsMap = new HashMap<String, Map<String, Object>>();
        attributeMap.put("constraint", constraintsMap);
        for (CATTRIBUTE attribute : this.ccomplexobject.getAttributesArray()) {
            if (attribute.getRmAttributeName().equals("current_state")) {
                for (COBJECT cobject : attribute.getChildrenArray()) {
                    if (!cobject.getRmTypeName().equals("DV_CODED_TEXT")) continue;
                    constraintsMap.put("current_state", new CodedText((CCOMPLEXOBJECT)cobject, this.termDef).toMap("current_state"));
                }
                continue;
            }
            if (!attribute.getRmAttributeName().equals("careflow_step")) continue;
            for (COBJECT cobject : attribute.getChildrenArray()) {
                if (!cobject.getRmTypeName().equals("DV_CODED_TEXT")) continue;
                constraintsMap.put("careflow_step", new CodedText((CCOMPLEXOBJECT)cobject, this.termDef).toMap("careflow_step"));
            }
        }
        HashMap<String, Object> range = new HashMap<String, Object>();
        constraintsMap.put("occurrence", range);
        range.put("min_op", this.ccomplexobject.getOccurrences().isSetLowerIncluded() ? ">=" : ">");
        range.put("min", this.ccomplexobject.getOccurrences().isSetLower() ? this.ccomplexobject.getOccurrences().getLower() : -1);
        range.put("max_op", this.ccomplexobject.getOccurrences().isSetUpperIncluded() ? "<=" : "<");
        range.put("max", this.ccomplexobject.getOccurrences().isSetUpper() ? this.ccomplexobject.getOccurrences().getUpper() : -1);
        valueList.add(attributeMap);
        return attributeMap;
    }
}

