/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ehrbase.opt.TermDefinition;
import org.ehrbase.opt.ValuePoint;
import org.openehr.schemas.v1.CDVORDINAL;
import org.openehr.schemas.v1.CODEPHRASE;
import org.openehr.schemas.v1.DVCODEDTEXT;
import org.openehr.schemas.v1.DVORDINAL;

public class Ordinal {
    static final String type = "DV_ORDINAL";
    CDVORDINAL cdvordinal;
    Map<String, TermDefinition> termDef;

    public Ordinal(CDVORDINAL cdvordinal, Map<String, TermDefinition> termDef) {
        this.cdvordinal = cdvordinal;
        this.termDef = termDef;
    }

    public Map toMap(String name) {
        HashMap<String, Object> retmap = new HashMap<String, Object>();
        retmap.put("mandatory_attributes", new ValuePoint(type).attributes());
        retmap.put("type", type);
        retmap.put("attribute_name", name);
        ArrayList mappingList = new ArrayList();
        if (this.cdvordinal.isSetAssumedValue()) {
            retmap.put("assumed_value", this.cdvordinal.getAssumedValue());
        }
        HashMap mappingMap = new HashMap();
        mappingMap.put("symbol", mappingList);
        retmap.put("constraint", mappingMap);
        for (DVORDINAL dvordinal : this.cdvordinal.getListArray()) {
            HashMap<String, Object> mapping = new HashMap<String, Object>();
            mapping.put("value", dvordinal.getValue());
            if (!dvordinal.getSymbol().getValue().isEmpty()) {
                mapping.put("symbol", dvordinal.getSymbol().getValue());
            }
            DVCODEDTEXT dvcodedtext = dvordinal.getSymbol();
            CODEPHRASE code = dvcodedtext.getDefiningCode();
            mapping.put("code", code.getCodeString());
            mapping.put("terminology", code.getTerminologyId().getValue());
            mapping.put("description", this.termDef.get(code.getCodeString()).getValue());
            if (dvordinal.getNormalRange() != null) {
                HashMap<String, Object> rangeMap = new HashMap<String, Object>();
                mapping.put("limits", rangeMap);
                rangeMap.put("min_op", dvordinal.getNormalRange().isSetLowerIncluded() ? ">=" : ">");
                rangeMap.put("min", dvordinal.getNormalRange().isSetLower() ? dvordinal.getNormalRange().getLower() : Integer.valueOf(-1));
                rangeMap.put("max_op", dvordinal.getNormalRange().isSetUpperIncluded() ? "<=" : "<");
                rangeMap.put("max", dvordinal.getNormalRange().isSetUpper() ? dvordinal.getNormalRange().getUpper() : Integer.valueOf(-1));
            }
            if (dvordinal.getNormalStatus() != null) {
                HashMap<String, String> statusMap = new HashMap<String, String>();
                mapping.put("normal_status", statusMap);
                CODEPHRASE codephrase = dvordinal.getNormalStatus();
                statusMap.put("terminology", codephrase.getTerminologyId().getValue());
                statusMap.put("code", codephrase.getCodeString());
            }
            mappingList.add(mapping);
        }
        return retmap;
    }
}

