/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt.mapper;

import com.nedap.archie.rm.datavalues.quantity.ProportionKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.ehrbase.opt.TermDefinition;
import org.ehrbase.opt.ValuePoint;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.CINTEGER;
import org.openehr.schemas.v1.COBJECT;
import org.openehr.schemas.v1.CPRIMITIVEOBJECT;
import org.openehr.schemas.v1.CREAL;

public class Proportion {
    static final String type = "DV_PROPORTION";
    CCOMPLEXOBJECT ccomplexobject;
    Map<String, TermDefinition> termDef;

    public Proportion(CCOMPLEXOBJECT ccomplexobject, Map<String, TermDefinition> termDef) {
        this.ccomplexobject = ccomplexobject;
        this.termDef = termDef;
    }

    public Map<String, Object> toMap(String name) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        attributeMap.put("type", type);
        attributeMap.put("attribute_name", name);
        attributeMap.put("mandatory_attributes", new ValuePoint(type).attributes());
        ArrayList<HashMap<String, Object>> valueList = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Cloneable> constraintsMap = new HashMap<String, Cloneable>();
        attributeMap.put("constraint", constraintsMap);
        ArrayList specMap = new ArrayList();
        constraintsMap.put("type", specMap);
        for (CATTRIBUTE attribute : this.ccomplexobject.getAttributesArray()) {
            CREAL cprimitive;
            CPRIMITIVEOBJECT cprimitiveobject;
            HashMap<String, Object> map = new HashMap<String, Object>();
            String attributeName = attribute.getRmAttributeName();
            if (attribute.getRmAttributeName().equals("numerator")) {
                for (COBJECT cobject : attribute.getChildrenArray()) {
                    if (!cobject.getRmTypeName().equals("REAL")) continue;
                    map.put("type", "REAL");
                    cprimitiveobject = (CPRIMITIVEOBJECT)cobject;
                    cprimitive = (CREAL)cprimitiveobject.getItem();
                    if (!cprimitive.isSetRange()) continue;
                    if (cprimitive.getRange().isSetLower()) {
                        map.put("min", Float.valueOf(cprimitive.getRange().getLower()));
                    }
                    if (!cprimitive.getRange().isSetUpper()) continue;
                    map.put("max", Float.valueOf(cprimitive.getRange().getUpper()));
                }
            } else if (attribute.getRmAttributeName().equals("denominator")) {
                for (COBJECT cobject : attribute.getChildrenArray()) {
                    if (!cobject.getRmTypeName().equals("REAL")) continue;
                    map.put("name", "denominator");
                    map.put("type", "REAL");
                    cprimitiveobject = (CPRIMITIVEOBJECT)cobject;
                    cprimitive = (CREAL)cprimitiveobject.getItem();
                    if (!cprimitive.isSetRange()) continue;
                    if (cprimitive.getRange().isSetLower()) {
                        map.put("min", Float.valueOf(cprimitive.getRange().getLower()));
                    }
                    if (!cprimitive.getRange().isSetUpper()) continue;
                    map.put("max", Float.valueOf(cprimitive.getRange().getUpper()));
                }
            } else if (attribute.getRmAttributeName().equals("type")) {
                for (COBJECT cobject : attribute.getChildrenArray()) {
                    if (!cobject.getRmTypeName().equals("INTEGER")) continue;
                    map.put("description", "Indicates semantic type of proportion");
                    map.put("type", "INTEGER");
                    cprimitiveobject = (CPRIMITIVEOBJECT)cobject;
                    cprimitive = (CINTEGER)cprimitiveobject.getItem();
                    if (cprimitive.getListArray().length > 0) {
                        ArrayList kindList = new ArrayList();
                        for (int kind : cprimitive.getListArray()) {
                            HashMap<String, Object> proportionKind = new HashMap<String, Object>();
                            proportionKind.put("value", kind);
                            proportionKind.put("label", Arrays.stream(ProportionKind.values()).filter(k -> k.getPk() == (long)kind).findAny().map(p -> p.name()).orElseThrow(() -> new RuntimeException("Unknown ProportionKind " + kind)));
                            kindList.add(proportionKind);
                        }
                        map.put("values", kindList);
                    }
                    if (!cprimitive.isSetRange()) continue;
                    if (cprimitive.getRange().isSetLower()) {
                        map.put("min", cprimitive.getRange().getLower());
                    }
                    if (!cprimitive.getRange().isSetUpper()) continue;
                    map.put("max", cprimitive.getRange().getUpper());
                }
            }
            if (map.isEmpty()) continue;
            constraintsMap.put(attributeName, map);
        }
        HashMap<String, Object> range = new HashMap<String, Object>();
        constraintsMap.put("occurrence", range);
        range.put("min_op", this.ccomplexobject.getOccurrences().isSetLowerIncluded() ? ">=" : ">");
        range.put("min", this.ccomplexobject.getOccurrences().isSetLower() ? this.ccomplexobject.getOccurrences().getLower() : -1);
        range.put("max_op", this.ccomplexobject.getOccurrences().isSetUpperIncluded() ? "<=" : "<");
        range.put("max", this.ccomplexobject.getOccurrences().isSetUpper() ? this.ccomplexobject.getOccurrences().getUpper() : -1);
        valueList.add(attributeMap);
        return attributeMap;
    }
}

