/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt.mapper;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ehrbase.opt.TermDefinition;
import org.ehrbase.opt.ValuePoint;
import org.ehrbase.service.TerminologyServiceImp;
import org.openehr.schemas.v1.CDVQUANTITY;
import org.openehr.schemas.v1.CQUANTITYITEM;

public class Quantity {
    final String type = "DV_QUANTITY";
    CDVQUANTITY cdq;
    Map<String, TermDefinition> termDef;

    public Quantity(CDVQUANTITY cdq, Map<String, TermDefinition> termDef) {
        this.cdq = cdq;
        this.termDef = termDef;
    }

    public Map toMap(String name) {
        HashMap<String, Object> retmap = new HashMap<String, Object>();
        CQUANTITYITEM[] qtyitems = this.cdq.getListArray();
        retmap.put("mandatory_attributes", new ValuePoint("DV_QUANTITY").attributes());
        retmap.put("type", "DV_QUANTITY");
        retmap.put("attribute_name", name);
        HashMap<String, Serializable> constraintsMap = new HashMap<String, Serializable>();
        retmap.put("constraint", constraintsMap);
        if (this.cdq.isSetAssumedValue()) {
            constraintsMap.put("assumed_value", Double.valueOf(this.cdq.getAssumedValue().getMagnitude()));
        }
        HashMap<String, Object> range = new HashMap<String, Object>();
        constraintsMap.put("occurrence", range);
        range.put("min_op", this.cdq.getOccurrences().isSetLowerIncluded() ? ">=" : ">");
        range.put("min", this.cdq.getOccurrences().isSetLower() ? this.cdq.getOccurrences().getLower() : -1);
        range.put("max_op", this.cdq.getOccurrences().isSetUpperIncluded() ? "<=" : "<");
        range.put("max", this.cdq.getOccurrences().isSetUpper() ? this.cdq.getOccurrences().getUpper() : -1);
        if (this.cdq.getProperty() != null) {
            String code = this.cdq.getProperty().getCodeString();
            String terminology = this.cdq.getProperty().getTerminologyId().getValue();
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            propertyMap.put("code", code);
            propertyMap.put("terminology", terminology);
            if (terminology.equals("openehr")) {
                propertyMap.put("label", TerminologyServiceImp.getInstance().getLabelForCode(code, "en"));
            }
            retmap.put("terminology_binding", propertyMap);
        }
        ArrayList validationList = new ArrayList();
        for (CQUANTITYITEM item : qtyitems) {
            if (qtyitems == null || qtyitems.length == 0) continue;
            HashMap<String, Object> validationMap = new HashMap<String, Object>();
            HashMap<String, Object> rangeMap = new HashMap<String, Object>();
            if (item.getMagnitude() != null) {
                validationMap.put("magnitude", rangeMap);
                rangeMap.put("min_op", item.getMagnitude().isSetLowerIncluded() ? ">=" : ">");
                rangeMap.put("min", Float.valueOf(item.getMagnitude().isSetLower() ? item.getMagnitude().getLower() : -1.0f));
                rangeMap.put("max_op", item.getMagnitude().isSetUpperIncluded() ? "<=" : "<");
                rangeMap.put("max", Float.valueOf(item.getMagnitude().isSetUpper() ? item.getMagnitude().getUpper() : -1.0f));
            }
            validationMap.put("units", item.getUnits());
            validationList.add(validationMap);
        }
        if (!validationList.isEmpty()) {
            constraintsMap.put("validation", validationList);
        }
        return retmap;
    }
}

