/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt.mapper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ehrbase.opt.Generic;
import org.ehrbase.opt.NodeChildren;
import org.ehrbase.opt.NodeId;
import org.ehrbase.opt.TermDefinition;
import org.ehrbase.opt.mapper.AttributeList;
import org.ehrbase.opt.mapper.Constants;
import org.ehrbase.opt.mapper.MandatoryAttributes;
import org.ehrbase.opt.mapper.NodeNameAttribute;
import org.openehr.schemas.v1.CATTRIBUTE;
import org.openehr.schemas.v1.CCOMPLEXOBJECT;
import org.openehr.schemas.v1.CSINGLEATTRIBUTE;

public class Structural {
    CCOMPLEXOBJECT ccomplexobject;
    Map<String, TermDefinition> termDef;
    Map<String, List<Map<String, Object>>> childrenNodeMap;
    String path;
    String nodeId;
    String rmTypeName;
    String archetypeNodeId;

    public Structural(String rmTypeName, String archetypeNodeId, String path, String nodeId, CCOMPLEXOBJECT ccomplexobject, Map<String, TermDefinition> termDef, Map<String, List<Map<String, Object>>> childrenNodeMap) {
        this.ccomplexobject = ccomplexobject;
        this.termDef = termDef;
        this.childrenNodeMap = childrenNodeMap;
        this.path = path;
        this.nodeId = nodeId;
        this.rmTypeName = new Generic(rmTypeName).specialize();
        this.archetypeNodeId = archetypeNodeId;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<Map<String, Object>> embedded = new NodeChildren(this.childrenNodeMap).include(this.path);
        if (embedded == null || embedded.isEmpty()) {
            return null;
        }
        Map<String, Object> mandatoryAttributes = new MandatoryAttributes(this.rmTypeName).toMap();
        if (!mandatoryAttributes.isEmpty()) {
            embedded.addAll(new AttributeList(mandatoryAttributes).toList(this.path));
        }
        HashMap validationMap = new HashMap();
        if (!this.path.isEmpty()) {
            map.put("aql_path", this.path);
        } else if (!"COMPOSITION".equals(this.rmTypeName)) {
            return null;
        }
        if (!validationMap.isEmpty()) {
            map.put("validation", validationMap);
        }
        if (!this.nodeId.isEmpty()) {
            map.put("node_id", this.nodeId);
            map.put("name", this.termDef.get(this.nodeId).getValue());
            map.put("id", new NodeId(this.termDef.get(this.nodeId).getValue()).ehrscape());
            map.put("description", this.termDef.get(this.nodeId).getDescription());
        }
        if (this.ccomplexobject.getOccurrences() != null) {
            map.put("min", this.ccomplexobject.getOccurrences().getLower() == 0 ? (this.ccomplexobject.getOccurrences().getLowerUnbounded() ? -1 : 0) : this.ccomplexobject.getOccurrences().getLower());
            map.put("max", this.ccomplexobject.getOccurrences().getUpper() == 0 ? (this.ccomplexobject.getOccurrences().getUpperUnbounded() ? -1 : 0) : this.ccomplexobject.getOccurrences().getUpper());
        }
        if (this.archetypeNodeId != null) {
            map.put("node_id", this.archetypeNodeId);
        }
        HashMap<String, Object> rangeMap = new HashMap<String, Object>();
        for (CATTRIBUTE cattribute : this.ccomplexobject.getAttributesArray()) {
            String overridenName;
            if (cattribute.getRmAttributeName().equals("value")) {
                validationMap.put("occurrence", rangeMap);
                rangeMap.put("min_op", cattribute.getExistence().isSetLowerIncluded() ? ">=" : ">");
                rangeMap.put("min", cattribute.getExistence().isSetLower() ? cattribute.getExistence().getLower() : -1);
                rangeMap.put("max_op", cattribute.getExistence().isSetUpperIncluded() ? "<=" : "<");
                rangeMap.put("max", cattribute.getExistence().isSetUpper() ? cattribute.getExistence().getUpper() : -1);
                continue;
            }
            if (!(cattribute instanceof CSINGLEATTRIBUTE) || !cattribute.getRmAttributeName().equals("name") || (overridenName = new NodeNameAttribute(cattribute).staticName()) == null) continue;
            map.put("name", overridenName);
            map.put("id", new NodeId(overridenName).ehrscape());
        }
        map.put("children", embedded);
        map.put("type", this.rmTypeName);
        map.put("category", Constants.LITTERAL_STRUCTURE);
        return map;
    }

    public Map<String, List<Map<String, Object>>> trim() {
        return new NodeChildren(this.childrenNodeMap).exclude(this.path);
    }
}

