/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.opt.query;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import org.ehrbase.opt.OptVisitor;
import org.ehrbase.opt.query.I_QueryOptMetaData;
import org.ehrbase.opt.query.MapJson;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;

public class QueryOptMetaData
implements I_QueryOptMetaData {
    Object document;

    private QueryOptMetaData(Object document) {
        this.document = document;
    }

    public static QueryOptMetaData initialize(OPERATIONALTEMPLATE operationaltemplate) throws Exception {
        Map map = new OptVisitor().traverse(operationaltemplate);
        Object document = Configuration.defaultConfiguration().jsonProvider().parse(new MapJson(map).toJson());
        return new QueryOptMetaData(document);
    }

    public static I_QueryOptMetaData getInstance(OPERATIONALTEMPLATE operationaltemplate) throws Exception {
        return QueryOptMetaData.initialize(operationaltemplate);
    }

    public static I_QueryOptMetaData getInstance(String visitor) throws Exception {
        Object document = Configuration.defaultConfiguration().jsonProvider().parse(visitor);
        return new QueryOptMetaData(document);
    }

    public static I_QueryOptMetaData getInstance(Object visitor) throws Exception {
        return new QueryOptMetaData(visitor);
    }

    @Override
    public List upperNotBounded() {
        return (List)JsonPath.read((Object)this.document, (String)"$..children[?(@.max == -1)]", (Predicate[])new Predicate[0]);
    }

    @Override
    public String type(String path) {
        Object childDef;
        Object child = JsonPath.read((Object)this.document, (String)("$..children[?(@.aql_path == '" + path + "')]"), (Predicate[])new Predicate[0]);
        if (child != null && child instanceof JSONArray && ((JSONArray)child).size() > 0 && (childDef = ((JSONArray)child).get(0)) != null && childDef instanceof Map) {
            return (String)((Map)childDef).get("type");
        }
        return null;
    }

    @Override
    public List nodeByFieldValue(String field, String value) {
        return (List)JsonPath.read((Object)this.document, (String)("$..children[?(@." + field + " == '" + value + "')]"), (Predicate[])new Predicate[0]);
    }

    @Override
    public List nodeFieldRegexp(String field, String regexp) {
        return (List)JsonPath.read((Object)this.document, (String)("$..children[?(@." + field + " =~ " + regexp + ")]"), (Predicate[])new Predicate[0]);
    }

    @Override
    public Object getJsonPathVisitor() {
        return this.document;
    }

    @Override
    public String getTemplateConcept() {
        return (String)((Map)this.document).get("concept");
    }

    @Override
    public String getTemplateId() {
        return (String)((Map)this.document).get("template_id");
    }
}

