/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.util.UUID;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_PartyIdentifiedAccess;
import org.ehrbase.dao.access.interfaces.I_SystemAccess;
import org.ehrbase.dao.access.support.ServiceDataAccess;
import org.ehrbase.service.KnowledgeCacheService;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Value;

public class BaseService {
    public static final String DEMOGRAPHIC = "DEMOGRAPHIC";
    public static final String PARTY = "PARTY";
    @Value(value="${system.type}")
    private String systemType = "POSTGRES";
    @Value(value="${spring.datasource.url}")
    private String datasourceUrl = "url";
    @Value(value="${spring.datasource.password}")
    private String datasourcePass = "luis";
    @Value(value="${spring.datasource.username}")
    private String datasourceUser = "luis";
    private final ServerConfig serverConfig;
    private final KnowledgeCacheService knowledgeCacheService;
    private final DSLContext context;

    public BaseService(KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig) {
        this.knowledgeCacheService = knowledgeCacheService;
        this.context = context;
        this.serverConfig = serverConfig;
    }

    protected I_DomainAccess getDataAccess() {
        return new ServiceDataAccess(this.context, this.knowledgeCacheService, this.knowledgeCacheService, this.serverConfig);
    }

    public UUID getSystemUuid() {
        return I_SystemAccess.createOrRetrieveLocalSystem(this.getDataAccess());
    }

    protected UUID getUserUuid() {
        return I_PartyIdentifiedAccess.getOrCreatePartyByExternalRef(this.getDataAccess(), null, "cbf741ff-9480-4792-8894-13fc5f818b6d", DEMOGRAPHIC, "User", PARTY);
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }
}

