/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.composition.Composition;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.definitions.CompositionFormat;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.definitions.StructuredString;
import org.ehrbase.api.definitions.StructuredStringFormat;
import org.ehrbase.api.dto.CompositionDto;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.UnexpectedSwitchCaseException;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.api.service.ValidationService;
import org.ehrbase.dao.access.interfaces.I_CompositionAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_EntryAccess;
import org.ehrbase.dao.access.jooq.CompoXRefAccess;
import org.ehrbase.serialisation.CanonicalJson;
import org.ehrbase.serialisation.CanonicalXML;
import org.ehrbase.service.BaseService;
import org.ehrbase.service.KnowledgeCacheService;
import org.ehrbase.validation.constraints.wrappers.ValidationException;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CompositionServiceImp
extends BaseService
implements CompositionService {
    public static final String DESCRIPTION = "description";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean supportCompositionXRef = false;
    private final ValidationService validationService;
    private final EhrService ehrService;

    @Autowired
    public CompositionServiceImp(KnowledgeCacheService knowledgeCacheService, ValidationService validationService, EhrService ehrService, DSLContext context, ServerConfig serverConfig) {
        super(knowledgeCacheService, context, serverConfig);
        this.validationService = validationService;
        this.ehrService = ehrService;
    }

    public Optional<CompositionDto> retrieve(UUID compositionId, Integer version) throws InternalServerException {
        I_CompositionAccess compositionAccess = version != null ? I_CompositionAccess.retrieveCompositionVersion(this.getDataAccess(), compositionId, version) : I_CompositionAccess.retrieveCompositionVersion(this.getDataAccess(), compositionId, this.getLastVersionNumber(compositionId));
        return this.getCompositionDto(compositionAccess);
    }

    public Optional<CompositionDto> retrieveByTimestamp(UUID compositionId, LocalDateTime timestamp) {
        I_CompositionAccess compositionAccess;
        try {
            compositionAccess = I_CompositionAccess.retrieveInstanceByTimestamp(this.getDataAccess(), compositionId, Timestamp.valueOf(timestamp));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new InternalServerException(e);
        }
        return this.getCompositionDto(compositionAccess);
    }

    private Optional<CompositionDto> getCompositionDto(I_CompositionAccess compositionAccess) {
        if (compositionAccess == null) {
            return Optional.empty();
        }
        UUID ehrId = compositionAccess.getEhrid();
        return compositionAccess.getContent().stream().findAny().map(i -> new CompositionDto(i.getComposition(), i.getTemplateId(), i.getCompositionId(), ehrId));
    }

    public StructuredString serialize(CompositionDto composition, CompositionFormat format) {
        StructuredString compositionString;
        switch (format) {
            case XML: {
                compositionString = new StructuredString(new CanonicalXML().marshal((RMObject)composition.getComposition(), Boolean.valueOf(false)), StructuredStringFormat.XML);
                break;
            }
            case JSON: {
                compositionString = new StructuredString(new CanonicalJson().marshal((RMObject)composition.getComposition()), StructuredStringFormat.JSON);
                break;
            }
            default: {
                throw new UnexpectedSwitchCaseException((Enum)format);
            }
        }
        return compositionString;
    }

    public UUID create(UUID ehrId, String content, CompositionFormat format) {
        Composition composition = this.buildComposition(content, format);
        return this.internalCreate(ehrId, composition, null);
    }

    public UUID create(UUID ehrId, String content, CompositionFormat format, String templateId, UUID linkUid) {
        return this.create(ehrId, content, format);
    }

    public UUID create(UUID ehrId, Composition composition, UUID contributionId) {
        return this.internalCreate(ehrId, composition, contributionId);
    }

    private UUID internalCreate(UUID ehrId, Composition composition, UUID contributionId) {
        UUID compositionId;
        try {
            this.validationService.check(composition);
        }
        catch (Exception e) {
            if (e.getClass().equals(UnprocessableEntityException.class)) {
                throw (UnprocessableEntityException)e;
            }
            if (e.getClass().equals(IllegalArgumentException.class)) {
                throw new org.ehrbase.api.exception.ValidationException(e);
            }
            if (e.getClass().equals(ValidationException.class)) {
                throw new org.ehrbase.api.exception.ValidationException(e);
            }
            throw new InternalServerException(e);
        }
        if (this.ehrService.hasEhr(ehrId).equals(Boolean.FALSE)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrId.toString());
        }
        try {
            I_CompositionAccess compositionAccess = I_CompositionAccess.getNewInstance(this.getDataAccess(), composition, ehrId);
            I_EntryAccess entryAccess = I_EntryAccess.getNewInstance(this.getDataAccess(), Objects.requireNonNull(composition.getArchetypeDetails().getTemplateId()).getValue(), 0, compositionAccess.getId(), composition);
            compositionAccess.addContent(entryAccess);
            if (contributionId != null) {
                compositionAccess.setContributionId(contributionId);
                compositionId = compositionAccess.commitWithCustomContribution(this.getUserUuid(), this.getSystemUuid(), DESCRIPTION);
            } else {
                compositionId = compositionAccess.commit(this.getUserUuid(), this.getSystemUuid(), DESCRIPTION);
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw new IllegalArgumentException(e);
            }
            throw new InternalServerException(e);
        }
        return compositionId;
    }

    private Composition buildComposition(String content, CompositionFormat format) {
        Composition composition;
        switch (format) {
            case XML: {
                composition = (Composition)new CanonicalXML().unmarshal(content, Composition.class);
                break;
            }
            case JSON: {
                composition = (Composition)new CanonicalJson().unmarshal(content, Composition.class);
                break;
            }
            default: {
                throw new UnexpectedSwitchCaseException((Enum)format);
            }
        }
        return composition;
    }

    public String update(UUID compositionId, CompositionFormat format, String content) {
        return this.update(compositionId, format, content, null);
    }

    public String update(UUID compositionId, CompositionFormat format, String content, String templateId) {
        Composition composition = this.buildComposition(content, format);
        return this.internalUpdate(compositionId, composition, null);
    }

    public String update(UUID compositionId, Composition composition, UUID contributionId) {
        return this.internalUpdate(compositionId, composition, contributionId);
    }

    private String internalUpdate(UUID compositionId, Composition composition, UUID contributionId) {
        Boolean result;
        try {
            I_CompositionAccess compositionAccess = I_CompositionAccess.retrieveInstance(this.getDataAccess(), compositionId);
            if (compositionAccess == null) {
                throw new ObjectNotFoundException(I_CompositionAccess.class.getName(), "Could not find composition: " + compositionId);
            }
            this.validationService.check(composition);
            String existingTemplateId = compositionAccess.getContent().get(0).getTemplateId();
            String inputTemplateId = composition.getArchetypeDetails().getTemplateId().getValue();
            if (!existingTemplateId.equals(inputTemplateId)) {
                if (!existingTemplateId.split("\\.")[0].equals(inputTemplateId.split("\\.")[0])) {
                    throw new InvalidApiParameterException("Can't update composition to have different template.");
                }
                int existingTemplateIdVersion = Integer.parseInt(existingTemplateId.split("\\.v")[1]);
                int inputTemplateIdVersion = Integer.parseInt(inputTemplateId.substring(inputTemplateId.lastIndexOf("\\.v") + 1));
                if (inputTemplateIdVersion < existingTemplateIdVersion) {
                    throw new InvalidApiParameterException("Can't update composition with wrong template version bump.");
                }
            }
            List<I_EntryAccess> contentList = compositionAccess.getContent();
            contentList.get(0).setCompositionData(composition);
            compositionAccess.setContent(contentList);
            compositionAccess.setComposition(composition);
            if (contributionId != null) {
                compositionAccess.setContributionId(contributionId);
                result = compositionAccess.updateWithCustomContribution(this.getUserUuid(), this.getSystemUuid(), I_ConceptAccess.ContributionChangeType.MODIFICATION, null);
            } else {
                result = compositionAccess.update(this.getUserUuid(), this.getSystemUuid(), null, I_ConceptAccess.ContributionChangeType.MODIFICATION, DESCRIPTION);
            }
        }
        catch (InvalidApiParameterException | ObjectNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalServerException(e);
        }
        if (!result.booleanValue()) {
            throw new InternalServerException("Update failed on composition:" + compositionId);
        }
        return compositionId + "::" + this.getLastVersionNumber(compositionId);
    }

    public LocalDateTime delete(UUID compositionId) {
        return this.internalDelete(compositionId, null);
    }

    public LocalDateTime delete(UUID compositionId, UUID contributionId) {
        return this.internalDelete(compositionId, contributionId);
    }

    private LocalDateTime internalDelete(UUID compositionId, UUID contributionId) {
        Integer result;
        I_CompositionAccess compositionAccess;
        try {
            compositionAccess = I_CompositionAccess.retrieveInstance(this.getDataAccess(), compositionId);
        }
        catch (Exception e) {
            throw new ObjectNotFoundException(I_CompositionAccess.class.getName(), "Error while retrieving composition", (Throwable)e);
        }
        if (compositionAccess == null) {
            throw new ObjectNotFoundException(I_CompositionAccess.class.getName(), "Could not find composition:" + compositionId);
        }
        if (contributionId != null) {
            compositionAccess.setContributionId(contributionId);
            try {
                result = compositionAccess.deleteWithCustomContribution(this.getUserUuid(), this.getSystemUuid(), DESCRIPTION);
            }
            catch (Exception e) {
                throw new InternalServerException(e);
            }
        }
        try {
            result = compositionAccess.delete(this.getUserUuid(), this.getSystemUuid(), DESCRIPTION);
        }
        catch (Exception e) {
            throw new InternalServerException(e);
        }
        if (result <= 0) {
            throw new InternalServerException("Delete failed on composition:" + compositionAccess.getId());
        }
        return compositionAccess.getTimeCommitted().toLocalDateTime();
    }

    public Integer getLastVersionNumber(UUID compositionId) throws InternalServerException {
        try {
            return I_CompositionAccess.getLastVersionNumber(this.getDataAccess(), compositionId);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new InternalServerException(e);
        }
    }

    public Integer getVersionByTimestamp(UUID compositionId, LocalDateTime timestamp) {
        int version;
        try {
            version = I_CompositionAccess.getVersionFromTimeStamp(this.getDataAccess(), compositionId, Timestamp.valueOf(timestamp));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw e;
        }
        if (version <= 0) {
            return null;
        }
        return version;
    }

    private void linkComposition(UUID master, UUID child) {
        if (!this.supportCompositionXRef) {
            return;
        }
        if (master == null || child == null) {
            return;
        }
        CompoXRefAccess compoXrefAccess = new CompoXRefAccess(this.getDataAccess());
        compoXrefAccess.setLink(master, child);
    }

    public String getUidFromInputComposition(String content, CompositionFormat format) throws IllegalArgumentException, InternalServerException, UnexpectedSwitchCaseException {
        Composition composition = this.buildComposition(content, format);
        if (composition.getUid() == null) {
            return null;
        }
        return composition.getUid().toString();
    }

    public boolean exists(UUID versionedObjectId) {
        return I_CompositionAccess.exists(this.getDataAccess(), versionedObjectId);
    }

    public boolean isDeleted(UUID versionedObjectId) {
        return I_CompositionAccess.isDeleted(this.getDataAccess(), versionedObjectId);
    }
}

