/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.changecontrol.Version;
import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.definitions.CompositionFormat;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.dto.CompositionDto;
import org.ehrbase.api.dto.ContributionDto;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.UnexpectedSwitchCaseException;
import org.ehrbase.api.service.CompositionService;
import org.ehrbase.api.service.ContributionService;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.dao.access.interfaces.I_AuditDetailsAccess;
import org.ehrbase.dao.access.interfaces.I_CompositionAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_PartyIdentifiedAccess;
import org.ehrbase.dao.access.jooq.AuditDetailsAccess;
import org.ehrbase.service.BaseService;
import org.ehrbase.service.ContributionServiceHelper;
import org.ehrbase.service.KnowledgeCacheService;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ContributionServiceImp
extends BaseService
implements ContributionService {
    public static final String TYPE_COMPOSITION = "COMPOSITION";
    public static final String TYPE_FOLDER = "FOLDER";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final CompositionService compositionService;
    private final EhrService ehrService;

    @Autowired
    public ContributionServiceImp(KnowledgeCacheService knowledgeCacheService, CompositionService compositionService, EhrService ehrService, DSLContext context, ServerConfig serverConfig) {
        super(knowledgeCacheService, context, serverConfig);
        this.compositionService = compositionService;
        this.ehrService = ehrService;
    }

    public boolean hasContribution(UUID ehrId, UUID contributionId) {
        I_ContributionAccess contributionAccess;
        if (this.ehrService.hasEhr(ehrId).equals(Boolean.FALSE)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrId.toString());
        }
        try {
            contributionAccess = I_ContributionAccess.retrieveInstance(this.getDataAccess(), contributionId);
        }
        catch (InternalServerException e) {
            return false;
        }
        if (contributionAccess == null) {
            return false;
        }
        return contributionAccess.getEhrId().equals(ehrId);
    }

    public Optional<ContributionDto> getContribution(UUID ehrId, UUID contributionId) {
        if (!this.hasContribution(ehrId, contributionId)) {
            throw new ObjectNotFoundException("contribution", "Contribution with given ID does not exist");
        }
        ContributionDto contribution = new ContributionDto(contributionId, this.retrieveUuidsOfContributionObjects(contributionId), this.retrieveAuditDetails(contributionId));
        return Optional.of(contribution);
    }

    public UUID commitContribution(UUID ehrId, String content, CompositionFormat format) {
        if (this.ehrService.hasEhr(ehrId).equals(Boolean.FALSE)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrId.toString());
        }
        I_ContributionAccess contributionAccess = I_ContributionAccess.getInstance(this.getDataAccess(), ehrId);
        AuditDetails audit = ContributionServiceHelper.parseAuditDetails(content, format);
        contributionAccess.setAuditDetailsValues(audit);
        UUID contributionId = contributionAccess.commit(null, null, null);
        List<Version> versions = ContributionServiceHelper.parseVersions(content, format);
        if (versions.isEmpty()) {
            throw new InvalidApiParameterException("Invalid Contribution, must have at least one Version object.");
        }
        for (Version version : versions) {
            Object versionData = version.getData();
            if (versionData != null) {
                if (!(versionData instanceof LinkedHashMap)) {
                    throw new IllegalArgumentException("Contribution input can't be processed");
                }
                RMObject versionRmObject = ContributionServiceHelper.unmarshalMapContentToRmObject((LinkedHashMap)versionData, format);
                SupportedClasses versionClass = SupportedClasses.valueOf(versionRmObject.getClass().getSimpleName().toUpperCase());
                switch (versionClass) {
                    case COMPOSITION: {
                        this.processCompositionVersion(ehrId, contributionId, version, (Composition)versionRmObject);
                        break;
                    }
                    default: {
                        throw new UnexpectedSwitchCaseException((Enum)versionClass);
                    }
                }
                continue;
            }
            this.processMetadataVersion(ehrId, contributionId, version);
        }
        return contributionId;
    }

    private void processCompositionVersion(UUID ehrId, UUID contributionId, Version version, Composition versionRmObject) {
        I_ConceptAccess.ContributionChangeType changeType = I_ConceptAccess.ContributionChangeType.valueOf(version.getCommitAudit().getChangeType().getValue().toUpperCase());
        switch (changeType) {
            case CREATION: {
                this.compositionService.create(ehrId, versionRmObject, contributionId);
                break;
            }
            case AMENDMENT: 
            case MODIFICATION: {
                this.compositionService.update(this.getVersionedUidFromVersion(version), versionRmObject, contributionId);
                break;
            }
            case DELETED: {
                this.compositionService.delete(this.getVersionedUidFromVersion(version), contributionId);
                break;
            }
            default: {
                throw new UnexpectedSwitchCaseException((Enum)changeType);
            }
        }
    }

    private void processMetadataVersion(UUID ehrId, UUID contributionId, Version version) {
        I_ConceptAccess.ContributionChangeType changeType = I_ConceptAccess.ContributionChangeType.valueOf(version.getCommitAudit().getChangeType().getValue().toUpperCase());
        switch (changeType) {
            case DELETED: {
                UUID objectUid = this.getVersionedUidFromVersion(version);
                try {
                    CompositionDto compo = (CompositionDto)this.compositionService.retrieve(objectUid, null).orElseThrow(Exception::new);
                    this.compositionService.delete(compo.getUuid());
                    break;
                }
                catch (Exception e) {
                    throw new ObjectNotFoundException(I_CompositionAccess.class.getName(), "Couldn't find object matching id: " + objectUid);
                }
            }
            default: {
                throw new UnexpectedSwitchCaseException((Enum)changeType);
            }
        }
    }

    private UUID getVersionedUidFromVersion(Version version) {
        ObjectVersionId precedingVersionUid = version.getPrecedingVersionUid();
        if (precedingVersionUid == null) {
            throw new IllegalArgumentException("Input invalid. Composition can't be modified without pointer to precedingVersionUid in Version container.");
        }
        if (precedingVersionUid.toString().split("::").length != 3) {
            throw new IllegalArgumentException("Input invalid. Given precedingVersionUid is not a versionUid.");
        }
        String versionedUid = precedingVersionUid.toString().split("::")[0];
        return UUID.fromString(versionedUid);
    }

    private Map<String, String> retrieveUuidsOfContributionObjects(UUID contribution) {
        HashMap<String, String> objRefs = new HashMap<String, String>();
        Map<I_CompositionAccess, Integer> compositions = I_CompositionAccess.retrieveInstancesInContribution(this.getDataAccess(), contribution);
        compositions.forEach((k, v) -> objRefs.put(k.getId() + "::" + this.getServerConfig().getNodename() + "::" + v, TYPE_COMPOSITION));
        return objRefs;
    }

    private AuditDetails retrieveAuditDetails(UUID contributionId) {
        UUID auditId = I_ContributionAccess.retrieveInstance(this.getDataAccess(), contributionId).getHasAuditDetails();
        I_AuditDetailsAccess auditDetailsAccess = new AuditDetailsAccess(this.getDataAccess()).retrieveInstance(this.getDataAccess(), auditId);
        String systemId = auditDetailsAccess.getSystemId().toString();
        PartyProxy committer = I_PartyIdentifiedAccess.retrievePartyIdentified(this.getDataAccess(), auditDetailsAccess.getCommitter());
        DvDateTime timeCommitted = new DvDateTime((TemporalAccessor)LocalDateTime.ofInstant(auditDetailsAccess.getTimeCommitted().toInstant(), ZoneId.of(auditDetailsAccess.getTimeCommittedTzId())));
        int changeTypeCode = I_ConceptAccess.ContributionChangeType.valueOf(auditDetailsAccess.getChangeType().getLiteral().toUpperCase()).getCode();
        DvCodedText changeType = new DvCodedText(auditDetailsAccess.getChangeType().getLiteral(), new CodePhrase(new TerminologyId("audit change type"), String.valueOf(changeTypeCode)));
        DvText description = new DvText(auditDetailsAccess.getDescription());
        return new AuditDetails(systemId, committer, timeCommitted, changeType, description);
    }

    static enum SupportedClasses {
        COMPOSITION;

    }
}

