/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.changecontrol.OriginalVersion;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.datavalues.quantity.datetime.DvDateTime;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.ehr.VersionedEhrStatus;
import com.nedap.archie.rm.generic.Attestation;
import com.nedap.archie.rm.generic.AuditDetails;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartySelf;
import com.nedap.archie.rm.generic.RevisionHistory;
import com.nedap.archie.rm.generic.RevisionHistoryItem;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.PartyRef;
import com.nedap.archie.rm.support.identification.TerminologyId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.definitions.CompositionFormat;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.definitions.StructuredString;
import org.ehrbase.api.definitions.StructuredStringFormat;
import org.ehrbase.api.dto.EhrStatusDto;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.api.service.EhrService;
import org.ehrbase.dao.access.interfaces.I_AttestationAccess;
import org.ehrbase.dao.access.interfaces.I_AuditDetailsAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_EhrAccess;
import org.ehrbase.dao.access.interfaces.I_PartyIdentifiedAccess;
import org.ehrbase.dao.access.interfaces.I_StatusAccess;
import org.ehrbase.dao.access.jooq.AttestationAccess;
import org.ehrbase.serialisation.CanonicalJson;
import org.ehrbase.service.BaseService;
import org.ehrbase.service.KnowledgeCacheService;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class EhrServiceImp
extends BaseService
implements EhrService {
    public static final String MODIFIABLE = "modifiable";
    public static final String QUERYABLE = "queryable";
    public static final String SUBJECT_ID = "subjectId";
    public static final String SUBJECT_NAMESPACE = "subjectNamespace";
    public static final String DESCRIPTION = "description";
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public EhrServiceImp(KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig) {
        super(knowledgeCacheService, context, serverConfig);
    }

    public UUID create(EhrStatus status, UUID ehrId) {
        if (status == null) {
            status = new EhrStatus();
            PartySelf partySelf = new PartySelf(new PartyRef((ObjectId)new HierObjectId(UUID.randomUUID().toString()), "default", null));
            status.setSubject(partySelf);
            status.setModifiable(true);
            status.setQueryable(true);
        }
        status.setUid((UIDBasedId)new HierObjectId(UUID.randomUUID().toString()));
        if (status.getSubject().getExternalRef() == null) {
            status.setSubject(new PartySelf(new PartyRef((ObjectId)new HierObjectId(UUID.randomUUID().toString()), "default", null)));
        }
        String subjectId = status.getSubject().getExternalRef().getId().getValue();
        String subjectNamespace = status.getSubject().getExternalRef().getNamespace();
        UUID subjectUuid = I_PartyIdentifiedAccess.getOrCreatePartyByExternalRef(this.getDataAccess(), null, subjectId, "DEMOGRAPHIC", subjectNamespace, "PARTY");
        UUID systemId = this.getSystemUuid();
        UUID committerId = this.getUserUuid();
        if (I_EhrAccess.checkExist(this.getDataAccess(), subjectUuid)) {
            throw new StateConflictException("Specified party has already an EHR set (partyId=" + subjectUuid + ")");
        }
        try {
            I_EhrAccess ehrAccess = I_EhrAccess.getInstance(this.getDataAccess(), subjectUuid, systemId, null, null, ehrId);
            ehrAccess.setStatus(status);
            return ehrAccess.commit(committerId, systemId, DESCRIPTION);
        }
        catch (Exception e) {
            throw new InternalServerException("Could not create an EHR with given parameters.", e);
        }
    }

    public Optional<EhrStatusDto> getEhrStatusEhrScape(UUID ehrUuid, CompositionFormat format) {
        EhrStatusDto statusDto = new EhrStatusDto();
        try {
            I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrUuid);
            if (ehrAccess == null) {
                return Optional.empty();
            }
            I_PartyIdentifiedAccess party = I_PartyIdentifiedAccess.retrieveInstance(this.getDataAccess(), ehrAccess.getParty());
            statusDto.setSubjectId(party.getPartyRefValue());
            statusDto.setSubjectNamespace(party.getPartyRefNamespace());
            statusDto.setModifiable(ehrAccess.isModifiable().booleanValue());
            statusDto.setQueryable(ehrAccess.isQueryable().booleanValue());
            statusDto.setOtherDetails(new StructuredString(new CanonicalJson().marshal((RMObject)ehrAccess.getOtherDetails()), StructuredStringFormat.JSON));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new InternalServerException(e);
        }
        return Optional.of(statusDto);
    }

    public Optional<EhrStatus> getEhrStatus(UUID ehrUuid) {
        if (this.hasEhr(ehrUuid).equals(Boolean.FALSE)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrUuid.toString());
        }
        try {
            I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrUuid);
            if (ehrAccess == null) {
                return Optional.empty();
            }
            return Optional.of(ehrAccess.getStatus());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new InternalServerException(e);
        }
    }

    public Optional<OriginalVersion<EhrStatus>> getEhrStatusAtVersion(UUID ehrUuid, UUID versionedObjectUid, int version) {
        if (this.hasEhr(ehrUuid).equals(Boolean.FALSE)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrUuid.toString());
        }
        I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstanceByStatus(this.getDataAccess(), ehrUuid, versionedObjectUid, version);
        if (ehrAccess == null) {
            return Optional.empty();
        }
        ObjectVersionId versionId = new ObjectVersionId(versionedObjectUid + "::" + this.getServerConfig().getNodename() + "::" + version);
        DvCodedText lifecycleState = new DvCodedText("TODO", new CodePhrase("TODO"));
        AuditDetails commitAudit = ehrAccess.getStatusAccess().getAuditDetailsAccess().getAsAuditDetails();
        ObjectRef contribution = new ObjectRef((ObjectId)new HierObjectId(ehrAccess.getStatusAccess().getStatusRecord().getInContribution().toString()), "openehr", "contribution");
        List<UUID> attestationIdList = I_AttestationAccess.retrieveListOfAttestationsByRef(this.getDataAccess(), ehrAccess.getStatusAccess().getStatusRecord().getAttestationRef());
        ArrayList<Attestation> attestations = null;
        if (!attestationIdList.isEmpty()) {
            attestations = new ArrayList<Attestation>();
            for (UUID id : attestationIdList) {
                I_AttestationAccess a = new AttestationAccess(this.getDataAccess()).retrieveInstance(id);
                attestations.add(a.getAsAttestation());
            }
        }
        OriginalVersion versionStatus = new OriginalVersion(versionId, null, (Object)ehrAccess.getStatus(), lifecycleState, commitAudit, contribution, null, null, attestations);
        return Optional.of(versionStatus);
    }

    public Optional<EhrStatus> updateStatus(UUID ehrId, EhrStatus status) {
        I_EhrAccess ehrAccess;
        if (this.hasEhr(ehrId).equals(Boolean.FALSE)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrId.toString());
        }
        try {
            ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrId);
        }
        catch (Exception e) {
            throw new InternalServerException(e);
        }
        if (ehrAccess == null) {
            return Optional.empty();
        }
        if (status != null) {
            ehrAccess.setStatus(status);
        }
        if (ehrAccess.update(this.getUserUuid(), this.getSystemUuid(), null, I_ConceptAccess.ContributionChangeType.MODIFICATION, DESCRIPTION).equals(false)) {
            throw new InternalServerException("Problem updating EHR_STATUS");
        }
        return this.getEhrStatus(ehrId);
    }

    public Optional<UUID> findBySubject(String subjectId, String nameSpace) {
        UUID subjectUuid = I_PartyIdentifiedAccess.findReferencedParty(this.getDataAccess(), subjectId, "DEMOGRAPHIC", nameSpace, "PARTY");
        return Optional.ofNullable(I_EhrAccess.retrieveInstanceBySubject(this.getDataAccess(), subjectUuid));
    }

    public boolean doesEhrExist(UUID ehrId) {
        Optional<I_EhrAccess> ehrAccess = Optional.ofNullable(I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrId));
        return ehrAccess.isPresent();
    }

    public LocalDateTime getCreationTime(UUID ehrId) {
        if (this.hasEhr(ehrId).equals(Boolean.FALSE)) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrId.toString());
        }
        try {
            I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrId);
            return ehrAccess.getEhrRecord().getDateCreated().toLocalDateTime();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new InternalServerException(e);
        }
    }

    public Integer getEhrStatusVersionByTimestamp(UUID ehrUid, Timestamp timestamp) {
        I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrUid);
        return ehrAccess.getEhrStatusVersionFromTimeStamp(timestamp);
    }

    public String getLatestVersionUidOfStatus(UUID ehrStatusId) {
        try {
            I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrStatusId);
            UUID statusId = ehrAccess.getStatusId();
            Integer version = ehrAccess.getLastVersionNumberOfStatus(this.getDataAccess(), statusId);
            return statusId.toString() + "::" + this.getServerConfig().getNodename() + "::" + version;
        }
        catch (Exception e) {
            throw new InternalServerException(e);
        }
    }

    public UUID getEhrStatusVersionedObjectUidByEhr(UUID ehrUid) {
        I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrUid);
        return ehrAccess.getStatusId();
    }

    public Boolean hasEhr(UUID ehrId) {
        I_EhrAccess ehrAccess;
        try {
            ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrId);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return ehrAccess != null;
    }

    public VersionedEhrStatus getVersionedEhrStatus(UUID ehrUid) {
        Optional<EhrStatus> ehrStatus = this.getEhrStatus(ehrUid);
        VersionedEhrStatus versionedEhrStatus = new VersionedEhrStatus();
        if (ehrStatus.isPresent()) {
            versionedEhrStatus.setUid(new HierObjectId(ehrStatus.get().getUid().toString()));
            versionedEhrStatus.setOwnerId(new ObjectRef((ObjectId)new HierObjectId(ehrUid.toString()), "local", "EHR"));
            I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrUid);
            versionedEhrStatus.setTimeCreated(new DvDateTime((TemporalAccessor)OffsetDateTime.of(ehrAccess.getInitialTimeOfVersionedEhrStatus().toLocalDateTime(), OffsetDateTime.now().getOffset())));
        }
        return versionedEhrStatus;
    }

    public RevisionHistory getRevisionHistoryOfVersionedEhrStatus(UUID ehrUid) {
        I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrUid);
        int versions = ehrAccess.getNumberOfEhrStatusVersions();
        UUID versionedObjectUid = this.getEhrStatusVersionedObjectUidByEhr(ehrUid);
        RevisionHistory revisionHistory = new RevisionHistory();
        for (int i = 1; i <= versions; ++i) {
            Optional<OriginalVersion<EhrStatus>> ehrStatus = this.getEhrStatusAtVersion(ehrUid, versionedObjectUid, i);
            if (!ehrStatus.isPresent()) continue;
            revisionHistory.addItem(this.revisionHistoryItemfromEhrStatus(ehrUid, ehrStatus.get(), i));
        }
        if (revisionHistory.getItems().isEmpty()) {
            throw new InternalServerException("Problem creating RevisionHistory");
        }
        return revisionHistory;
    }

    private RevisionHistoryItem revisionHistoryItemfromEhrStatus(UUID ehrId, OriginalVersion<EhrStatus> ehrStatus, int version) {
        String statusId = ehrStatus.getUid().getValue().split("::")[0];
        ObjectVersionId objectVersionId = new ObjectVersionId(statusId + "::" + this.getServerConfig().getNodename() + "::" + version);
        ArrayList<AuditDetails> auditDetailsList = new ArrayList<AuditDetails>();
        I_StatusAccess statusAccess = I_StatusAccess.retrieveInstance(this.getDataAccess(), UUID.fromString(statusId));
        I_AuditDetailsAccess commitAuditAccess = statusAccess.getAuditDetailsAccess();
        String systemId = commitAuditAccess.getSystemId().toString();
        PartyProxy committer = I_PartyIdentifiedAccess.retrievePartyIdentified(this.getDataAccess(), commitAuditAccess.getCommitter());
        DvDateTime timeCommitted = new DvDateTime((TemporalAccessor)commitAuditAccess.getTimeCommitted().toLocalDateTime());
        DvCodedText changeType = new DvCodedText(commitAuditAccess.getChangeType().getLiteral(), new CodePhrase(new TerminologyId("openehr"), "String"));
        DvText description = new DvText(commitAuditAccess.getDescription());
        AuditDetails commitAudit = new AuditDetails(systemId, committer, timeCommitted, changeType, description);
        auditDetailsList.add(commitAudit);
        if (ehrStatus.getAttestations() != null) {
            for (Attestation a : ehrStatus.getAttestations()) {
                AuditDetails newAudit = new AuditDetails(a.getSystemId(), a.getCommitter(), a.getTimeCommitted(), a.getChangeType(), a.getDescription());
                auditDetailsList.add(newAudit);
            }
        }
        return new RevisionHistoryItem(objectVersionId, auditDetailsList);
    }

    public UUID getDirectoryId(UUID ehrId) {
        try {
            I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrId);
            return ehrAccess.getDirectoryId();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new InternalServerException(e.getMessage(), e);
        }
    }
}

