/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.RMObject;
import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Formatter;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.definitions.StructuredString;
import org.ehrbase.api.definitions.StructuredStringFormat;
import org.ehrbase.api.dto.FolderDto;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.exception.UnexpectedSwitchCaseException;
import org.ehrbase.api.service.FolderService;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_EhrAccess;
import org.ehrbase.dao.access.interfaces.I_FolderAccess;
import org.ehrbase.dao.access.jooq.FolderAccess;
import org.ehrbase.dao.access.jooq.FolderHistoryAccess;
import org.ehrbase.dao.access.util.FolderUtils;
import org.ehrbase.serialisation.CanonicalJson;
import org.ehrbase.serialisation.CanonicalXML;
import org.ehrbase.service.BaseService;
import org.ehrbase.service.KnowledgeCacheService;
import org.joda.time.DateTime;
import org.jooq.DSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FolderServiceImp
extends BaseService
implements FolderService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Formatter formatter = new Formatter();

    @Autowired
    FolderServiceImp(KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig) {
        super(knowledgeCacheService, context, serverConfig);
    }

    public UUID create(UUID ehrId, Folder content) {
        I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrId);
        if (ehrAccess == null) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrId.toString());
        }
        FolderUtils.checkSiblingNameConflicts(content);
        DateTime currentTimeStamp = DateTime.now();
        I_ContributionAccess contributionAccess = I_ContributionAccess.getInstance(this.getDataAccess(), ehrId);
        I_FolderAccess folderAccess = FolderAccess.buildNewFolderAccessHierarchy(this.getDataAccess(), content, currentTimeStamp, ehrId, contributionAccess);
        UUID folderId = folderAccess.commit(new Timestamp(currentTimeStamp.getMillis()));
        ehrAccess.setDirectory(folderId);
        ehrAccess.update(this.getUserUuid(), this.getSystemUuid(), null, I_ConceptAccess.ContributionChangeType.MODIFICATION, "description");
        return folderId;
    }

    public Optional<FolderDto> retrieveLatest(UUID ehrId, String path) {
        I_EhrAccess ehrAccess = I_EhrAccess.retrieveInstance(this.getDataAccess(), ehrId);
        if (ehrAccess == null) {
            throw new ObjectNotFoundException("ehr", "No EHR found with given ID: " + ehrId.toString());
        }
        return this.retrieve(ehrAccess.getDirectoryId(), null, path);
    }

    public Optional<FolderDto> retrieve(UUID folderId, Integer version, String path) {
        I_FolderAccess folderAccess = I_FolderAccess.retrieveInstanceForExistingFolder(this.getDataAccess(), folderId);
        folderAccess = this.extractPath(folderAccess, path);
        return this.createDto(folderAccess);
    }

    public Optional<FolderDto> retrieveByTimestamp(UUID folderId, Timestamp timestamp, String path) {
        try {
            FolderHistoryAccess folderHistoryAccess = new FolderHistoryAccess(this.getDataAccess());
            I_FolderAccess folderAccess = FolderHistoryAccess.retrieveInstanceForExistingFolder(folderHistoryAccess, folderId, timestamp);
            folderAccess = this.extractPath(folderAccess, path);
            return this.createDto(folderAccess);
        }
        catch (ObjectNotFoundException e) {
            this.logger.error(this.formatter.format("Folder entry not found for timestamp: %s", timestamp.toLocalDateTime().format(DateTimeFormatter.ISO_DATE_TIME)).toString());
            return Optional.empty();
        }
    }

    public Optional<FolderDto> update(UUID folderId, Folder update, UUID ehrId) {
        DateTime timestamp = DateTime.now();
        FolderUtils.checkSiblingNameConflicts(update);
        I_FolderAccess folderAccess = FolderAccess.retrieveInstanceForExistingFolder(this.getDataAccess(), folderId);
        FolderUtils.updateFolder(update, folderAccess);
        folderAccess.getSubfoldersList().clear();
        if (update.getFolders() != null && !update.getFolders().isEmpty()) {
            update.getFolders().forEach(childFolder -> folderAccess.getSubfoldersList().put(UUID.randomUUID(), FolderAccess.buildNewFolderAccessHierarchy(this.getDataAccess(), childFolder, timestamp, ehrId, ((FolderAccess)folderAccess).getContributionAccess())));
        }
        if (folderAccess.update(new Timestamp(timestamp.getMillis())).booleanValue()) {
            return this.createDto(folderAccess);
        }
        return Optional.empty();
    }

    public LocalDateTime delete(UUID folderId) {
        I_FolderAccess folderAccess = I_FolderAccess.retrieveInstanceForExistingFolder(this.getDataAccess(), folderId);
        if (folderAccess.delete() > 0) {
            return LocalDateTime.now();
        }
        throw new InternalServerException("Error during deletion of folder " + folderId);
    }

    public StructuredString serialize(Folder folder, StructuredStringFormat format) {
        StructuredString folderString;
        switch (format) {
            case XML: {
                folderString = new StructuredString(new CanonicalXML().marshal((RMObject)folder, Boolean.valueOf(false)), StructuredStringFormat.XML);
                break;
            }
            case JSON: {
                folderString = new StructuredString(new CanonicalJson().marshal((RMObject)folder), StructuredStringFormat.JSON);
                break;
            }
            default: {
                throw new UnexpectedSwitchCaseException("Unsupported target format for serialization of folders: " + format);
            }
        }
        return folderString;
    }

    public Integer getLastVersionNumber(UUID folderId) {
        return FolderAccess.getLastVersionNumber(this.getDataAccess(), folderId);
    }

    public Integer getVersionNumberForTimestamp(UUID folderId, LocalDateTime timestamp) {
        return 1;
    }

    private Optional<FolderDto> createDto(I_FolderAccess folderAccess) {
        if (folderAccess == null) {
            return Optional.empty();
        }
        Folder folder = this.createFolderObject(folderAccess);
        return Optional.of(new FolderDto(folder));
    }

    private Folder createFolderObject(I_FolderAccess folderAccess) {
        Folder result = new Folder();
        result.setDetails(folderAccess.getFolderDetails());
        result.setArchetypeNodeId(folderAccess.getFolderArchetypeNodeId());
        result.setNameAsString(folderAccess.getFolderName());
        result.setItems(folderAccess.getItems());
        result.setUid((UIDBasedId)new ObjectVersionId(folderAccess.getFolderId().toString()));
        if (!folderAccess.getSubfoldersList().isEmpty()) {
            result.setFolders(folderAccess.getSubfoldersList().values().stream().map(this::createFolderObject).collect(Collectors.toList()));
        } else {
            result.setFolders(null);
        }
        return result;
    }

    private I_FolderAccess extractPath(I_FolderAccess folderAccess, String path) {
        if (path != null && !"/".equals(path)) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            folderAccess = FolderUtils.getPath(folderAccess, 0, path.split("/"));
        }
        return folderAccess;
    }
}

