/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PreDestroy;
import javax.cache.Cache;
import javax.cache.CacheManager;
import org.apache.xmlbeans.XmlException;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.StateConflictException;
import org.ehrbase.ehr.knowledge.I_KnowledgeCache;
import org.ehrbase.ehr.knowledge.TemplateMetaData;
import org.ehrbase.opt.OptVisitor;
import org.ehrbase.opt.query.I_QueryOptMetaData;
import org.ehrbase.opt.query.MapJson;
import org.ehrbase.opt.query.QueryOptMetaData;
import org.ehrbase.service.IntrospectService;
import org.ehrbase.service.TemplateStorage;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.TEMPLATEID;
import org.openehr.schemas.v1.TemplateDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class KnowledgeCacheService
implements I_KnowledgeCache,
IntrospectService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TemplateStorage templateStorage;
    private Cache<String, OPERATIONALTEMPLATE> atOptCache;
    private final Cache<UUID, I_QueryOptMetaData> queryOptMetaDataCache;
    private Map<UUID, String> idxCache = new ConcurrentHashMap<UUID, String>();
    private final CacheManager cacheManager;
    @Value(value="${system.allow-template-overwrite:false}")
    private boolean allowTemplateOverwrite;

    @Autowired
    public KnowledgeCacheService(@Qualifier(value="templateDBStorageService") TemplateStorage templateStorage, CacheManager cacheManager) {
        this.templateStorage = templateStorage;
        this.cacheManager = cacheManager;
        this.atOptCache = cacheManager.getCache("operationaltemplateCache", String.class, OPERATIONALTEMPLATE.class);
        this.queryOptMetaDataCache = cacheManager.getCache("introspectCache", UUID.class, I_QueryOptMetaData.class);
    }

    @PreDestroy
    public void closeCache() {
        this.cacheManager.close();
    }

    @Override
    public String addOperationalTemplate(byte[] content) {
        TemplateDocument document;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content);
        try {
            document = TemplateDocument.Factory.parse((InputStream)inputStream);
        }
        catch (IOException | XmlException e) {
            throw new InvalidApiParameterException(e.getMessage());
        }
        OPERATIONALTEMPLATE template = document.getTemplate();
        if (template == null) {
            throw new InvalidApiParameterException("Could not parse input template");
        }
        if (template.getConcept() == null || template.getConcept().isEmpty()) {
            throw new IllegalArgumentException("Supplied template has nil or empty concept");
        }
        if (template.getDefinition() == null || template.getDefinition().isNil()) {
            throw new IllegalArgumentException("Supplied template has nil or empty definition");
        }
        if (template.getDescription() == null || !template.getDescription().validate()) {
            throw new IllegalArgumentException("Supplied template has nil or empty description");
        }
        Optional<TEMPLATEID> filenameOptional = Optional.ofNullable(template.getTemplateId());
        String templateId = filenameOptional.orElseThrow(() -> new InvalidApiParameterException("Invalid template input content")).getValue();
        if (!this.allowTemplateOverwrite && this.retrieveOperationalTemplate(templateId).isPresent()) {
            throw new StateConflictException("Operational template with this template ID already exists");
        }
        this.templateStorage.storeTemplate(template);
        this.invalidateCache(template);
        this.atOptCache.put((Object)templateId, (Object)template);
        this.idxCache.put(UUID.fromString(template.getUid().getValue()), templateId);
        return template.getTemplateId().getValue();
    }

    private void invalidateCache(OPERATIONALTEMPLATE template) {
        this.queryOptMetaDataCache.remove((Object)UUID.fromString(template.getUid().getValue()));
    }

    @Override
    public List<TemplateMetaData> listAllOperationalTemplates() {
        return this.templateStorage.listAllOperationalTemplates();
    }

    @Override
    public Optional<OPERATIONALTEMPLATE> retrieveOperationalTemplate(String key) {
        this.log.debug("retrieveOperationalTemplate({})", (Object)key);
        OPERATIONALTEMPLATE template = (OPERATIONALTEMPLATE)this.atOptCache.get((Object)key);
        if (template == null) {
            template = this.getOperationaltemplateFromFileStorage(key);
        }
        return Optional.ofNullable(template);
    }

    @Override
    public Optional<OPERATIONALTEMPLATE> retrieveOperationalTemplate(UUID uuid) {
        String key = this.findTemplateIdByUuid(uuid);
        if (key == null) {
            return Optional.empty();
        }
        return this.retrieveOperationalTemplate(key);
    }

    private String findTemplateIdByUuid(UUID uuid) {
        String key = this.idxCache.get(uuid);
        if (key == null) {
            key = this.listAllOperationalTemplates().stream().filter(t -> t.getErrorList().isEmpty()).filter(t -> t.getOperationaltemplate().getUid().getValue().equals(uuid.toString())).map(t -> t.getOperationaltemplate().getTemplateId().getValue()).findFirst().orElse(null);
        }
        return key;
    }

    @Override
    public I_QueryOptMetaData getQueryOptMetaData(UUID uuid) {
        I_QueryOptMetaData retval = this.queryOptMetaDataCache.containsKey((Object)uuid) ? (I_QueryOptMetaData)this.queryOptMetaDataCache.get((Object)uuid) : this.buildAndCacheQueryOptMetaData(uuid);
        return retval;
    }

    @Override
    public I_QueryOptMetaData getQueryOptMetaData(String templateId) {
        Optional<OPERATIONALTEMPLATE> operationaltemplate = this.retrieveOperationalTemplate(templateId);
        if (operationaltemplate.isPresent()) {
            return this.getQueryOptMetaData(UUID.fromString(operationaltemplate.get().getUid().getValue()));
        }
        Optional<Object> cachedOpt = Optional.empty();
        try {
            cachedOpt = this.retrieveOperationalTemplate(templateId);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        if (cachedOpt.isPresent()) {
            UUID uuid = UUID.fromString(((OPERATIONALTEMPLATE)cachedOpt.get()).getUid().getValue());
            return this.getQueryOptMetaData(uuid);
        }
        throw new IllegalArgumentException("Could not retrieve  knowledgeCacheService.getKnowledgeCache() cache for template id:" + templateId);
    }

    private I_QueryOptMetaData buildAndCacheQueryOptMetaData(UUID uuid) {
        Optional<Object> operationaltemplate = Optional.empty();
        try {
            operationaltemplate = this.retrieveOperationalTemplate(uuid);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        if (!operationaltemplate.isPresent()) {
            throw new IllegalArgumentException("Could not retrieve  knowledgeCacheService.getKnowledgeCache() cache for template Uid:" + uuid);
        }
        I_QueryOptMetaData retval = this.buildAndCacheQueryOptMetaData((OPERATIONALTEMPLATE)operationaltemplate.get());
        return retval;
    }

    private I_QueryOptMetaData buildAndCacheQueryOptMetaData(OPERATIONALTEMPLATE operationaltemplate) {
        I_QueryOptMetaData visitor;
        this.log.info("Updating getQueryOptMetaData cache for template: {}", (Object)operationaltemplate.getTemplateId().getValue());
        try {
            Map map = new OptVisitor().traverse(operationaltemplate);
            visitor = QueryOptMetaData.getInstance(new MapJson(map).toJson());
        }
        catch (Exception e) {
            throw new InternalServerException(e.getMessage(), e);
        }
        this.queryOptMetaDataCache.put((Object)UUID.fromString(operationaltemplate.getUid().getValue()), (Object)visitor);
        return visitor;
    }

    private OPERATIONALTEMPLATE getOperationaltemplateFromFileStorage(String filename) {
        OPERATIONALTEMPLATE operationaltemplate = this.templateStorage.readOperationaltemplate(filename).orElse(null);
        if (operationaltemplate != null) {
            this.atOptCache.put((Object)filename, (Object)operationaltemplate);
            this.idxCache.put(UUID.fromString(operationaltemplate.getUid().getValue()), filename);
        }
        return operationaltemplate;
    }

    @Override
    public I_KnowledgeCache getKnowledge() {
        return this;
    }
}

