/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.gson.JsonElement;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ehrbase.api.definitions.QueryMode;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.definitions.StructuredString;
import org.ehrbase.api.definitions.StructuredStringFormat;
import org.ehrbase.api.dto.QueryDefinitionResultDto;
import org.ehrbase.api.dto.QueryResultDto;
import org.ehrbase.api.exception.GeneralRequestProcessingException;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.service.QueryService;
import org.ehrbase.aql.compiler.AqlExpression;
import org.ehrbase.aql.sql.AqlResult;
import org.ehrbase.dao.access.interfaces.I_EntryAccess;
import org.ehrbase.dao.access.interfaces.I_StoredQueryAccess;
import org.ehrbase.dao.access.jooq.AqlQueryHandler;
import org.ehrbase.dao.access.jooq.StoredQueryAccess;
import org.ehrbase.service.BaseService;
import org.ehrbase.service.KnowledgeCacheService;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.exception.DataAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class QueryServiceImp
extends BaseService
implements QueryService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${server.aql.use-jsquery:true}")
    private boolean usePgExtensions;

    @Autowired
    public QueryServiceImp(KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig) {
        super(knowledgeCacheService, context, serverConfig);
    }

    public QueryResultDto query(String queryString, QueryMode queryMode, boolean explain) {
        switch (queryMode) {
            case SQL: {
                return this.querySql(queryString);
            }
            case AQL: {
                return this.queryAql(queryString, explain);
            }
        }
        throw new IllegalArgumentException("Invalid query mode:" + queryMode);
    }

    public QueryResultDto query(String queryString, Map<String, Object> parameters, QueryMode queryMode, boolean explain) {
        switch (queryMode) {
            case SQL: {
                return this.querySql(queryString);
            }
            case AQL: {
                return this.queryAql(queryString, parameters, explain);
            }
        }
        throw new IllegalArgumentException("Invalid query mode:" + queryMode);
    }

    private QueryResultDto formatResult(AqlResult aqlResult, String queryString, boolean explain) {
        QueryResultDto dto = new QueryResultDto();
        dto.setExecutedAQL(queryString);
        dto.setVariables((BiMap)HashBiMap.create(aqlResult.getVariables()));
        ArrayList resultList = new ArrayList();
        for (Record record : aqlResult.getRecords()) {
            LinkedHashMap<String, Object> fieldMap = new LinkedHashMap<String, Object>();
            for (Field field : record.fields()) {
                if (record.getValue(field) instanceof JsonElement) {
                    fieldMap.put(field.getName(), new StructuredString(record.getValue(field).toString(), StructuredStringFormat.JSON));
                    continue;
                }
                fieldMap.put(field.getName(), record.getValue(field));
            }
            resultList.add(fieldMap);
        }
        dto.setResultSet(resultList);
        if (explain) {
            dto.setExplain(aqlResult.getExplain());
        }
        return dto;
    }

    private QueryResultDto queryAql(String queryString, boolean explain) {
        try {
            AqlQueryHandler queryHandler = new AqlQueryHandler(this.getDataAccess(), this.usePgExtensions);
            AqlResult aqlResult = queryHandler.process(queryString);
            return this.formatResult(aqlResult, queryString, explain);
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error:" + dae.getCause().getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not process query, reason:" + e);
        }
    }

    private QueryResultDto queryAql(String queryString, Map<String, Object> parameters, boolean explain) {
        try {
            AqlQueryHandler queryHandler = new AqlQueryHandler(this.getDataAccess(), this.usePgExtensions);
            AqlResult aqlResult = queryHandler.process(queryString, parameters);
            return this.formatResult(aqlResult, queryString, explain);
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error:" + dae.getCause().getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not retrieve stored query, reason:" + e);
        }
    }

    private QueryResultDto querySql(String queryString) {
        Map<String, Object> result;
        try {
            result = I_EntryAccess.queryJSON(this.getDataAccess(), queryString);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new InternalServerException(e);
        }
        QueryResultDto dto = new QueryResultDto();
        dto.setExecutedAQL((String)result.get("executedAQL"));
        dto.setResultSet((List)result.get("resultSet"));
        dto.setExplain((List)result.get("explain"));
        return dto;
    }

    public List<QueryDefinitionResultDto> retrieveStoredQueries(String fullyQualifiedName) {
        ArrayList<QueryDefinitionResultDto> resultDtos = new ArrayList<QueryDefinitionResultDto>();
        try {
            if (fullyQualifiedName == null || fullyQualifiedName.isEmpty()) {
                for (I_StoredQueryAccess i_StoredQueryAccess : StoredQueryAccess.retrieveQualifiedList(this.getDataAccess())) {
                    resultDtos.add(this.mapToQueryDefinitionDto(i_StoredQueryAccess));
                }
            } else {
                for (I_StoredQueryAccess i_StoredQueryAccess : StoredQueryAccess.retrieveQualifiedList(this.getDataAccess(), fullyQualifiedName)) {
                    resultDtos.add(this.mapToQueryDefinitionDto(i_StoredQueryAccess));
                }
            }
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error:" + dae.getCause().getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not retrieve stored query, reason:" + e);
        }
        return resultDtos;
    }

    public QueryDefinitionResultDto retrieveStoredQuery(String qualifiedName, String version) {
        StoredQueryAccess storedQueryAccess;
        String queryQualifiedName = qualifiedName + (String)(version != null && !version.isEmpty() ? "/" + version : "");
        try {
            storedQueryAccess = StoredQueryAccess.retrieveQualified(this.getDataAccess(), queryQualifiedName);
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error:" + dae.getCause().getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (Exception e) {
            throw new InternalServerException(e.getMessage());
        }
        return this.mapToQueryDefinitionDto(storedQueryAccess);
    }

    public QueryDefinitionResultDto createStoredQuery(String qualifiedName, String version, String queryString) {
        try {
            new AqlExpression().parse(queryString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid query, reason:" + e);
        }
        try {
            String queryQualifiedName = qualifiedName + (String)(version != null && !version.isEmpty() ? "/" + version : "");
            StoredQueryAccess storedQueryAccess = new StoredQueryAccess(this.getDataAccess(), queryQualifiedName, queryString);
            storedQueryAccess.commit();
            return this.mapToQueryDefinitionDto(storedQueryAccess);
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error:" + dae.getCause().getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (Exception e) {
            throw new InternalServerException(e.getMessage());
        }
    }

    public QueryDefinitionResultDto updateStoredQuery(String qualifiedName, String version, String queryString) {
        try {
            StoredQueryAccess storedQueryAccess = StoredQueryAccess.retrieveQualified(this.getDataAccess(), qualifiedName + (String)(version != null && !version.isEmpty() ? "/" + version : ""));
            storedQueryAccess.setQueryText(queryString);
            storedQueryAccess.update(Timestamp.from(Instant.now()));
            return this.mapToQueryDefinitionDto(storedQueryAccess);
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error:" + dae.getCause().getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (Exception e) {
            throw new InternalServerException(e.getMessage());
        }
    }

    public QueryDefinitionResultDto deleteStoredQuery(String qualifiedName, String version) {
        try {
            StoredQueryAccess storedQueryAccess = StoredQueryAccess.retrieveQualified(this.getDataAccess(), qualifiedName + (String)(version != null && !version.isEmpty() ? "/" + version : ""));
            storedQueryAccess.delete();
            return this.mapToQueryDefinitionDto(storedQueryAccess);
        }
        catch (DataAccessException dae) {
            throw new GeneralRequestProcessingException("Data Access Error:" + dae.getCause().getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(iae.getMessage());
        }
        catch (Exception e) {
            throw new InternalServerException(e.getMessage());
        }
    }

    private QueryDefinitionResultDto mapToQueryDefinitionDto(I_StoredQueryAccess storedQueryAccess) {
        QueryDefinitionResultDto dto = new QueryDefinitionResultDto();
        dto.setSaved(storedQueryAccess.getCreationDate().toInstant().atZone(ZoneId.systemDefault()));
        dto.setQualifiedName(storedQueryAccess.getReverseDomainName() + "::" + storedQueryAccess.getSemanticId());
        dto.setVersion(storedQueryAccess.getSemver());
        dto.setQueryText(storedQueryAccess.getQueryText());
        dto.setType(storedQueryAccess.getQueryType());
        return dto;
    }
}

