/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.util.List;
import java.util.Optional;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_TemplateStoreAccess;
import org.ehrbase.dao.access.support.ServiceDataAccess;
import org.ehrbase.ehr.knowledge.TemplateMetaData;
import org.ehrbase.service.TemplateStorage;
import org.jooq.DSLContext;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateDBStorageService
implements TemplateStorage {
    private final DSLContext context;
    private final ServerConfig serverConfig;

    @Autowired
    public TemplateDBStorageService(DSLContext context, ServerConfig serverConfig) {
        this.context = context;
        this.serverConfig = serverConfig;
    }

    @Override
    public List<TemplateMetaData> listAllOperationalTemplates() {
        return I_TemplateStoreAccess.fetchAll(this.getDataAccess());
    }

    @Override
    public void storeTemplate(OPERATIONALTEMPLATE template) {
        if (this.readOperationaltemplate(template.getTemplateId().getValue()).isPresent()) {
            I_TemplateStoreAccess.getInstance(this.getDataAccess(), template).update();
        } else {
            I_TemplateStoreAccess.getInstance(this.getDataAccess(), template).commit();
        }
    }

    @Override
    public Optional<OPERATIONALTEMPLATE> readOperationaltemplate(String templateId) {
        return Optional.ofNullable(I_TemplateStoreAccess.retrieveInstanceByTemplateId(this.getDataAccess(), templateId).getTemplate());
    }

    protected I_DomainAccess getDataAccess() {
        return new ServiceDataAccess(this.context, null, null, this.serverConfig);
    }
}

