/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.xmlbeans.XmlOptions;
import org.ehrbase.ehr.knowledge.TemplateMetaData;
import org.ehrbase.service.TemplateStorage;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.openehr.schemas.v1.TemplateDocument;
import org.springframework.beans.factory.annotation.Autowired;

public class TemplateFileStorageService
implements TemplateStorage {
    private Map<String, File> optFileMap = new ConcurrentHashMap<String, File>();
    private Map<String, String> errorMap = new ConcurrentHashMap<String, String>();
    private String optPath;

    @Autowired
    public TemplateFileStorageService() {
    }

    public TemplateFileStorageService(String optPath) {
        this.optPath = optPath;
    }

    @PostConstruct
    public void init() {
        this.addKnowledgeSourcePath(this.getOptPath());
    }

    public String getOptPath() {
        return this.optPath;
    }

    void setOptPath(String optPath) {
        this.optPath = optPath;
    }

    @Override
    public List<TemplateMetaData> listAllOperationalTemplates() {
        ZoneId zoneId = ZoneId.systemDefault();
        ArrayList<TemplateMetaData> templateMetaDataList = new ArrayList<TemplateMetaData>();
        for (String filename : this.optFileMap.keySet()) {
            TemplateMetaData template = new TemplateMetaData();
            OPERATIONALTEMPLATE operationaltemplate = this.readOperationaltemplate(filename).orElse(null);
            if (operationaltemplate == null) {
                template.addError("Reported error for file:" + filename + ", error:" + this.errorMap.get(filename));
            } else {
                template.setOperationaltemplate(operationaltemplate);
                if (operationaltemplate.getTemplateId() == null) {
                    template.addError("Could not get template id for template in file:" + filename);
                }
            }
            Path path = Paths.get(this.getOptPath() + "/" + filename + ".opt", new String[0]);
            try {
                BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                ZonedDateTime creationTime = ZonedDateTime.parse(attributes.creationTime().toString()).withZoneSameInstant(zoneId);
                template.setCreatedOn(creationTime.toOffsetDateTime());
            }
            catch (Exception e) {
                template.addError("disconnected file? tried:" + this.getOptPath() + "/" + filename + ".opt");
            }
            templateMetaDataList.add(template);
        }
        return templateMetaDataList;
    }

    @Override
    public void storeTemplate(OPERATIONALTEMPLATE template) {
        XmlOptions opts = new XmlOptions();
        opts.setSaveSyntheticDocumentElement(new QName("http://schemas.openehr.org/v1", "template"));
        this.saveTemplateFile(template.getTemplateId().getValue(), template.xmlText(opts).getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public Optional<OPERATIONALTEMPLATE> readOperationaltemplate(String templateId) {
        OPERATIONALTEMPLATE operationaltemplate = null;
        File file = this.optFileMap.get(templateId);
        try (BOMInputStream in = file != null ? new BOMInputStream((InputStream)new FileInputStream(file), true) : null;){
            TemplateDocument document = TemplateDocument.Factory.parse((InputStream)in);
            operationaltemplate = document.getTemplate();
        }
        catch (Exception e) {
            this.errorMap.put(templateId, e.getMessage());
        }
        return Optional.ofNullable(operationaltemplate);
    }

    boolean addKnowledgeSourcePath(String path) {
        if (path == null) {
            return false;
        }
        if ((path = path.trim()).isEmpty()) {
            throw new IllegalArgumentException("Source path is empty!");
        }
        File root = new File(path);
        if (!(root = new File(root.getAbsolutePath())).isDirectory()) {
            throw new IllegalArgumentException("Supplied source path:" + path + "(" + root.getAbsolutePath() + ") is not a directory!");
        }
        ArrayList<File> tr = new ArrayList<File>();
        tr.add(root);
        while (!tr.isEmpty()) {
            File r = (File)tr.remove(tr.size() - 1);
            for (File f : r.listFiles()) {
                if (f.isHidden()) continue;
                if (f.isFile()) {
                    String key = f.getName().replaceAll("([^\\\\\\/]+)\\.opt", "$1");
                    this.optFileMap.put(key, f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                tr.add(f);
            }
        }
        return true;
    }

    private synchronized void saveTemplateFile(String filename, byte[] content) {
        Path path = Paths.get(this.getOptPath(), filename + ".opt");
        try {
            Files.write(path, content, StandardOpenOption.CREATE);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not write file:" + filename + " in directory:" + this.getOptPath() + ", reason:" + e);
        }
        this.optFileMap.put(filename, path.toFile());
    }
}

