/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlOptions;
import org.ehrbase.api.definitions.CompositionFormat;
import org.ehrbase.api.definitions.OperationalTemplateFormat;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.definitions.StructuredString;
import org.ehrbase.api.definitions.StructuredStringFormat;
import org.ehrbase.api.dto.TemplateMetaDataDto;
import org.ehrbase.api.dto.WebTemplate;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.api.service.TemplateService;
import org.ehrbase.ehr.knowledge.TemplateMetaData;
import org.ehrbase.opt.OptVisitor;
import org.ehrbase.service.BaseService;
import org.ehrbase.service.KnowledgeCacheService;
import org.jooq.DSLContext;
import org.openehr.schemas.v1.CARCHETYPEROOT;
import org.openehr.schemas.v1.OBJECTID;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TemplateServiceImp
extends BaseService
implements TemplateService {
    private final KnowledgeCacheService knowledgeCacheService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    public TemplateServiceImp(KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig) {
        super(knowledgeCacheService, context, serverConfig);
        this.knowledgeCacheService = Objects.requireNonNull(knowledgeCacheService);
    }

    public List<TemplateMetaDataDto> getAllTemplates() {
        return this.knowledgeCacheService.listAllOperationalTemplates().stream().map(this::mapToDto).collect(Collectors.toList());
    }

    private TemplateMetaDataDto mapToDto(TemplateMetaData data) {
        TemplateMetaDataDto dto = new TemplateMetaDataDto();
        dto.setCreatedOn(data.getCreatedOn());
        Optional<OPERATIONALTEMPLATE> operationaltemplate = Optional.ofNullable(data.getOperationaltemplate());
        dto.setTemplateId((String)operationaltemplate.map(OPERATIONALTEMPLATE::getTemplateId).map(OBJECTID::getValue).orElse(null));
        dto.setArchetypeId((String)operationaltemplate.map(OPERATIONALTEMPLATE::getDefinition).map(CARCHETYPEROOT::getArchetypeId).map(OBJECTID::getValue).orElse(null));
        dto.setConcept((String)operationaltemplate.map(OPERATIONALTEMPLATE::getConcept).orElse(null));
        return dto;
    }

    public StructuredString buildExample(String templateId, CompositionFormat format) {
        String exampleString = "";
        return new StructuredString("", StructuredStringFormat.fromCompositionFormat((CompositionFormat)format));
    }

    public WebTemplate findTemplate(String templateId) {
        Map retObj;
        try {
            Optional<OPERATIONALTEMPLATE> operationaltemplate = this.knowledgeCacheService.retrieveOperationalTemplate(templateId);
            retObj = new OptVisitor().traverse(operationaltemplate.orElseThrow(() -> new ObjectNotFoundException("template", "Template with the specified id does not exist")));
        }
        catch (NullPointerException e) {
            throw new ObjectNotFoundException("template", "Template with the specified id does not exist", (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalServerException("Could not generate web template, reason:" + e);
        }
        WebTemplate webTemplate = new WebTemplate();
        webTemplate.setUid(retObj.get("uid").toString());
        webTemplate.setLanguages((List)retObj.get("languages"));
        webTemplate.setConcept(retObj.get("concept").toString());
        webTemplate.setTree((Map)retObj.get("tree"));
        webTemplate.setTemplateId(retObj.get("uid").toString());
        webTemplate.setDefaultLanguage(retObj.get("default_language").toString());
        return webTemplate;
    }

    public String findOperationalTemplate(String templateId, OperationalTemplateFormat format) throws ObjectNotFoundException, InvalidApiParameterException, InternalServerException {
        Optional<OPERATIONALTEMPLATE> operationaltemplate;
        block4: {
            if (format.equals((Object)OperationalTemplateFormat.XML)) {
                try {
                    operationaltemplate = this.knowledgeCacheService.retrieveOperationalTemplate(templateId);
                    if (!operationaltemplate.isPresent()) {
                        throw new ObjectNotFoundException("template", "Template with the specified id does not exist");
                    }
                    break block4;
                }
                catch (NullPointerException e) {
                    throw new ObjectNotFoundException("template", "Template with the specified id does not exist", (Throwable)e);
                }
            }
            throw new InvalidApiParameterException("Requested operational template type not supported");
        }
        XmlOptions opts = new XmlOptions();
        opts.setSaveSyntheticDocumentElement(new QName("http://schemas.openehr.org/v1", "template"));
        return operationaltemplate.map(o -> o.xmlText(opts)).orElseThrow(() -> new InternalServerException("Failure while retrieving operational template"));
    }

    public String create(String content) {
        return this.knowledgeCacheService.addOperationalTemplate(content.getBytes(StandardCharsets.UTF_8));
    }
}

