/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessage;
import com.nedap.archie.rmobjectvalidator.RMObjectValidator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.cache.Cache;
import javax.cache.CacheManager;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.service.ValidationService;
import org.ehrbase.ehr.knowledge.I_KnowledgeCache;
import org.ehrbase.terminology.openehr.TerminologyService;
import org.ehrbase.validation.Validator;
import org.ehrbase.validation.terminology.ItemStructureVisitor;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ValidationServiceImp
implements ValidationService {
    private Cache<UUID, Validator> validatorCache;
    private final I_KnowledgeCache knowledgeCache;
    private final TerminologyService terminologyService;

    @Autowired
    public ValidationServiceImp(CacheManager cacheManager, I_KnowledgeCache knowledgeCache, TerminologyService terminologyService) {
        this.validatorCache = cacheManager.getCache("validatorCache", UUID.class, Validator.class);
        this.knowledgeCache = knowledgeCache;
        this.terminologyService = terminologyService;
    }

    public void check(UUID templateUUID, Composition composition) throws Exception {
        Validator validator = (Validator)this.validatorCache.get((Object)templateUUID);
        if (validator == null) {
            Optional<OPERATIONALTEMPLATE> operationaltemplate = this.knowledgeCache.retrieveOperationalTemplate(templateUUID);
            if (!operationaltemplate.isPresent()) {
                throw new IllegalArgumentException("Not found template uuid:" + templateUUID);
            }
            validator = new Validator(operationaltemplate.get());
            this.validatorCache.put((Object)templateUUID, (Object)validator);
        }
        validator.check(composition);
        ItemStructureVisitor itemStructureVisitor = new ItemStructureVisitor(this.terminologyService);
        itemStructureVisitor.validate(composition);
    }

    public void check(String templateID, Composition composition) throws Exception {
        Optional<OPERATIONALTEMPLATE> operationaltemplate = this.knowledgeCache.retrieveOperationalTemplate(templateID);
        if (operationaltemplate.isEmpty()) {
            throw new UnprocessableEntityException("Not found template id: " + templateID);
        }
        this.check(UUID.fromString(operationaltemplate.get().getUid().getValue()), composition);
    }

    public void check(Composition composition) throws Exception {
        if (composition.getName() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: name");
        }
        if (composition.getArchetypeNodeId() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: archetype_node_id");
        }
        if (composition.getLanguage() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: language");
        }
        if (composition.getCategory() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: category");
        }
        if (composition.getComposer() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: composer");
        }
        if (composition.getArchetypeDetails() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: archetype details");
        }
        if (composition.getArchetypeDetails().getTemplateId() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: archetype details/template_id");
        }
        RMObjectValidator rmObjectValidator = new RMObjectValidator((ModelInfoLookup)ArchieRMInfoLookup.getInstance());
        List rmObjectValidationMessages = rmObjectValidator.validate((Object)composition);
        if (!rmObjectValidationMessages.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (RMObjectValidationMessage rmObjectValidationMessage : rmObjectValidationMessages) {
                stringBuilder.append(rmObjectValidationMessage.toString());
                stringBuilder.append("\n");
            }
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.check(composition.getArchetypeDetails().getTemplateId().getValue(), composition);
    }

    public void invalidate() {
        this.validatorCache.removeAll();
    }
}

