/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.ArrayList;
import java.util.List;
import org.ehrbase.aql.compiler.Contains;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.definition.VariableDefinition;
import org.ehrbase.aql.sql.PathResolver;
import org.ehrbase.aql.sql.binding.ExpressionField;
import org.ehrbase.aql.sql.queryimpl.CompositionAttributeQuery;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.ehrbase.aql.sql.queryimpl.JsonbEntryQuery;
import org.ehrbase.aql.sql.queryimpl.MultiFields;
import org.ehrbase.aql.sql.queryimpl.attribute.JoinSetup;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.service.IntrospectService;
import org.ehrbase.service.KnowledgeCacheService;

public class WhereMultiFields {
    private JsonbEntryQuery jsonbEntryQuery;
    private CompositionAttributeQuery compositionAttributeQuery;
    private final List<Object> whereClause;
    private PathResolver pathResolver;

    public WhereMultiFields(JsonbEntryQuery jsonbEntryQuery, CompositionAttributeQuery compositionAttributeQuery, List<Object> whereClause, PathResolver pathResolver) {
        this.jsonbEntryQuery = jsonbEntryQuery;
        this.compositionAttributeQuery = compositionAttributeQuery;
        this.whereClause = whereClause;
        this.pathResolver = pathResolver;
    }

    public WhereMultiFields(I_DomainAccess domainAccess, IntrospectService introspectCache, Contains contains, List<Object> whereClause, String serverNodeId) {
        this.pathResolver = new PathResolver((KnowledgeCacheService)introspectCache, contains.getIdentifierMapper());
        this.jsonbEntryQuery = new JsonbEntryQuery(domainAccess, introspectCache, this.pathResolver);
        this.compositionAttributeQuery = new CompositionAttributeQuery(domainAccess, this.pathResolver, serverNodeId, introspectCache);
        this.whereClause = whereClause;
    }

    private void buildWhereCondition(List<MultiFields> multiFieldsList, String templateId, List<Object> item) {
        for (Object part : item) {
            if (part instanceof VariableDefinition) {
                multiFieldsList.add(new ExpressionField((I_VariableDefinition)part, this.jsonbEntryQuery, this.compositionAttributeQuery).toSql(this.pathResolver.classNameOf(((I_VariableDefinition)part).getIdentifier()), templateId, ((I_VariableDefinition)part).getIdentifier(), IQueryImpl.Clause.WHERE));
                continue;
            }
            if (!(part instanceof List)) continue;
            this.buildWhereCondition(multiFieldsList, templateId, (List)part);
        }
    }

    public List<MultiFields> bind(String templateId) {
        ArrayList<MultiFields> multiFieldsList = new ArrayList<MultiFields>();
        if (this.whereClause.isEmpty()) {
            return multiFieldsList;
        }
        ArrayList<Object> whereItems = new ArrayList<Object>(this.whereClause);
        this.buildWhereCondition(multiFieldsList, templateId, whereItems);
        return multiFieldsList;
    }

    public JoinSetup getJoinSetup() {
        return this.compositionAttributeQuery.getJoinSetup();
    }
}

