/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl;

import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.definition.VariableDefinition;
import org.ehrbase.aql.sql.PathResolver;
import org.ehrbase.aql.sql.binding.IJoinBinder;
import org.ehrbase.aql.sql.binding.LateralJoins;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.ehrbase.aql.sql.queryimpl.MultiFields;
import org.ehrbase.aql.sql.queryimpl.ObjectQuery;
import org.ehrbase.aql.sql.queryimpl.QualifiedAqlField;
import org.ehrbase.aql.sql.queryimpl.attribute.AttributePath;
import org.ehrbase.aql.sql.queryimpl.attribute.FieldResolutionContext;
import org.ehrbase.aql.sql.queryimpl.attribute.JoinSetup;
import org.ehrbase.aql.sql.queryimpl.attribute.composer.ComposerResolver;
import org.ehrbase.aql.sql.queryimpl.attribute.composition.CompositionResolver;
import org.ehrbase.aql.sql.queryimpl.attribute.composition.FullCompositionJson;
import org.ehrbase.aql.sql.queryimpl.attribute.ehr.EhrResolver;
import org.ehrbase.aql.sql.queryimpl.attribute.ehr.FullEhrJson;
import org.ehrbase.aql.sql.queryimpl.attribute.eventcontext.EventContextResolver;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.service.IntrospectService;
import org.jooq.Comparator;
import org.jooq.Field;
import org.jooq.Select;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectQuery;
import org.jooq.impl.DSL;

public class CompositionAttributeQuery
extends ObjectQuery
implements IQueryImpl,
IJoinBinder {
    private String serverNodeId;
    protected JoinSetup joinSetup = new JoinSetup();
    private final IntrospectService introspectCache;

    public CompositionAttributeQuery(I_DomainAccess domainAccess, PathResolver pathResolver, String serverNodeId, IntrospectService introspectCache) {
        super(domainAccess, pathResolver);
        this.serverNodeId = serverNodeId;
        this.introspectCache = introspectCache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MultiFields makeField(String templateId, String identifier, I_VariableDefinition variableDefinition, IQueryImpl.Clause clause) {
        Field<?> retField;
        String columnAlias = variableDefinition.getPath();
        FieldResolutionContext fieldResolutionContext = new FieldResolutionContext(this.domainAccess.getContext(), this.serverNodeId, identifier, variableDefinition, clause, this.pathResolver, this.introspectCache, this.pathResolver.entryRoot(templateId));
        if (clause.equals((Object)IQueryImpl.Clause.WHERE)) {
            fieldResolutionContext.setWithAlias(false);
        }
        if (!templateId.equals("*")) {
            this.joinSetup.setUseEntry(true);
        }
        if (columnAlias == null) {
            if (clause.equals((Object)IQueryImpl.Clause.SELECT)) {
                if (this.pathResolver.classNameOf(variableDefinition.getIdentifier()).equals("COMPOSITION")) {
                    retField = new FullCompositionJson(fieldResolutionContext, this.joinSetup).sqlField();
                } else {
                    if (!this.pathResolver.classNameOf(variableDefinition.getIdentifier()).equals("EHR")) throw new IllegalArgumentException("Canonical json is not supported at this stage for this Entity, found class:" + this.pathResolver.classNameOf(variableDefinition.getIdentifier()));
                    retField = new FullEhrJson(fieldResolutionContext, this.joinSetup).sqlField();
                }
            } else {
                retField = null;
            }
        } else if (this.pathResolver.classNameOf(variableDefinition.getIdentifier()).equals("EHR")) {
            retField = new EhrResolver(fieldResolutionContext, this.joinSetup).sqlField(columnAlias);
        } else {
            if (!this.pathResolver.classNameOf(variableDefinition.getIdentifier()).equals("COMPOSITION") && !this.isCompositionAttributeItemStructure(templateId, variableDefinition.getIdentifier())) throw new IllegalArgumentException("INTERNAL: the following class cannot be resolved for AQL querying:" + this.pathResolver.classNameOf(variableDefinition.getIdentifier()));
            retField = columnAlias.startsWith("composer") ? new ComposerResolver(fieldResolutionContext, this.joinSetup).sqlField(new AttributePath("composer").redux(columnAlias)) : (columnAlias.startsWith("context") ? new EventContextResolver(fieldResolutionContext, this.joinSetup).sqlField(columnAlias) : new CompositionResolver(fieldResolutionContext, this.joinSetup).sqlField(columnAlias));
        }
        if (variableDefinition.getPredicateDefinition() != null && retField != null) {
            this.deriveLateralJoinForPredicate(variableDefinition, retField);
            String sqlToLateralJoin = variableDefinition.getLastLateralJoin("*").getTable().getName() + "." + variableDefinition.getSubstituteFieldVariable();
            retField = DSL.field((String)sqlToLateralJoin).as(retField.getName());
        } else if (fieldResolutionContext.isUsingSetReturningFunction()) {
            retField = DSL.field((Select)DSL.select(retField));
        }
        QualifiedAqlField aqlField = new QualifiedAqlField(retField);
        return new MultiFields(variableDefinition, aqlField, templateId);
    }

    @Override
    public MultiFields whereField(String templateId, String identifier, I_VariableDefinition variableDefinition) {
        return this.makeField(templateId, identifier, variableDefinition, IQueryImpl.Clause.WHERE);
    }

    public boolean useFromEntry() {
        return this.pathResolver.hasPathExpression();
    }

    public boolean isCompositionAttributeItemStructure(String templateId, String identifier) {
        if (this.variableTemplatePath(templateId, identifier) == null) {
            return false;
        }
        return this.variableTemplatePath(templateId, identifier).contains("/context/other_context");
    }

    public void setUseEntry(boolean b) {
        this.joinSetup.setUseEntry(b);
    }

    public boolean isUseEntry() {
        return this.joinSetup.isUseEntry();
    }

    public JoinSetup getJoinSetup() {
        return this.joinSetup;
    }

    private void deriveLateralJoinForPredicate(I_VariableDefinition variableDefinition, Field retField) {
        VariableDefinition pseudoVar = new VariableDefinition(variableDefinition.getPredicateDefinition().getOperand1(), null, variableDefinition.getIdentifier(), false);
        CompositionAttributeQuery compositionAttributeQuery = new CompositionAttributeQuery(this.domainAccess, this.pathResolver, this.serverNodeId, this.introspectCache);
        MultiFields wherePredicate = compositionAttributeQuery.makeField("*", variableDefinition.getIdentifier(), pseudoVar, IQueryImpl.Clause.WHERE);
        this.joinSetup.merge(compositionAttributeQuery.getJoinSetup());
        SelectQuery selectQuery = this.domainAccess.getContext().selectQuery();
        selectQuery.addSelect(new SelectFieldOrAsterisk[]{retField});
        Comparator comparator = this.comparatorFromSQL(variableDefinition.getPredicateDefinition().getOperator());
        selectQuery.addConditions(wherePredicate.getLastQualifiedField().getSQLField().cast(String.class).compare(comparator, DSL.field((String)variableDefinition.getPredicateDefinition().getOperand2()).cast(String.class)));
        new LateralJoins().create("*", selectQuery, variableDefinition, IQueryImpl.Clause.SELECT);
    }

    private Comparator comparatorFromSQL(String sql) {
        for (Comparator comparator : Comparator.values()) {
            if (!sql.equals(comparator.toSQL())) continue;
            return comparator;
        }
        return null;
    }
}

