/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl.attribute.ehr;

import java.sql.Timestamp;
import java.util.UUID;
import org.ehrbase.aql.sql.binding.JoinBinder;
import org.ehrbase.aql.sql.queryimpl.attribute.AttributePath;
import org.ehrbase.aql.sql.queryimpl.attribute.AttributeResolver;
import org.ehrbase.aql.sql.queryimpl.attribute.FieldResolutionContext;
import org.ehrbase.aql.sql.queryimpl.attribute.JoinSetup;
import org.ehrbase.aql.sql.queryimpl.attribute.ehr.EhrIdValue;
import org.ehrbase.aql.sql.queryimpl.attribute.ehr.FullEhrJson;
import org.ehrbase.aql.sql.queryimpl.attribute.ehr.ehrstatus.StatusResolver;
import org.ehrbase.aql.sql.queryimpl.attribute.system.SystemResolver;
import org.ehrbase.aql.sql.queryimpl.value_field.GenericJsonField;
import org.ehrbase.jooq.pg.Tables;
import org.jooq.Field;

public class EhrResolver
extends AttributeResolver {
    public static final String EHR_STATUS = "ehr_status";
    public static final String SYSTEM_ID = "system_id";

    public EhrResolver(FieldResolutionContext fieldResolutionContext, JoinSetup joinSetup) {
        super(fieldResolutionContext, joinSetup);
    }

    public Field<?> sqlField(String path) {
        if (path.startsWith(EHR_STATUS)) {
            return new StatusResolver(this.fieldResolutionContext, this.joinSetup).sqlField(new AttributePath(EHR_STATUS).redux(path));
        }
        if (path.startsWith(SYSTEM_ID)) {
            return new SystemResolver(this.fieldResolutionContext, this.joinSetup).sqlField(new AttributePath(SYSTEM_ID).redux(path));
        }
        this.joinSetup.setJoinEhr(true);
        switch (path) {
            case "ehr_id": {
                return new GenericJsonField(this.fieldResolutionContext, this.joinSetup).hierObjectId((Field<UUID>)JoinBinder.ehrRecordTable.field((Field)Tables.EHR_.ID));
            }
            case "ehr_id/value": {
                return new EhrIdValue(this.fieldResolutionContext, this.joinSetup).forTableField(NULL_FIELD).sqlField();
            }
            case "time_created": {
                return new GenericJsonField(this.fieldResolutionContext, this.joinSetup).dvDateTime((Field<Timestamp>)JoinBinder.ehrRecordTable.field((Field)Tables.EHR_.DATE_CREATED), (Field<String>)JoinBinder.ehrRecordTable.field((Field)Tables.EHR_.DATE_CREATED_TZID));
            }
            case "time_created/value": {
                return new GenericJsonField(this.fieldResolutionContext, this.joinSetup).forJsonPath("value").dvDateTime((Field<Timestamp>)JoinBinder.ehrRecordTable.field((Field)Tables.EHR_.DATE_CREATED), (Field<String>)JoinBinder.ehrRecordTable.field((Field)Tables.EHR_.DATE_CREATED_TZID));
            }
        }
        return new FullEhrJson(this.fieldResolutionContext, this.joinSetup).forJsonPath(path).sqlField();
    }

    public static boolean isEhrAttribute(String path) {
        if (path == null) {
            return false;
        }
        if (path.startsWith(EHR_STATUS) || path.startsWith(SYSTEM_ID)) {
            return true;
        }
        return path.matches("ehr_id|ehr_id/value|time_created|time_created/value");
    }
}

