/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.interfaces;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.util.UUID;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.ConceptRecord;
import org.jooq.Table;

public interface I_ConceptAccess {
    public static UUID fetchConcept(I_DomainAccess domainAccess, Integer conceptId, String language) {
        return ((ConceptRecord)domainAccess.getContext().fetchAny((Table)Tables.CONCEPT, Tables.CONCEPT.CONCEPTID.eq((Object)conceptId).and(Tables.CONCEPT.LANGUAGE.equal((Object)language)))).getId();
    }

    public static DvCodedText fetchConceptText(I_DomainAccess domainAccess, UUID uuid) {
        ConceptRecord conceptRecord = (ConceptRecord)domainAccess.getContext().fetchAny((Table)Tables.CONCEPT, Tables.CONCEPT.ID.eq((Object)uuid));
        return new DvCodedText(conceptRecord.getDescription(), new CodePhrase(new TerminologyId("openehr"), "" + conceptRecord.getConceptid()));
    }

    public static String fetchConceptLiteral(I_DomainAccess domainAccess, Integer conceptId, String language) {
        return ((ConceptRecord)domainAccess.getContext().fetchAny((Table)Tables.CONCEPT, Tables.CONCEPT.CONCEPTID.eq((Object)conceptId).and(Tables.CONCEPT.LANGUAGE.equal((Object)language)))).getDescription();
    }

    public static String fetchConceptLiteral(I_DomainAccess domainAccess, UUID uuid) {
        return ((ConceptRecord)domainAccess.getContext().fetchAny((Table)Tables.CONCEPT, Tables.CONCEPT.ID.eq((Object)uuid))).getDescription();
    }

    public static UUID fetchContributionChangeType(I_DomainAccess domainAccess, String changeTypeStr) {
        ContributionChangeType contributionChangeType = ContributionChangeType.valueOf(changeTypeStr.toUpperCase());
        int code = contributionChangeType.getCode();
        return ((ConceptRecord)domainAccess.getContext().fetchAny((Table)Tables.CONCEPT, Tables.CONCEPT.CONCEPTID.eq((Object)code).and(Tables.CONCEPT.LANGUAGE.equal((Object)"en")))).getId();
    }

    public static UUID fetchContributionChangeType(I_DomainAccess domainAccess, ContributionChangeType contributionChangeType) {
        if (contributionChangeType == null) {
            return null;
        }
        int code = contributionChangeType.getCode();
        return ((ConceptRecord)domainAccess.getContext().fetchAny((Table)Tables.CONCEPT, Tables.CONCEPT.CONCEPTID.eq((Object)code).and(Tables.CONCEPT.LANGUAGE.equal((Object)"en")))).getId();
    }

    public static UUID getVlcsDraft(I_DomainAccess domainAccess) {
        return ((ConceptRecord)domainAccess.getContext().fetchAny((Table)Tables.CONCEPT, Tables.CONCEPT.CONCEPTID.eq((Object)244).and(Tables.CONCEPT.LANGUAGE.equal((Object)"en")))).getId();
    }

    public static UUID getVlcsActive(I_DomainAccess domainAccess) {
        return ((ConceptRecord)domainAccess.getContext().fetchAny((Table)Tables.CONCEPT, Tables.CONCEPT.CONCEPTID.eq((Object)245).and(Tables.CONCEPT.LANGUAGE.equal((Object)"en")))).getId();
    }

    public static UUID getVlcsInactive(I_DomainAccess domainAccess) {
        return ((ConceptRecord)domainAccess.getContext().fetchAny((Table)Tables.CONCEPT, Tables.CONCEPT.CONCEPTID.eq((Object)246).and(Tables.CONCEPT.LANGUAGE.equal((Object)"en")))).getId();
    }

    public static UUID getVlcsAwaitingApproval(I_DomainAccess domainAccess) {
        return ((ConceptRecord)domainAccess.getContext().fetchAny((Table)Tables.CONCEPT, Tables.CONCEPT.CONCEPTID.eq((Object)247).and(Tables.CONCEPT.LANGUAGE.equal((Object)"en")))).getId();
    }

    public static enum ContributionChangeType {
        CREATION(249),
        AMENDMENT(250),
        MODIFICATION(251),
        SYNTHESIS(252),
        UNKNOWN(253),
        DELETED(523);

        final int code;

        private ContributionChangeType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

