/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.ObjectRef;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_FolderAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.ContributionDef;
import org.ehrbase.dao.access.util.FolderUtils;
import org.ehrbase.jooq.binding.OtherDetailsJsonbBinder;
import org.ehrbase.jooq.binding.SysPeriodBinder;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.Folder;
import org.ehrbase.jooq.pg.tables.records.FolderRecord;
import org.ehrbase.jooq.pg.tables.records.ObjectRefRecord;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.JSONB;
import org.jooq.Name;
import org.jooq.QueryPart;
import org.jooq.Record;
import org.jooq.Record11;
import org.jooq.Record15;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

public class FolderHistoryAccess
extends DataAccess
implements I_FolderAccess,
Comparable<FolderHistoryAccess> {
    private static final Logger log = LogManager.getLogger(FolderHistoryAccess.class);
    private List<ObjectRef<? extends ObjectId>> items = new ArrayList<ObjectRef<? extends ObjectId>>();
    private Map<UUID, I_FolderAccess> subfoldersList = new TreeMap<UUID, I_FolderAccess>();
    private I_ContributionAccess contributionAccess;
    private UUID ehrId;
    private FolderRecord folderRecord;

    public FolderHistoryAccess(I_DomainAccess domainAccess) {
        super(domainAccess);
        this.folderRecord = (FolderRecord)this.getContext().newRecord((Table)Folder.FOLDER);
        this.contributionAccess = I_ContributionAccess.getInstance(this, this.ehrId);
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
    }

    public FolderHistoryAccess(I_DomainAccess domainAccess, UUID ehrId, I_ContributionAccess contributionAccess) {
        super(domainAccess);
        this.ehrId = ehrId;
        this.folderRecord = (FolderRecord)this.getContext().newRecord((Table)Folder.FOLDER);
        this.contributionAccess = contributionAccess;
        if (contributionAccess == null) {
            this.contributionAccess = I_ContributionAccess.getInstance(this, this.ehrId);
        }
        UUID ehrIdLoc = this.contributionAccess.getEhrId();
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
    }

    @Override
    public UUID commit(LocalDateTime timestamp, UUID committerId, UUID systemId, String description) {
        return null;
    }

    @Override
    public UUID commit(LocalDateTime timestamp, UUID contribution) {
        return null;
    }

    @Override
    public boolean update(LocalDateTime timestamp, UUID committerId, UUID systemId, String description, I_ConceptAccess.ContributionChangeType changeType) {
        return false;
    }

    @Override
    public boolean update(LocalDateTime timestamp, UUID contribution) {
        return false;
    }

    @Override
    public int delete(LocalDateTime timestamp, UUID committerId, UUID systemId, String description) {
        return 0;
    }

    @Override
    public int delete(LocalDateTime timestamp, UUID contribution) {
        return 0;
    }

    private static FolderHistoryAccess buildFolderAccessFromGenericRecord(Record record_, I_DomainAccess domainAccess) {
        Record15 record = (Record15)record_;
        FolderHistoryAccess folderAccess = new FolderHistoryAccess(domainAccess);
        folderAccess.folderRecord = new FolderRecord();
        folderAccess.setFolderId((UUID)record.value1());
        folderAccess.setInContribution((UUID)record.value3());
        folderAccess.setFolderName((String)record.value10());
        folderAccess.setFolderNArchetypeNodeId((String)record.value11());
        folderAccess.setIsFolderActive((Boolean)record.value12());
        folderAccess.setFolderDetails((ItemStructure)new OtherDetailsJsonbBinder().converter().from((Object)((JSONB)record.value13())));
        folderAccess.setFolderSysTransaction((Timestamp)record.value14());
        folderAccess.setFolderSysPeriod((AbstractMap.SimpleEntry)new SysPeriodBinder().converter().from(record.value15()));
        folderAccess.getItems().addAll(FolderHistoryAccess.retrieveItemsByFolderAndContributionId((UUID)record.value1(), (UUID)record.value3(), domainAccess));
        return folderAccess;
    }

    private static FolderHistoryAccess buildFolderAccessFromFolderRecord(FolderRecord record_, I_DomainAccess domainAccess) {
        FolderRecord record = record_;
        FolderHistoryAccess folderAccess = new FolderHistoryAccess(domainAccess);
        folderAccess.folderRecord = new FolderRecord();
        folderAccess.setFolderId(record.getId());
        folderAccess.setInContribution(record.getInContribution());
        folderAccess.setFolderName(record.getName());
        folderAccess.setFolderNArchetypeNodeId(record.getArchetypeNodeId());
        folderAccess.setIsFolderActive(record.getActive());
        folderAccess.setFolderDetails(record.getDetails());
        folderAccess.setFolderSysTransaction(record.getSysTransaction());
        folderAccess.setFolderSysPeriod(record.getSysPeriod());
        folderAccess.getItems().addAll(FolderHistoryAccess.retrieveItemsByFolderAndContributionId(record.getId(), record.getInContribution(), domainAccess));
        return folderAccess;
    }

    private static FolderHistoryAccess buildFolderAccessFromFolderId(UUID id, UUID contributionId, I_DomainAccess domainAccess, Result<Record> folderSelectedRecordSub) {
        for (Record record : folderSelectedRecordSub) {
            if (!record.getValue("parent_folder").equals(id)) continue;
            return FolderHistoryAccess.buildFolderAccessFromGenericRecord(record, domainAccess);
        }
        FolderRecord folderSelectedRecord = FolderHistoryAccess.getFolderRecordByUidAndContribution(id, contributionId, domainAccess);
        if (folderSelectedRecord == null || folderSelectedRecord.size() < 1) {
            throw new ObjectNotFoundException("folder", "Folder with id " + id + " could not be found");
        }
        return FolderHistoryAccess.buildFolderAccessFromFolderRecord(folderSelectedRecord, domainAccess);
    }

    private static FolderRecord getFolderRecordByUidAndContribution(UUID folderId, UUID contributionId, I_DomainAccess domainAccess) {
        Table united_hierarchies_table1 = DSL.table((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER).where(Tables.FOLDER.ID.eq((Object)folderId).and(Tables.FOLDER.IN_CONTRIBUTION.eq((Object)contributionId))).union((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER_HISTORY).where(Tables.FOLDER_HISTORY.ID.eq((Object)folderId).and(Tables.FOLDER_HISTORY.IN_CONTRIBUTION.eq((Object)contributionId))))).asTable("folder_union_fol_hist");
        FolderRecord folderSelectedRecord = (FolderRecord)domainAccess.getContext().selectFrom(united_hierarchies_table1).fetchOne();
        return folderSelectedRecord;
    }

    private static List<ObjectRef<?>> retrieveItemsByFolderAndContributionId(UUID folderId, UUID in_contribution, I_DomainAccess domainAccess) {
        Table table_items_and_objref = DSL.table((Select)DSL.select((SelectField)Tables.FOLDER_ITEMS.FOLDER_ID, (SelectField)Tables.FOLDER_ITEMS.OBJECT_REF_ID.as("item_object_ref_id"), (SelectField)Tables.FOLDER_ITEMS.IN_CONTRIBUTION.as("item_in_contribution"), (SelectField)Tables.FOLDER_ITEMS.SYS_TRANSACTION, (SelectField)Tables.FOLDER_ITEMS.SYS_PERIOD, (SelectField)Tables.OBJECT_REF.ID_NAMESPACE, (SelectField)Tables.OBJECT_REF.TYPE, (SelectField)Tables.OBJECT_REF.ID.as("obj_ref_id"), (SelectField)Tables.OBJECT_REF.IN_CONTRIBUTION.as("obj_ref_in_cont"), (SelectField)Tables.OBJECT_REF.SYS_TRANSACTION.as("objRefSysTran"), (SelectField)Tables.OBJECT_REF.SYS_PERIOD.as("oref_sysperiod")).from((TableLike)Tables.FOLDER_ITEMS).leftJoin((TableLike)Tables.OBJECT_REF).on(Tables.FOLDER_ITEMS.FOLDER_ID.eq((Object)folderId).and(Tables.FOLDER_ITEMS.IN_CONTRIBUTION.eq((Object)in_contribution).and(Tables.OBJECT_REF.ID.eq((Field)Tables.FOLDER_ITEMS.OBJECT_REF_ID).and(Tables.OBJECT_REF.IN_CONTRIBUTION.eq((Field)Tables.FOLDER_ITEMS.IN_CONTRIBUTION))))).where(Tables.FOLDER_ITEMS.FOLDER_ID.eq((Object)folderId).and(Tables.FOLDER_ITEMS.IN_CONTRIBUTION.eq((Object)in_contribution))));
        Table table_items_and_objref_hist = DSL.table((Select)DSL.select((SelectField)Tables.FOLDER_ITEMS_HISTORY.FOLDER_ID, (SelectField)Tables.FOLDER_ITEMS_HISTORY.OBJECT_REF_ID.as("item_object_ref_id"), (SelectField)Tables.FOLDER_ITEMS_HISTORY.IN_CONTRIBUTION.as("item_in_contribution"), (SelectField)Tables.FOLDER_ITEMS_HISTORY.SYS_TRANSACTION, (SelectField)Tables.FOLDER_ITEMS_HISTORY.SYS_PERIOD, (SelectField)Tables.OBJECT_REF_HISTORY.ID_NAMESPACE, (SelectField)Tables.OBJECT_REF_HISTORY.TYPE, (SelectField)Tables.OBJECT_REF_HISTORY.ID.as("obj_ref_id"), (SelectField)Tables.OBJECT_REF_HISTORY.IN_CONTRIBUTION.as("obj_ref_in_cont"), (SelectField)Tables.OBJECT_REF_HISTORY.SYS_TRANSACTION.as("objRefSysTran"), (SelectField)Tables.OBJECT_REF_HISTORY.SYS_PERIOD.as("oref_sysperiod")).from((TableLike)Tables.FOLDER_ITEMS_HISTORY).leftJoin((TableLike)Tables.OBJECT_REF_HISTORY).on(Tables.FOLDER_ITEMS_HISTORY.FOLDER_ID.eq((Object)folderId).and(Tables.FOLDER_ITEMS_HISTORY.IN_CONTRIBUTION.eq((Object)in_contribution).and(Tables.OBJECT_REF_HISTORY.ID.eq((Field)Tables.FOLDER_ITEMS_HISTORY.OBJECT_REF_ID).and(Tables.OBJECT_REF_HISTORY.IN_CONTRIBUTION.eq((Field)Tables.FOLDER_ITEMS_HISTORY.IN_CONTRIBUTION))))).where(Tables.FOLDER_ITEMS_HISTORY.FOLDER_ID.eq((Object)folderId).and(Tables.FOLDER_ITEMS_HISTORY.IN_CONTRIBUTION.eq((Object)in_contribution))));
        Table table_all_items_and_objref = DSL.table((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)table_items_and_objref).union((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)table_items_and_objref_hist)));
        Result retrievedRecords = domainAccess.getContext().select(new SelectFieldOrAsterisk[0]).from((TableLike)table_all_items_and_objref).fetch();
        ArrayList result = new ArrayList();
        for (Record recordRecord : retrievedRecords) {
            Record11 recordParam = (Record11)recordRecord;
            ObjectRefRecord objectRef = new ObjectRefRecord();
            objectRef.setIdNamespace((String)recordParam.value6());
            objectRef.setType((String)recordParam.value7());
            objectRef.setId((UUID)recordParam.value8());
            objectRef.setInContribution((UUID)recordParam.value9());
            objectRef.setSysTransaction((Timestamp)recordParam.value10());
            objectRef.setSysPeriod((AbstractMap.SimpleEntry)recordParam.value11());
            objectRef.setId((UUID)recordParam.value8());
            result.add(FolderHistoryAccess.parseObjectRefRecordIntoObjectRef(objectRef, domainAccess));
        }
        return result;
    }

    private static ObjectRef parseObjectRefRecordIntoObjectRef(ObjectRefRecord objectRefRecord, I_DomainAccess domainAccess) {
        ObjectRef result = new ObjectRef();
        ObjectRefId oref = new FolderHistoryAccess(domainAccess).new ObjectRefId(objectRefRecord.getId().toString());
        result.setId((ObjectId)oref);
        result.setType(objectRefRecord.getType());
        result.setNamespace(objectRefRecord.getIdNamespace());
        return result;
    }

    public static Integer getLastVersionNumber(I_DomainAccess domainAccess, UUID folderId) {
        if (!FolderHistoryAccess.hasPreviousVersion(domainAccess, folderId)) {
            return 1;
        }
        int versionCount = domainAccess.getContext().fetchCount((Table)Tables.FOLDER_HISTORY, Tables.FOLDER_HISTORY.ID.eq((Object)folderId));
        return versionCount + 1;
    }

    public static boolean hasPreviousVersion(I_DomainAccess domainAccess, UUID folderId) {
        return domainAccess.getContext().fetchExists((Table)Tables.FOLDER_HISTORY, Tables.FOLDER_HISTORY.ID.eq((Object)folderId));
    }

    public UUID getEhrId() {
        return this.ehrId;
    }

    public void setEhrId(UUID ehrId) {
        this.ehrId = ehrId;
    }

    public I_ContributionAccess getContributionAccess() {
        return this.contributionAccess;
    }

    public void setContributionAccess(I_ContributionAccess contributionAccess) {
        this.contributionAccess = contributionAccess;
    }

    FolderRecord getFolderRecord() {
        return this.folderRecord;
    }

    public void setSubfoldersList(Map<UUID, I_FolderAccess> subfolders) {
        this.subfoldersList = subfolders;
    }

    @Override
    public Map<UUID, I_FolderAccess> getSubfoldersList() {
        return this.subfoldersList;
    }

    @Override
    public List<ObjectRef<? extends ObjectId>> getItems() {
        return this.items;
    }

    @Override
    public UUID getFolderId() {
        return this.folderRecord.getId();
    }

    @Override
    public void setFolderId(UUID folderId) {
        this.folderRecord.setId(folderId);
    }

    @Override
    public UUID getInContribution() {
        return this.folderRecord.getInContribution();
    }

    @Override
    public void setInContribution(UUID inContribution) {
        this.folderRecord.setInContribution(inContribution);
    }

    @Override
    public String getFolderName() {
        return this.folderRecord.getName();
    }

    @Override
    public void setFolderName(String folderName) {
        this.folderRecord.setName(folderName);
    }

    @Override
    public String getFolderArchetypeNodeId() {
        return this.folderRecord.getArchetypeNodeId();
    }

    @Override
    public void setFolderNArchetypeNodeId(String folderArchetypeNodeId) {
        this.folderRecord.setArchetypeNodeId(folderArchetypeNodeId);
    }

    @Override
    public boolean isFolderActive() {
        return this.folderRecord.getActive();
    }

    @Override
    public void setIsFolderActive(boolean folderActive) {
        this.folderRecord.setActive(Boolean.valueOf(folderActive));
    }

    @Override
    public ItemStructure getFolderDetails() {
        return this.folderRecord.getDetails();
    }

    @Override
    public void setFolderDetails(ItemStructure folderDetails) {
        this.folderRecord.setDetails(folderDetails);
    }

    @Override
    public void setFolderSysTransaction(Timestamp folderSysTransaction) {
        this.folderRecord.setSysTransaction(folderSysTransaction);
    }

    @Override
    public Timestamp getFolderSysTransaction() {
        return this.folderRecord.getSysTransaction();
    }

    @Override
    public AbstractMap.SimpleEntry<OffsetDateTime, OffsetDateTime> getFolderSysPeriod() {
        return this.folderRecord.getSysPeriod();
    }

    @Override
    public void setFolderSysPeriod(AbstractMap.SimpleEntry<OffsetDateTime, OffsetDateTime> folderSysPeriod) {
        this.folderRecord.setSysPeriod(folderSysPeriod);
    }

    @Override
    public UUID getAudit() {
        return this.getFolderRecord().getHasAudit();
    }

    @Override
    public void setAudit(UUID auditId) {
        this.getFolderRecord().setHasAudit(auditId);
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    @Override
    public int compareTo(FolderHistoryAccess o) {
        return o.getFolderRecord().getId().compareTo(this.folderRecord.getId());
    }

    public static int getVersionFromTimeStamp(I_DomainAccess domainAccess, UUID vFolderUid, Timestamp timeCommitted) throws InternalServerException {
        Record result2;
        Record result;
        if (timeCommitted == null) {
            return FolderHistoryAccess.getLastVersionNumber(domainAccess, vFolderUid);
        }
        try {
            result = domainAccess.getContext().select((SelectField)DSL.max((Field)Tables.FOLDER.SYS_TRANSACTION).as("mostRecentInTable")).from((TableLike)Tables.FOLDER).where(Tables.FOLDER.ID.eq((Object)vFolderUid)).fetchOne();
        }
        catch (RuntimeException e) {
            throw new InternalServerException("Problem with SQL statement or input", (Exception)e);
        }
        Timestamp latestCompoTime = (Timestamp)result.get("mostRecentInTable");
        try {
            result2 = domainAccess.getContext().select((SelectField)DSL.count().as("countVersionInTable")).from((TableLike)Tables.FOLDER).where(Tables.FOLDER_HISTORY.SYS_TRANSACTION.lessOrEqual((Object)timeCommitted).and(Tables.FOLDER_HISTORY.ID.eq((Object)vFolderUid))).fetchOne();
        }
        catch (RuntimeException e) {
            throw new InternalServerException("Problem with SQL statement or input", (Exception)e);
        }
        int versionComHist = (Integer)result2.get("countVersionInTable");
        if (timeCommitted.compareTo(latestCompoTime) >= 0) {
            ++versionComHist;
        }
        if (versionComHist == 0) {
            throw new ObjectNotFoundException("FOLDER VERSION", "There are no versions available prior to date " + timeCommitted + " for the the FOLDER with id: " + vFolderUid);
        }
        return versionComHist;
    }

    private static Result<Record> buildUnionOfFolderHierarchiesTable(UUID folderUid, Timestamp ts, I_DomainAccess domainAccess) {
        Timestamp timestamp = Timestamp.from(ts.toInstant().plusMillis(1L));
        Table united_hierarchies_table1 = DSL.table((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER_HIERARCHY).where(Tables.FOLDER_HIERARCHY.SYS_TRANSACTION.le((Object)timestamp)).union((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER_HIERARCHY_HISTORY).where(Tables.FOLDER_HIERARCHY_HISTORY.SYS_TRANSACTION.le((Object)timestamp)))).asTable("united_hierarchies_table1");
        Table united_hierarchies_table2 = DSL.table((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER_HIERARCHY).where(Tables.FOLDER_HIERARCHY.SYS_TRANSACTION.le((Object)timestamp)).union((Select)DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)Tables.FOLDER_HIERARCHY_HISTORY).where(Tables.FOLDER_HIERARCHY_HISTORY.SYS_TRANSACTION.le((Object)timestamp)))).asTable("united_hierarchies_table2");
        Table united_hierarchies_tableFileted = DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)united_hierarchies_table1).where(united_hierarchies_table1.field("sys_transaction", Tables.FOLDER_HIERARCHY.SYS_TRANSACTION.getType()).eq((Select)DSL.select((SelectField)DSL.max((Field)united_hierarchies_table2.field("sys_transaction", Tables.FOLDER_HIERARCHY.SYS_TRANSACTION.getType()))).from((TableLike)united_hierarchies_table2).where(united_hierarchies_table1.field("parent_folder", Tables.FOLDER_HIERARCHY.PARENT_FOLDER.getType()).eq(united_hierarchies_table2.field("parent_folder", Tables.FOLDER_HIERARCHY.PARENT_FOLDER.getType())).and(united_hierarchies_table1.field("child_folder", Tables.FOLDER_HIERARCHY.CHILD_FOLDER.getType()).eq(united_hierarchies_table2.field("child_folder", Tables.FOLDER_HIERARCHY.CHILD_FOLDER.getType())))))).asTable("united_hierarchies_tableFileted");
        Table fhf_timestamp1 = DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)united_hierarchies_tableFileted).asTable();
        Table fhf_timestamp2 = DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)united_hierarchies_tableFileted).asTable();
        Table fhf_timestamp_version2 = DSL.select((SelectField)fhf_timestamp1.field("parent_folder", Tables.FOLDER.ID.getType()).as("parent_folder_id"), (SelectField)DSL.max((Field)fhf_timestamp2.field("sys_transaction", Tables.FOLDER.SYS_TRANSACTION.getType())).as("latest_sys_transaction")).from((TableLike)fhf_timestamp1).groupBy(new GroupField[]{fhf_timestamp1.field("parent_folder", Tables.FOLDER.ID.getType())}).asTable();
        Table filteredHierarchicalTable = DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from(new TableLike[]{united_hierarchies_tableFileted, fhf_timestamp_version2}).where(united_hierarchies_tableFileted.field("parent_folder", Tables.FOLDER.ID.getType()).eq(fhf_timestamp_version2.field("parent_folder_id", Tables.FOLDER.ID.getType())).and(united_hierarchies_tableFileted.field("sys_transaction", Tables.FOLDER.SYS_TRANSACTION.getType()).eq(fhf_timestamp_version2.field("latest_sys_transaction", Tables.FOLDER.SYS_TRANSACTION.getType())))).asTable();
        Field subfolderParentFolderRef = DSL.field((Name)DSL.name((String[])new String[]{"subfolders", "parent_folder"}), UUID.class);
        Table allFolderRowsFolderTable = domainAccess.getContext().select((SelectField)Tables.FOLDER.ID, (SelectField)Tables.FOLDER.IN_CONTRIBUTION, (SelectField)Tables.FOLDER.NAME, (SelectField)Tables.FOLDER.ARCHETYPE_NODE_ID, (SelectField)Tables.FOLDER.ACTIVE, (SelectField)Tables.FOLDER.DETAILS, (SelectField)Tables.FOLDER.SYS_TRANSACTION, (SelectField)Tables.FOLDER.SYS_PERIOD).from(new TableLike[]{Tables.FOLDER, filteredHierarchicalTable}).where(Tables.FOLDER.ID.eq(filteredHierarchicalTable.field("parent_folder", UUID.class)).and(Tables.FOLDER.IN_CONTRIBUTION.eq(filteredHierarchicalTable.field("in_contribution", UUID.class)))).asTable();
        Table allFolderRowsFolderHistoryTable = domainAccess.getContext().select((SelectField)Tables.FOLDER_HISTORY.ID, (SelectField)Tables.FOLDER_HISTORY.IN_CONTRIBUTION, (SelectField)Tables.FOLDER_HISTORY.NAME, (SelectField)Tables.FOLDER_HISTORY.ARCHETYPE_NODE_ID, (SelectField)Tables.FOLDER_HISTORY.ACTIVE, (SelectField)Tables.FOLDER_HISTORY.DETAILS, (SelectField)Tables.FOLDER_HISTORY.SYS_TRANSACTION, (SelectField)Tables.FOLDER_HISTORY.SYS_PERIOD).from(new TableLike[]{Tables.FOLDER_HISTORY, filteredHierarchicalTable}).where(Tables.FOLDER_HISTORY.ID.eq(filteredHierarchicalTable.field("parent_folder", UUID.class)).and(Tables.FOLDER_HISTORY.IN_CONTRIBUTION.eq(filteredHierarchicalTable.field("in_contribution", UUID.class)))).asTable();
        Table allFolderRowsUnifiedAndFilteredInitial = domainAccess.getContext().select((SelectField)allFolderRowsFolderTable.field("id", UUID.class), (SelectField)allFolderRowsFolderTable.field("in_contribution", UUID.class).as("in_contribution_folder_info"), (SelectField)allFolderRowsFolderTable.field("name", Tables.FOLDER.NAME.getType()), (SelectField)allFolderRowsFolderTable.field("archetype_node_id", Tables.FOLDER.ARCHETYPE_NODE_ID.getType()), (SelectField)allFolderRowsFolderTable.field("active", Tables.FOLDER.ACTIVE.getType()), (SelectField)allFolderRowsFolderTable.field("details", Tables.FOLDER.DETAILS.getType()), (SelectField)allFolderRowsFolderTable.field("sys_transaction", Tables.FOLDER.SYS_TRANSACTION.getType()).as("sys_transaction_folder"), (SelectField)allFolderRowsFolderTable.field("sys_period", Tables.FOLDER.SYS_PERIOD.getType()).as("sys_period_folder")).from((TableLike)allFolderRowsFolderTable).union((Select)DSL.select((SelectField)allFolderRowsFolderHistoryTable.field("id", UUID.class), (SelectField)allFolderRowsFolderHistoryTable.field("in_contribution", UUID.class).as("in_contribution_folder_info"), (SelectField)allFolderRowsFolderHistoryTable.field("name", Tables.FOLDER.NAME.getType()), (SelectField)allFolderRowsFolderHistoryTable.field("archetype_node_id", Tables.FOLDER.ARCHETYPE_NODE_ID.getType()), (SelectField)allFolderRowsFolderHistoryTable.field("active", Tables.FOLDER.ACTIVE.getType()), (SelectField)allFolderRowsFolderHistoryTable.field("details", Tables.FOLDER.DETAILS.getType()), (SelectField)allFolderRowsFolderHistoryTable.field("sys_transaction", Tables.FOLDER.SYS_TRANSACTION.getType()).as("sys_transaction_folder"), (SelectField)allFolderRowsFolderHistoryTable.field("sys_period", Tables.FOLDER.SYS_PERIOD.getType()).as("sys_period_folder")).from((TableLike)allFolderRowsFolderHistoryTable)).asTable();
        Table allFolderRowsUnifiedAndFilteredIterative = domainAccess.getContext().select((SelectField)allFolderRowsFolderTable.field("id", UUID.class), (SelectField)allFolderRowsFolderTable.field("in_contribution", UUID.class).as("in_contribution_folder_info"), (SelectField)allFolderRowsFolderTable.field("name", Tables.FOLDER.NAME.getType()), (SelectField)allFolderRowsFolderTable.field("archetype_node_id", Tables.FOLDER.ARCHETYPE_NODE_ID.getType()), (SelectField)allFolderRowsFolderTable.field("active", Tables.FOLDER.ACTIVE.getType()), (SelectField)allFolderRowsFolderTable.field("details", Tables.FOLDER.DETAILS.getType()), (SelectField)allFolderRowsFolderTable.field("sys_transaction", Tables.FOLDER.SYS_TRANSACTION.getType()).as("sys_transaction_folder"), (SelectField)allFolderRowsFolderTable.field("sys_period", Tables.FOLDER.SYS_PERIOD.getType()).as("sys_period_folder")).from((TableLike)allFolderRowsFolderTable).union((Select)DSL.select((SelectField)allFolderRowsFolderHistoryTable.field("id", UUID.class), (SelectField)allFolderRowsFolderHistoryTable.field("in_contribution", UUID.class).as("in_contribution_folder_info"), (SelectField)allFolderRowsFolderHistoryTable.field("name", Tables.FOLDER.NAME.getType()), (SelectField)allFolderRowsFolderHistoryTable.field("archetype_node_id", Tables.FOLDER.ARCHETYPE_NODE_ID.getType()), (SelectField)allFolderRowsFolderHistoryTable.field("active", Tables.FOLDER.ACTIVE.getType()), (SelectField)allFolderRowsFolderHistoryTable.field("details", Tables.FOLDER.DETAILS.getType()), (SelectField)allFolderRowsFolderHistoryTable.field("sys_transaction", Tables.FOLDER.SYS_TRANSACTION.getType()).as("sys_transaction_folder"), (SelectField)allFolderRowsFolderHistoryTable.field("sys_period", Tables.FOLDER.SYS_PERIOD.getType()).as("sys_period_folder")).from((TableLike)allFolderRowsFolderHistoryTable)).asTable();
        Field subfolderChildFolder = DSL.field((String)"subfolders.{0}", (DataType)Tables.FOLDER_HIERARCHY.CHILD_FOLDER.getDataType(), (QueryPart[])new QueryPart[]{Tables.FOLDER_HIERARCHY.CHILD_FOLDER.getUnqualifiedName()});
        Field subfolderSysTran = DSL.field((String)"\"subfolders\".\"sys_transaction\"", (DataType)Tables.FOLDER_HIERARCHY.SYS_TRANSACTION.getDataType(), (QueryPart[])new QueryPart[]{Tables.FOLDER_HIERARCHY.SYS_TRANSACTION.getUnqualifiedName()});
        Table initial_table2 = DSL.select((SelectFieldOrAsterisk[])new SelectFieldOrAsterisk[0]).from((TableLike)filteredHierarchicalTable).leftJoin((TableLike)allFolderRowsUnifiedAndFilteredInitial).on(filteredHierarchicalTable.field("parent_folder", UUID.class).eq(allFolderRowsUnifiedAndFilteredInitial.field("id", UUID.class))).where(filteredHierarchicalTable.field("parent_folder", UUID.class).eq((Object)folderUid)).asTable();
        return domainAccess.getContext().withRecursive("subfolders").as((Select)DSL.select((SelectFieldOrAsterisk[])initial_table2.fields()).from((TableLike)initial_table2).union((Select)DSL.select((SelectFieldOrAsterisk[])((SelectFieldOrAsterisk[])ArrayUtils.addAll((Object[])filteredHierarchicalTable.fields(), (Object[])allFolderRowsUnifiedAndFilteredIterative.fields()))).from((TableLike)filteredHierarchicalTable).innerJoin("subfolders").on(filteredHierarchicalTable.field("parent_folder", Tables.FOLDER_HIERARCHY.PARENT_FOLDER.getType()).eq(subfolderChildFolder)).leftJoin((TableLike)allFolderRowsUnifiedAndFilteredIterative).on(allFolderRowsUnifiedAndFilteredIterative.field("id", Tables.FOLDER.ID.getType()).eq(subfolderChildFolder)))).select(new SelectFieldOrAsterisk[0]).from((TableLike)DSL.table((Name)DSL.name((String)"subfolders"))).fetch();
    }

    public static I_FolderAccess getInstanceForExistingFolder(I_DomainAccess domainAccess, ObjectVersionId folderId, Timestamp timestamp) {
        return FolderHistoryAccess.retrieveInstanceForExistingFolder(domainAccess, FolderUtils.extractUuidFromObjectVersionId(folderId), timestamp);
    }

    public static I_FolderAccess retrieveInstanceForExistingFolder(I_DomainAccess domainAccess, UUID folderId, Timestamp timestamp) {
        Result<Record> folderSelectedRecordSub = FolderHistoryAccess.buildUnionOfFolderHierarchiesTable(folderId, timestamp, domainAccess);
        TreeMap<UUID, Map<UUID, I_FolderAccess>> fHierarchyMap = new TreeMap<UUID, Map<UUID, I_FolderAccess>>();
        for (Record record : folderSelectedRecordSub) {
            if (!fHierarchyMap.containsKey((UUID)record.getValue("parent_folder"))) {
                fHierarchyMap.put((UUID)record.getValue("parent_folder"), new TreeMap());
            }
            ((Map)fHierarchyMap.get(record.getValue("parent_folder"))).put((UUID)record.getValue("child_folder"), FolderHistoryAccess.buildFolderAccessFromFolderId((UUID)record.getValue("child_folder"), (UUID)record.getValue("in_contribution"), domainAccess, folderSelectedRecordSub));
        }
        return FolderHistoryAccess.buildFolderAccessHierarchy(fHierarchyMap, folderId, null, folderSelectedRecordSub, domainAccess);
    }

    private static I_FolderAccess buildFolderAccessHierarchy(Map<UUID, Map<UUID, I_FolderAccess>> fHierarchyMap, UUID currentFolder, I_FolderAccess parentFa, Result<Record> folderSelectedRecordSub, I_DomainAccess domainAccess) {
        if (parentFa != null && parentFa.getSubfoldersList().keySet().contains(currentFolder)) {
            return parentFa.getSubfoldersList().get(currentFolder);
        }
        UUID contributionUid = null;
        for (Record record : folderSelectedRecordSub) {
            if (((UUID)record.getValue("parent_folder")).equals(currentFolder)) {
                contributionUid = (UUID)record.getValue("in_contribution");
                continue;
            }
            if (!((UUID)record.getValue("child_folder")).equals(currentFolder)) continue;
            contributionUid = (UUID)record.getValue("in_contribution");
        }
        FolderHistoryAccess folderAccess = FolderHistoryAccess.buildFolderAccessFromFolderId(currentFolder, contributionUid, domainAccess, folderSelectedRecordSub);
        if (parentFa != null) {
            parentFa.getSubfoldersList().put(currentFolder, folderAccess);
        }
        if (fHierarchyMap.get(currentFolder) != null) {
            for (UUID newChild : fHierarchyMap.get(currentFolder).keySet()) {
                FolderHistoryAccess.buildFolderAccessHierarchy(fHierarchyMap, newChild, folderAccess, folderSelectedRecordSub, domainAccess);
            }
        }
        return folderAccess;
    }

    @Override
    public void adminDeleteFolder() {
    }

    private class ObjectRefId
    extends ObjectId {
        public ObjectRefId(String value) {
            super(value);
        }
    }
}

