/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_StoredQueryAccess;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.StoredQueryQualifiedName;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.StoredQueryRecord;
import org.joda.time.DateTime;
import org.jooq.Condition;
import org.jooq.OrderField;
import org.jooq.Result;
import org.jooq.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredQueryAccess
extends DataAccess
implements I_StoredQueryAccess {
    static final Logger log = LoggerFactory.getLogger(StoredQueryAccess.class);
    private StoredQueryRecord storedQueryRecord;

    public StoredQueryAccess(I_DomainAccess domainAccess) {
        super(domainAccess);
    }

    public StoredQueryAccess(I_DomainAccess domainAccess, StoredQueryRecord queryRecord) {
        super(domainAccess);
        this.storedQueryRecord = queryRecord;
    }

    public StoredQueryAccess(I_DomainAccess domainAccess, String qualifiedQueryName, String sourceAqlText) {
        super(domainAccess);
        this.storedQueryRecord = (StoredQueryRecord)domainAccess.getContext().newRecord((Table)Tables.STORED_QUERY);
        StoredQueryQualifiedName storedQueryQualifiedName = new StoredQueryQualifiedName(qualifiedQueryName);
        this.storedQueryRecord.setReverseDomainName(storedQueryQualifiedName.reverseDomainName());
        this.storedQueryRecord.setSemanticId(storedQueryQualifiedName.semanticId());
        if (storedQueryQualifiedName.isSetSemVer()) {
            this.storedQueryRecord.setSemver(storedQueryQualifiedName.semVer());
        }
        this.storedQueryRecord.setQueryText(sourceAqlText);
        this.storedQueryRecord.setType("AQL");
    }

    public static StoredQueryAccess retrieveQualified(I_DomainAccess domainAccess, String qualifiedName) {
        StoredQueryQualifiedName storedQueryQualifiedName = new StoredQueryQualifiedName(qualifiedName);
        String reverseDomainName = storedQueryQualifiedName.reverseDomainName();
        String semanticId = storedQueryQualifiedName.semanticId();
        String semVer = storedQueryQualifiedName.semVer();
        StoredQueryRecord queryRecord = semVer != null && !semVer.toUpperCase().equals("LATEST") ? (StoredQueryRecord)domainAccess.getContext().selectFrom((Table)Tables.STORED_QUERY).where(Tables.STORED_QUERY.REVERSE_DOMAIN_NAME.eq((Object)reverseDomainName).and(Tables.STORED_QUERY.SEMANTIC_ID.eq((Object)semanticId)).and((Condition)Tables.STORED_QUERY.SEMVER.like(semVer + "%"))).orderBy((OrderField)Tables.STORED_QUERY.SEMVER.desc()).limit(1).fetchOne() : (StoredQueryRecord)domainAccess.getContext().selectFrom((Table)Tables.STORED_QUERY).where(Tables.STORED_QUERY.REVERSE_DOMAIN_NAME.eq((Object)reverseDomainName).and(Tables.STORED_QUERY.SEMANTIC_ID.eq((Object)semanticId))).orderBy((OrderField)Tables.STORED_QUERY.SEMVER.desc()).limit(1).fetchOne();
        if (queryRecord == null) {
            log.warn("Could not retrieve stored query for qualified name:" + qualifiedName);
            throw new IllegalArgumentException("Could not retrieve stored query for qualified name:" + qualifiedName);
        }
        return new StoredQueryAccess(domainAccess, queryRecord);
    }

    public static List<StoredQueryAccess> retrieveQualifiedList(I_DomainAccess domainAccess, String qualifiedName) {
        StoredQueryQualifiedName storedQueryQualifiedName = new StoredQueryQualifiedName(qualifiedName);
        String reverseDomainName = storedQueryQualifiedName.reverseDomainName();
        String semanticId = storedQueryQualifiedName.semanticId();
        Result queryRecords = domainAccess.getContext().selectFrom((Table)Tables.STORED_QUERY).where(Tables.STORED_QUERY.REVERSE_DOMAIN_NAME.eq((Object)reverseDomainName).and(Tables.STORED_QUERY.SEMANTIC_ID.eq((Object)semanticId))).orderBy((OrderField)Tables.STORED_QUERY.SEMVER.desc()).fetch();
        ArrayList<StoredQueryAccess> storedQueryAccesses = new ArrayList<StoredQueryAccess>();
        if (queryRecords == null) {
            log.warn("Could not retrieve Aql Text for qualified name:" + qualifiedName);
        } else {
            for (StoredQueryRecord storedQueryRecord : queryRecords) {
                storedQueryAccesses.add(new StoredQueryAccess(domainAccess, storedQueryRecord));
            }
        }
        return storedQueryAccesses;
    }

    public static List<StoredQueryAccess> retrieveQualifiedList(I_DomainAccess domainAccess) {
        Result queryRecords = domainAccess.getContext().selectFrom((Table)Tables.STORED_QUERY).orderBy((OrderField)Tables.STORED_QUERY.SEMVER.desc()).fetch();
        ArrayList<StoredQueryAccess> storedQueryAccesses = new ArrayList<StoredQueryAccess>();
        if (queryRecords == null) {
            log.warn("Empty stored query set");
        } else {
            for (StoredQueryRecord storedQueryRecord : queryRecords) {
                storedQueryAccesses.add(new StoredQueryAccess(domainAccess, storedQueryRecord));
            }
        }
        return storedQueryAccesses;
    }

    @Override
    public StoredQueryAccess commit(Timestamp transactionTime) {
        this.storedQueryRecord.setCreationDate(transactionTime);
        this.storedQueryRecord.store();
        return this;
    }

    @Override
    public StoredQueryAccess commit() {
        return this.commit(new Timestamp(DateTime.now().getMillis()));
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        this.storedQueryRecord.setCreationDate(transactionTime);
        if (this.storedQueryRecord.changed()) {
            return this.storedQueryRecord.update() > 0;
        }
        return false;
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        return this.update(transactionTime);
    }

    @Override
    public Integer delete() {
        return this.storedQueryRecord.delete();
    }

    @Override
    public String getQualifiedName() {
        return new StoredQueryQualifiedName(this.storedQueryRecord.getReverseDomainName(), this.storedQueryRecord.getSemanticId(), this.storedQueryRecord.getSemver()).toString();
    }

    @Override
    public String getReverseDomainName() {
        return this.storedQueryRecord.getReverseDomainName();
    }

    @Override
    public String getSemanticId() {
        return this.storedQueryRecord.getSemanticId();
    }

    @Override
    public String getSemver() {
        return this.storedQueryRecord.getSemver();
    }

    @Override
    public String getQueryText() {
        return this.storedQueryRecord.getQueryText();
    }

    @Override
    public void setQueryText(String queryText) {
        this.storedQueryRecord.setQueryText(queryText);
    }

    @Override
    public Timestamp getCreationDate() {
        return this.storedQueryRecord.getCreationDate();
    }

    @Override
    public String getQueryType() {
        return this.storedQueryRecord.getType();
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }
}

