/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.datavalues.DvIdentifier;
import java.util.ArrayList;
import java.util.UUID;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.service.BaseService;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_SystemAccess;
import org.ehrbase.dao.access.jooq.party.PersistedPartyProxy;
import org.ehrbase.dao.access.support.ServiceDataAccess;
import org.ehrbase.service.IAuthenticationFacade;
import org.ehrbase.service.KnowledgeCacheService;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseServiceImp
implements BaseService {
    public static final String DEMOGRAPHIC = "DEMOGRAPHIC";
    public static final String PARTY = "PARTY";
    private final ServerConfig serverConfig;
    private final KnowledgeCacheService knowledgeCacheService;
    private final DSLContext context;
    @Autowired
    private IAuthenticationFacade authenticationFacade;

    public BaseServiceImp(KnowledgeCacheService knowledgeCacheService, DSLContext context, ServerConfig serverConfig) {
        this.knowledgeCacheService = knowledgeCacheService;
        this.context = context;
        this.serverConfig = serverConfig;
    }

    protected I_DomainAccess getDataAccess() {
        return new ServiceDataAccess(this.context, this.knowledgeCacheService, this.knowledgeCacheService, this.serverConfig);
    }

    public UUID getSystemUuid() {
        return I_SystemAccess.createOrRetrieveLocalSystem(this.getDataAccess());
    }

    protected UUID getUserUuid() {
        String name = this.authenticationFacade.getAuthentication().getName();
        ArrayList<DvIdentifier> identifiers = new ArrayList<DvIdentifier>();
        DvIdentifier identifier = new DvIdentifier();
        identifier.setId(name);
        identifier.setIssuer("EHRbase");
        identifier.setAssigner("EHRbase");
        identifier.setType("EHRbase Security Authentication User");
        identifiers.add(identifier);
        return new PersistedPartyProxy(this.getDataAccess()).getOrCreate("EHRbase Internal " + name, UUID.randomUUID().toString(), DEMOGRAPHIC, "User", PARTY, identifiers);
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }
}

