/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.compiler;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ehrbase.aql.definition.FunctionDefinition;
import org.ehrbase.aql.definition.I_VariableDefinition;

public class AuditVariables {
    public static final String AUDIT_VARIABLE_PREFIX = "$__AUDIT_";
    public static final String EHR_PATH = "ehr_id/value";
    public static final String TEMPLATE_PATH = "archetype_details/template_id/value";
    public static final String[][] requiredAuditVariables = new String[][]{{"ehr_id/value", "$__AUDIT_EHR_ID", "e"}, {"archetype_details/template_id/value", "$__AUDIT_TEMPLATE_ID", "c"}};
    private Set<String> skipList = new HashSet<String>();

    public boolean isAuditVariable(I_VariableDefinition variable) {
        boolean retval = false;
        for (String[] auditVarDef : requiredAuditVariables) {
            if (variable instanceof FunctionDefinition) {
                if (!variable.getPath().contains(auditVarDef[0])) continue;
                this.skipList.add(auditVarDef[0]);
                continue;
            }
            if (variable.getPath() == null || !variable.getPath().equals(auditVarDef[0])) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public void addResults(Map<String, Set<Object>> auditResultMap, String path, Set<Object> resultSetForVariable) {
        if (!this.skipList.contains(path)) {
            auditResultMap.put(path, resultSetForVariable);
        }
    }
}

