/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.InputMismatchException;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ehrbase.aql.compiler.recovery.RecoverArchetypeId;
import org.ehrbase.aql.containment.ComplexContainsCheck;
import org.ehrbase.aql.containment.ContainPropositions;
import org.ehrbase.aql.containment.Containment;
import org.ehrbase.aql.containment.ContainmentSet;
import org.ehrbase.aql.containment.ContainsExpressions;
import org.ehrbase.aql.containment.ContainsProposition;
import org.ehrbase.aql.containment.IdentifierMapper;
import org.ehrbase.aql.containment.SimpleChainedCheck;
import org.ehrbase.aql.containment.SimpleClassExpressionIdentifier;
import org.ehrbase.aql.definition.FromEhrDefinition;
import org.ehrbase.aql.definition.FromForeignDataDefinition;
import org.ehrbase.aql.definition.I_FromEntityDefinition;
import org.ehrbase.aql.parser.AqlBaseListener;
import org.ehrbase.aql.parser.AqlParser;

public class QueryCompilerPass1
extends AqlBaseListener {
    public static final int EQUALITY_ARGUMENTS_COUNT = 3;
    public static final int JOIN_ARGUMENTS_COUNT = 4;
    private Logger logger = LogManager.getLogger(QueryCompilerPass1.class);
    private IdentifierMapper identifierMapper = new IdentifierMapper();
    private Map<String, ContainmentSet> containmentSetMap = new HashMap<String, ContainmentSet>();
    private ContainPropositions containPropositions = new ContainPropositions(this.identifierMapper);

    @Override
    public void exitFromEHR(AqlParser.FromEHRContext context) {
        FromEhrDefinition fromEhrDefinition = new FromEhrDefinition();
        if (context.IDENTIFIER() != null) {
            this.visitFromExpressionChildren(fromEhrDefinition, context.children);
            String identifier = context.IDENTIFIER().getText();
            fromEhrDefinition.setIdentifier(identifier);
            if (!fromEhrDefinition.getEhrPredicates().isEmpty()) {
                fromEhrDefinition.getEhrPredicates().get(0).setIdentifier(identifier);
                this.identifierMapper.add(fromEhrDefinition.getEhrPredicates().get(0));
            } else {
                this.identifierMapper.add(new FromEhrDefinition.EhrPredicate(identifier));
            }
        }
        if (context.EHR() != null) {
            fromEhrDefinition.setIsEHR(true);
        }
        this.logger.debug("FromEHR");
    }

    private void visitFromExpressionChildren(I_FromEntityDefinition fromEntityDefinition, List<ParseTree> children) {
        if (children.isEmpty()) {
            return;
        }
        for (ParseTree node : children) {
            AqlParser.StandardPredicateContext equalityContext;
            if (node.getText().equals("[") || node.getText().equals("]") || !(node instanceof AqlParser.StandardPredicateContext) || (equalityContext = (AqlParser.StandardPredicateContext)node).getChildCount() != 3) continue;
            AqlParser.PredicateExprContext predicateExprContext = (AqlParser.PredicateExprContext)equalityContext.getChild(1);
            AqlParser.PredicateAndContext predicateAndContext = (AqlParser.PredicateAndContext)predicateExprContext.getChild(0);
            AqlParser.PredicateEqualityContext predicateEqualityContext = (AqlParser.PredicateEqualityContext)predicateAndContext.getChild(0);
            if (predicateEqualityContext.getChildCount() != 3) {
                throw new IllegalArgumentException("Could not handle predicateEqualityContext:" + predicateAndContext.getText());
            }
            fromEntityDefinition.add(predicateEqualityContext.getChild(0).getText(), predicateEqualityContext.getChild(2).getText(), predicateEqualityContext.getChild(1).getText());
        }
    }

    private void visitJoinExpressionChildren(I_FromEntityDefinition fromEntityDefinition, List<ParseTree> children) {
        if (children.isEmpty()) {
            return;
        }
        for (ParseTree node : children) {
            AqlParser.JoinPredicateContext joinContext;
            if (node.getText().equals("[") || node.getText().equals("]") || !(node instanceof AqlParser.JoinPredicateContext) || (joinContext = (AqlParser.JoinPredicateContext)node).getChildCount() != 4) continue;
            AqlParser.PredicateEqualityContext predicateEqualityContext = (AqlParser.PredicateEqualityContext)joinContext.getChild(2);
            if (predicateEqualityContext.getChildCount() != 3) {
                throw new IllegalArgumentException("Could not handle predicateEqualityContext:" + predicateEqualityContext.getText());
            }
            fromEntityDefinition.add(predicateEqualityContext.getChild(0).getText(), predicateEqualityContext.getChild(2).getText(), predicateEqualityContext.getChild(1).getText());
        }
    }

    @Override
    public void exitFromForeignData(AqlParser.FromForeignDataContext context) {
        FromForeignDataDefinition fromForeignDataDefinition = new FromForeignDataDefinition(context.getChild(0).getText());
        if (context.IDENTIFIER() != null) {
            this.visitJoinExpressionChildren(fromForeignDataDefinition, context.children);
            String identifier = context.IDENTIFIER().getText();
            fromForeignDataDefinition.setIdentifier(identifier);
            if (!fromForeignDataDefinition.getFDPredicates().isEmpty()) {
                fromForeignDataDefinition.getFDPredicates().get(0).setIdentifier(identifier);
                this.identifierMapper.add(fromForeignDataDefinition.getFDPredicates().get(0));
            } else {
                this.identifierMapper.add(new FromForeignDataDefinition.NodePredicate(identifier));
            }
        }
        this.logger.debug("exitFromForeignData");
    }

    @Override
    public void exitContainExpressionBool(AqlParser.ContainExpressionBoolContext containExpressionBoolContext) {
        if (containExpressionBoolContext.OPEN_PAR() != null && containExpressionBoolContext.CLOSE_PAR() != null) {
            ArrayList<Object> objects = new ArrayList<Object>();
            for (ParseTree token : containExpressionBoolContext.children) {
                if (token.getText().matches("\\(|\\)")) {
                    objects.add(token.getText());
                    continue;
                }
                if (!(token instanceof AqlParser.ContainsExpressionContext)) continue;
                AqlParser.ContainsExpressionContext containsExpressionContext = (AqlParser.ContainsExpressionContext)token;
                objects.add(this.containPropositions.get(containsExpressionContext.getText()));
            }
            this.containPropositions.put(containExpressionBoolContext.getText(), new ComplexContainsCheck(containExpressionBoolContext.getText(), objects));
        } else if (!new ContainsExpressions(containExpressionBoolContext).isExplicitContainsClause()) {
            SimpleChainedCheck simpleChainedCheck = new SimpleChainedCheck(new ContainsExpressions(containExpressionBoolContext).containedItemLabel(false), this.containmentSetMap.get(containExpressionBoolContext.getText()));
            this.containPropositions.put(containExpressionBoolContext.getText(), simpleChainedCheck);
        }
    }

    @Override
    public void exitContainsExpression(AqlParser.ContainsExpressionContext containsExpressionContext) {
        ContainsProposition proposition = new ContainsProposition(containsExpressionContext, this.identifierMapper);
        if (!proposition.isSingleChain()) {
            List<Object> developedExpression = proposition.develop(this.containPropositions);
            if (developedExpression.isEmpty()) {
                throw new IllegalStateException("Could not develop:" + containsExpressionContext.getText());
            }
            this.containPropositions.put(containsExpressionContext.getText(), new ComplexContainsCheck(containsExpressionContext.getText(), developedExpression));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void exitSimpleClassExpr(AqlParser.SimpleClassExprContext simpleClassExprContext) {
        this.logger.debug("from exitSimpleClassExpr: ENTER");
        if (!simpleClassExprContext.IDENTIFIER().isEmpty()) {
            String className = simpleClassExprContext.IDENTIFIER(0).getSymbol().getText().toUpperCase();
            String symbol = new SimpleClassExpressionIdentifier(simpleClassExprContext).resolve();
            Containment containment = new Containment(className, symbol, "");
            this.identifierMapper.add(containment);
            this.containmentSetMap.put(simpleClassExprContext.getText(), new ContainsProposition(simpleClassExprContext, this.identifierMapper).containmentSet(containment));
            return;
        } else {
            String archetypeId;
            String symbol;
            if (!(simpleClassExprContext.getChild(0) instanceof AqlParser.ArchetypedClassExprContext)) return;
            AqlParser.ArchetypedClassExprContext archetypedClassExprContext = (AqlParser.ArchetypedClassExprContext)simpleClassExprContext.getChild(0);
            String className = archetypedClassExprContext.IDENTIFIER(0).getSymbol().getText().toUpperCase();
            String string = symbol = archetypedClassExprContext.IDENTIFIER(1) != null ? archetypedClassExprContext.IDENTIFIER(1).getSymbol().getText() : archetypedClassExprContext.getText().toUpperCase();
            if (archetypedClassExprContext.ARCHETYPEID() == null && archetypedClassExprContext.exception instanceof InputMismatchException) {
                InputMismatchException inputMismatchException = (InputMismatchException)archetypedClassExprContext.exception;
                if (!(inputMismatchException.getOffendingToken() instanceof CommonToken)) throw new IllegalArgumentException("AQL Parse exception: " + simpleClassExprContext.getText());
                archetypeId = new RecoverArchetypeId().recoverInvalidArchetypeId((RuleContext)archetypedClassExprContext, (CommonToken)inputMismatchException.getOffendingToken());
            } else {
                archetypeId = archetypedClassExprContext.ARCHETYPEID().getText();
            }
            Containment containment = new Containment(className, symbol, archetypeId);
            this.identifierMapper.add(containment);
            this.containmentSetMap.put(archetypedClassExprContext.getText(), new ContainsProposition(archetypedClassExprContext, this.identifierMapper).containmentSet(containment));
        }
    }

    public IdentifierMapper getIdentifierMapper() {
        return this.identifierMapper;
    }

    public ContainPropositions containPropositions() {
        return this.containPropositions;
    }
}

