/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.containment;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.ehrbase.aql.containment.Containment;
import org.ehrbase.aql.definition.FromEhrDefinition;
import org.ehrbase.aql.definition.FromForeignDataDefinition;
import org.ehrbase.aql.sql.queryimpl.JsonbEntryQuery;

public class IdentifierMapper {
    public static final String SYMBOL_ALREADY_EXISTS = "Symbol already exists:";
    public static final String COMPOSITION = "COMPOSITION";
    private Map<String, Mapper> mapper = new HashMap<String, Mapper>();

    public void add(Object definition) {
        if (definition instanceof Containment) {
            Containment containment = (Containment)definition;
            if (this.mapper.containsKey(containment.getSymbol())) {
                throw new IllegalArgumentException(SYMBOL_ALREADY_EXISTS + containment.getSymbol());
            }
            Mapper def = new Mapper(containment);
            this.mapper.put(containment.getSymbol(), def);
        } else if (definition instanceof FromEhrDefinition.EhrPredicate) {
            FromEhrDefinition.EhrPredicate ehrPredicate = (FromEhrDefinition.EhrPredicate)definition;
            if (this.mapper.containsKey(ehrPredicate.getField())) {
                throw new IllegalArgumentException(SYMBOL_ALREADY_EXISTS + ehrPredicate.getField());
            }
            Mapper def = new Mapper(ehrPredicate);
            this.mapper.put(ehrPredicate.getIdentifier(), def);
        } else if (definition instanceof FromForeignDataDefinition.NodePredicate) {
            FromForeignDataDefinition.NodePredicate nodePredicate = (FromForeignDataDefinition.NodePredicate)definition;
            if (this.mapper.containsKey(nodePredicate.getField())) {
                throw new IllegalArgumentException(SYMBOL_ALREADY_EXISTS + nodePredicate.getField());
            }
            Mapper def = new Mapper(nodePredicate);
            this.mapper.put(nodePredicate.getIdentifier(), def);
        }
    }

    public Object getContainer(String symbol) {
        Mapper mapped = this.mapper.get(symbol);
        if (mapped == null) {
            return null;
        }
        return mapped.getContainer();
    }

    public Containment getRootContainment() {
        for (Map.Entry<String, Mapper> containment : this.mapper.entrySet()) {
            if (!(containment.getValue().getContainer() instanceof Containment) || !((Containment)containment.getValue().getContainer()).getClassName().equals(COMPOSITION)) continue;
            return (Containment)containment.getValue().getContainer();
        }
        return new Containment(COMPOSITION, "", "");
    }

    public FromEhrDefinition.EhrPredicate getEhrContainer() {
        for (Map.Entry<String, Mapper> containment : this.mapper.entrySet()) {
            if (!(containment.getValue().getContainer() instanceof FromEhrDefinition.EhrPredicate) || ((FromEhrDefinition.EhrPredicate)containment.getValue().getContainer()).isVoid()) continue;
            return (FromEhrDefinition.EhrPredicate)containment.getValue().getContainer();
        }
        return null;
    }

    public boolean hasPathExpression() {
        for (Map.Entry<String, Mapper> containment : this.mapper.entrySet()) {
            if (containment.getValue().getQueryStrategy() == null || !containment.getValue().getQueryStrategy().equals(JsonbEntryQuery.class)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEhrContainer() {
        for (Map.Entry<String, Mapper> containment : this.mapper.entrySet()) {
            if (!(containment.getValue().getContainer() instanceof FromEhrDefinition.EhrPredicate)) continue;
            return true;
        }
        return false;
    }

    public Class getQueryStrategy(String symbol) {
        Mapper mapped = this.mapper.get(symbol);
        if (mapped == null) {
            return null;
        }
        return mapped.getQueryStrategy();
    }

    public Set<String> getPath(String template, String symbol) {
        Mapper definition = this.mapper.get(symbol);
        if (definition == null) {
            throw new IllegalArgumentException("Could not resolve identifier:" + symbol);
        }
        Object containment = definition.getContainer();
        if (containment instanceof Containment) {
            return ((Containment)containment).getPath(template);
        }
        return Collections.emptySet();
    }

    public void setPath(String template, String symbol, Set<String> path) {
        Mapper definition = this.mapper.get(symbol);
        Object containment = definition.getContainer();
        if (containment instanceof Containment) {
            ((Containment)containment).setPath(template, path);
        }
    }

    public void setQueryStrategy(String symbol, Class queryImplementation) {
        Mapper definition = this.mapper.get(symbol);
        definition.setQueryStrategy(queryImplementation);
    }

    public String getArchetypeId(String symbol) {
        Mapper definition = this.mapper.get(symbol);
        Object containment = definition.getContainer();
        if (containment instanceof Containment) {
            return ((Containment)containment).getArchetypeId();
        }
        return null;
    }

    public String getClassName(String symbol) {
        Mapper definition = this.mapper.get(symbol);
        if (definition == null) {
            throw new IllegalArgumentException("Identifier is not defined in FROM/CONTAIN clause:" + symbol);
        }
        Object containment = definition.getContainer();
        if (containment instanceof Containment) {
            return ((Containment)containment).getClassName();
        }
        if (containment instanceof FromEhrDefinition.EhrPredicate) {
            return "EHR";
        }
        return null;
    }

    public Set<String> identifiers() {
        return this.mapper.keySet();
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Mapper> objectEntry : this.mapper.entrySet()) {
            sb.append(objectEntry.getKey() + "::" + objectEntry.getValue().toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean requiresTemplateWhereClause() {
        boolean resolveTemplateRequired = false;
        for (Map.Entry<String, Mapper> map : this.mapper.entrySet()) {
            Containment containment;
            Mapper mapper1 = map.getValue();
            if (!(mapper1.getContainer() instanceof Containment) || (containment = (Containment)mapper1.getContainer()).getClassName().equals(COMPOSITION) && containment.getArchetypeId() == null) continue;
            resolveTemplateRequired = true;
            break;
        }
        return resolveTemplateRequired;
    }

    public class Mapper {
        private Class queryStrategy;
        private Object container;

        public Mapper(Object container) {
            this.container = container;
        }

        public Class getQueryStrategy() {
            return this.queryStrategy;
        }

        public Object getContainer() {
            return this.container;
        }

        public void setQueryStrategy(Class queryStrategy) {
            this.queryStrategy = queryStrategy;
        }

        public void setContainer(Object container) {
            this.container = container;
        }
    }
}

