/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.definition;

import java.util.ArrayList;
import java.util.List;
import org.ehrbase.aql.definition.I_FromEntityDefinition;

public class FromForeignDataDefinition
implements I_FromEntityDefinition {
    private boolean isEHR = false;
    private String identifier;
    private FDType fdType;
    private List<NodePredicate> fromNodePredicates = new ArrayList<NodePredicate>();

    public FromForeignDataDefinition(String type) {
        this.fdType = FDType.valueOf(type);
    }

    @Override
    public void add(String identifier, String value, String operator) {
        this.fromNodePredicates.add(new NodePredicate(identifier, value, operator));
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (NodePredicate predicate : this.fromNodePredicates) {
            stringBuffer.append(predicate + " ");
        }
        return stringBuffer.toString();
    }

    public List<NodePredicate> getFDPredicates() {
        return this.fromNodePredicates;
    }

    public static class NodePredicate {
        String field;
        String value;
        String identifier;
        String operator;

        public NodePredicate(String field, String value, String operator) {
            this.field = field;
            this.value = value;
            this.operator = operator;
        }

        public NodePredicate(String identifier) {
            this.identifier = identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getField() {
            return this.field;
        }

        public String getValue() {
            return this.value;
        }

        public String getOperator() {
            return this.operator;
        }

        public String toString() {
            return "FD::" + this.getIdentifier() + "::" + this.getIdentifier() + "::" + this.getValue();
        }
    }

    public static enum FDType {
        PERSON,
        AGENT,
        ORGANISATION,
        GROUP;

    }
}

