/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql;

import java.util.Set;
import java.util.TreeSet;
import org.ehrbase.aql.containment.Containment;
import org.ehrbase.aql.containment.IdentifierMapper;
import org.ehrbase.aql.containment.Templates;
import org.ehrbase.service.KnowledgeCacheService;

public class PathResolver {
    private final IdentifierMapper mapper;
    private final KnowledgeCacheService knowledgeCache;

    public PathResolver(KnowledgeCacheService knowledgeCache, IdentifierMapper mapper) {
        this.knowledgeCache = knowledgeCache;
        this.mapper = mapper;
    }

    public Set<String> pathOf(String templateId, String identifier) {
        Set<String> result;
        if (!this.getMapper().hasPathExpression() && this.getMapper().getClassName(identifier).equals("COMPOSITION")) {
            StringBuilder stringBuilder = new StringBuilder();
            Containment containment = (Containment)this.getMapper().getContainer(identifier);
            stringBuilder.append("/composition[");
            stringBuilder.append(containment.getArchetypeId());
            stringBuilder.append("]");
            result = new TreeSet<String>();
            result.add(stringBuilder.toString());
        } else {
            result = this.getMapper().getPath(templateId, identifier);
        }
        return result;
    }

    public String entryRoot(String templateId) {
        Containment root = this.getMapper().getRootContainment();
        String result = null;
        if (!templateId.equals("*") && root != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("/composition[");
            if (root.getArchetypeId().isEmpty()) {
                stringBuilder.append(new Templates(this.knowledgeCache).rootArchetypeNodeId(templateId));
            } else {
                stringBuilder.append(root.getArchetypeId());
            }
            stringBuilder.append("]");
            result = stringBuilder.toString();
        }
        return result;
    }

    public boolean hasPathExpression() {
        return this.getMapper().hasPathExpression();
    }

    public String rootOf(String identifier) {
        return this.getMapper().getArchetypeId(identifier);
    }

    public String classNameOf(String identifier) {
        return this.getMapper().getClassName(identifier);
    }

    public IdentifierMapper getMapper() {
        return this.mapper;
    }
}

