/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ehrbase.aql.compiler.OrderAttribute;
import org.ehrbase.aql.definition.FuncParameter;
import org.ehrbase.aql.definition.FunctionDefinition;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.definition.Variables;
import org.ehrbase.aql.sql.binding.FunctionExpression;
import org.ehrbase.aql.sql.binding.OrderByBinder;
import org.ehrbase.aql.sql.binding.VariableDefinitions;
import org.ehrbase.aql.sql.queryimpl.DefaultColumnId;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.SelectQuery;
import org.jooq.TableLike;
import org.jooq.impl.DSL;

public class SuperQuery {
    private VariableDefinitions variableDefinitions;
    private SelectQuery query;
    private DSLContext context;
    private boolean outputWithJson;

    public SuperQuery(I_DomainAccess domainAccess, VariableDefinitions variableDefinitions, SelectQuery query, boolean containsJson) {
        this.context = domainAccess.getContext();
        this.variableDefinitions = variableDefinitions;
        this.query = query;
        this.outputWithJson = containsJson;
    }

    private List<Field> selectDistinctFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        Iterator<I_VariableDefinition> iterator = this.variableDefinitions.iterator();
        if (!this.variableDefinitions.hasDistinctOperator()) {
            return fields;
        }
        while (iterator.hasNext()) {
            I_VariableDefinition variableDefinition = iterator.next();
            if (variableDefinition instanceof FunctionDefinition) {
                StringBuilder stringBuilder = new StringBuilder();
                for (FuncParameter funcParameter : variableDefinition.getFuncParameters()) {
                    stringBuilder.append(funcParameter.getValue());
                }
                fields.add(DSL.fieldByName((String[])new String[]{stringBuilder.toString()}));
                continue;
            }
            if (variableDefinition.getAlias() == null || variableDefinition.getAlias().isEmpty()) {
                fields.add(DSL.fieldByName((String[])new String[]{DefaultColumnId.value(variableDefinition)}));
                continue;
            }
            fields.add(DSL.fieldByName((String[])new String[]{variableDefinition.getAlias()}));
        }
        return fields;
    }

    private SelectQuery selectDistinct(SelectQuery selectQuery) {
        List<Field> fields = this.selectDistinctFields();
        selectQuery.addDistinctOn(fields);
        selectQuery.addFrom((TableLike)this.query);
        return selectQuery;
    }

    private SelectQuery selectAggregate(SelectQuery selectQuery) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<String> skipField = new ArrayList<String>();
        Iterator<I_VariableDefinition> iterator = this.variableDefinitions.iterator();
        boolean distinctRequired = false;
        while (iterator.hasNext()) {
            String alias;
            I_VariableDefinition variableDefinition = iterator.next();
            String string = alias = variableDefinition.getAlias() == null || variableDefinition.getAlias().isEmpty() ? variableDefinition.getPath() : variableDefinition.getAlias();
            if (variableDefinition.isFunction()) {
                skipField.add(alias);
                FunctionExpression functionExpression = new FunctionExpression(this.variableDefinitions, variableDefinition);
                Field field = DSL.field((String)functionExpression.toString());
                skipField.addAll(functionExpression.arguments());
                if (variableDefinition.getAlias() != null) {
                    field = field.as(alias);
                }
                fields.add(field);
                continue;
            }
            if (variableDefinition.isExtension()) continue;
            boolean bl = distinctRequired = distinctRequired || variableDefinition.isDistinct();
            if (skipField.contains(alias)) continue;
            if (variableDefinition.isDistinct()) {
                fields.add(DSL.fieldByName((String[])new String[]{"DISTINCT " + alias}));
                continue;
            }
            fields.add(DSL.fieldByName((String[])new String[]{alias}));
        }
        selectQuery.addSelect(fields);
        selectQuery.addFrom((TableLike)this.query);
        this.outputWithJson = false;
        return selectQuery;
    }

    public SelectQuery selectOrderBy(List<OrderAttribute> orderAttributes) {
        SelectQuery selectQuery = this.context.selectQuery();
        selectQuery.addFrom((TableLike)this.query);
        selectQuery = this.setOrderBy(orderAttributes, selectQuery);
        return selectQuery;
    }

    public SelectQuery setOrderBy(List<OrderAttribute> orderAttributes, SelectQuery selectQuery) {
        return new OrderByBinder(this.variableDefinitions, orderAttributes, (SelectQuery<Record>)selectQuery).bind();
    }

    public SelectQuery select() {
        SelectQuery selectQuery = this.context.selectQuery();
        if (new Variables(this.variableDefinitions).hasDefinedFunction()) {
            selectQuery = this.selectAggregate(selectQuery);
        } else if (new Variables(this.variableDefinitions).hasDefinedDistinct()) {
            selectQuery = this.selectDistinct(selectQuery);
        }
        return selectQuery;
    }

    public boolean isOutputWithJson() {
        return this.outputWithJson;
    }
}

