/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.queryimpl.attribute.composition;

import org.ehrbase.aql.sql.binding.JoinBinder;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.ehrbase.aql.sql.queryimpl.attribute.AttributePath;
import org.ehrbase.aql.sql.queryimpl.attribute.AttributeResolver;
import org.ehrbase.aql.sql.queryimpl.attribute.FieldResolutionContext;
import org.ehrbase.aql.sql.queryimpl.attribute.JoinSetup;
import org.ehrbase.aql.sql.queryimpl.attribute.composition.CompositionUidValue;
import org.ehrbase.aql.sql.queryimpl.attribute.composition.FullCompositionJson;
import org.ehrbase.aql.sql.queryimpl.attribute.composition.SimpleCompositionAttribute;
import org.ehrbase.aql.sql.queryimpl.attribute.concept.ConceptResolver;
import org.ehrbase.aql.sql.queryimpl.value_field.GenericJsonField;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.udt.records.DvCodedTextRecord;
import org.jooq.Field;

public class CompositionResolver
extends AttributeResolver {
    public static final String FEEDER_AUDIT = "feeder_audit";
    public static final String FEEDER_SYSTEM_IDS = "feeder_system_item_ids";

    public CompositionResolver(FieldResolutionContext fieldResolutionContext, JoinSetup joinSetup) {
        super(fieldResolutionContext, joinSetup);
        joinSetup.setJoinComposition(true);
    }

    public Field<?> sqlField(String path) {
        if (path == null || path.isEmpty()) {
            return new FullCompositionJson(this.fieldResolutionContext, this.joinSetup).sqlField();
        }
        if (path.startsWith("category")) {
            return new ConceptResolver(this.fieldResolutionContext, this.joinSetup).forTableField(Tables.ENTRY.CATEGORY).sqlField(new AttributePath("category").redux(path));
        }
        if (path.startsWith(FEEDER_AUDIT)) {
            Field retField;
            if (path.contains(FEEDER_SYSTEM_IDS) && !path.endsWith(FEEDER_SYSTEM_IDS)) {
                path = path.substring(path.indexOf(FEEDER_SYSTEM_IDS) + FEEDER_SYSTEM_IDS.length() + 1);
                this.fieldResolutionContext.setUsingSetReturningFunction(true);
                retField = new GenericJsonField(this.fieldResolutionContext, this.joinSetup).forJsonPath("feeder_system_item_ids/$AQL_NODE_ITERATIVE$/" + path).feederAudit(JoinBinder.compositionRecordTable.field(FEEDER_AUDIT));
            } else {
                retField = new GenericJsonField(this.fieldResolutionContext, this.joinSetup).forJsonPath(FEEDER_AUDIT, path).feederAudit(JoinBinder.compositionRecordTable.field(FEEDER_AUDIT));
            }
            String regexpTerminalValues = ".*(id|issuer|assigner|type|formalism|system_id|name|namespace|value)$";
            if (path.matches(regexpTerminalValues)) {
                this.fieldResolutionContext.setJsonDatablock(false);
            }
            return retField;
        }
        switch (path) {
            case "uid": {
                return new FullCompositionJson(this.fieldResolutionContext, this.joinSetup).forJsonPath(new String[]{"uid", ""}).sqlField();
            }
            case "uid/value": {
                if (this.fieldResolutionContext.getClause().equals((Object)IQueryImpl.Clause.WHERE)) {
                    return new CompositionUidValue(this.fieldResolutionContext, this.joinSetup).forTableField(NULL_FIELD).sqlField();
                }
                return new FullCompositionJson(this.fieldResolutionContext, this.joinSetup).forJsonPath(new String[]{"uid", "value"}).sqlField();
            }
            case "name": {
                return new FullCompositionJson(this.fieldResolutionContext, this.joinSetup).forJsonPath(new String[]{"name", ""}).sqlField();
            }
            case "name/value": {
                return new GenericJsonField(this.fieldResolutionContext, this.joinSetup).forJsonPath(new String[]{"value", ""}).dvCodedText((Field<DvCodedTextRecord>)Tables.ENTRY.NAME);
            }
            case "archetype_node_id": {
                return new SimpleCompositionAttribute(this.fieldResolutionContext, this.joinSetup).forTableField(Tables.ENTRY.ARCHETYPE_ID).sqlField();
            }
            case "template_id": {
                return new SimpleCompositionAttribute(this.fieldResolutionContext, this.joinSetup).forTableField(Tables.ENTRY.TEMPLATE_ID).sqlField();
            }
            case "archetype_details/template_id/value": {
                return new SimpleCompositionAttribute(this.fieldResolutionContext, this.joinSetup).forTableField(Tables.ENTRY.TEMPLATE_ID).sqlField();
            }
        }
        return new FullCompositionJson(this.fieldResolutionContext, this.joinSetup).forJsonPath(path).sqlField();
    }
}

