/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq.party;

import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.util.List;
import java.util.UUID;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.jooq.party.PartyIdentifiers;
import org.ehrbase.dao.access.jooq.party.PartyRefValue;
import org.ehrbase.dao.access.jooq.party.PersistedObjectId;
import org.ehrbase.dao.access.jooq.party.PersistedParty;
import org.ehrbase.dao.access.jooq.party.PersistedPartyRef;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.PartyType;
import org.ehrbase.jooq.pg.tables.records.PartyIdentifiedRecord;
import org.jooq.Field;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;

class PersistedPartyIdentified
extends PersistedParty {
    PersistedPartyIdentified(I_DomainAccess domainAccess) {
        super(domainAccess);
    }

    @Override
    public PartyProxy render(PartyIdentifiedRecord partyIdentifiedRecord) {
        PartyRef partyRef = null;
        if (partyIdentifiedRecord.getPartyRefType() != null) {
            ObjectId objectID = new PersistedObjectId().fromDB(partyIdentifiedRecord);
            partyRef = new PartyRef(objectID, partyIdentifiedRecord.getPartyRefNamespace(), partyIdentifiedRecord.getPartyRefType());
        }
        List<DvIdentifier> identifierList = new PartyIdentifiers(this.domainAccess).retrieve(partyIdentifiedRecord);
        PartyIdentified partyIdentified = new PartyIdentified(partyRef, partyIdentifiedRecord.getName(), identifierList.isEmpty() ? null : identifierList);
        return partyIdentified;
    }

    @Override
    public UUID store(PartyProxy partyProxy) {
        PartyRefValue partyRefValue = new PartyRefValue(partyProxy).attributes();
        UUID partyIdentifiedUuid = ((PartyIdentifiedRecord)this.domainAccess.getContext().insertInto((Table)Tables.PARTY_IDENTIFIED, (Field)Tables.PARTY_IDENTIFIED.NAME, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_NAMESPACE, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_VALUE, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_SCHEME, (Field)Tables.PARTY_IDENTIFIED.PARTY_REF_TYPE, (Field)Tables.PARTY_IDENTIFIED.PARTY_TYPE, (Field)Tables.PARTY_IDENTIFIED.OBJECT_ID_TYPE).values((Object)((PartyIdentified)partyProxy).getName(), (Object)partyRefValue.getNamespace(), (Object)partyRefValue.getValue(), (Object)partyRefValue.getScheme(), (Object)partyRefValue.getType(), (Object)PartyType.party_identified, (Object)partyRefValue.getObjectIdType()).returning(new SelectFieldOrAsterisk[]{Tables.PARTY_IDENTIFIED.ID}).fetchOne()).getId();
        new PartyIdentifiers(this.domainAccess).store((PartyIdentified)partyProxy, partyIdentifiedUuid);
        return partyIdentifiedUuid;
    }

    @Override
    public UUID findInDB(PartyProxy partyProxy) {
        PartyIdentifiedRecord rec;
        UUID uuid = new PersistedPartyRef(this.domainAccess).findInDB(partyProxy.getExternalRef());
        if (uuid == null && (rec = (PartyIdentifiedRecord)this.domainAccess.getContext().fetchAny((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.NAME.eq((Object)((PartyIdentified)partyProxy).getName()).and(Tables.PARTY_IDENTIFIED.PARTY_TYPE.eq((Object)PartyType.party_identified)))) != null) {
            uuid = rec.getId();
            if (!new PartyIdentifiers(this.domainAccess).compare(rec, (List<DvIdentifier>)((PartyIdentified)partyProxy).getIdentifiers())) {
                uuid = null;
            }
        }
        return uuid;
    }
}

