/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq.party;

import com.nedap.archie.rm.datavalues.DvIdentifier;
import com.nedap.archie.rm.generic.PartyIdentified;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.support.identification.GenericId;
import com.nedap.archie.rm.support.identification.ObjectId;
import com.nedap.archie.rm.support.identification.PartyRef;
import java.util.List;
import java.util.UUID;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.jooq.party.PersistedPartyIdentified;
import org.ehrbase.dao.access.jooq.party.PersistedPartyRelated;
import org.ehrbase.dao.access.jooq.party.PersistedPartySelf;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.PartyIdentifiedRecord;
import org.ehrbase.util.PartyUtils;
import org.jooq.Table;

public class PersistedPartyProxy {
    I_DomainAccess domainAccess;

    public PersistedPartyProxy(I_DomainAccess domainAccess) {
        this.domainAccess = domainAccess;
    }

    public UUID create(PartyProxy partyProxy) {
        if (PartyUtils.isPartySelf(partyProxy)) {
            return new PersistedPartySelf(this.domainAccess).store(partyProxy);
        }
        if (PartyUtils.isPartyRelated(partyProxy)) {
            return new PersistedPartyRelated(this.domainAccess).store(partyProxy);
        }
        if (PartyUtils.isPartyIdentified(partyProxy)) {
            return new PersistedPartyIdentified(this.domainAccess).store(partyProxy);
        }
        throw new InternalServerException("Unhandled Party type detected:" + partyProxy.getClass().getSimpleName());
    }

    public PartyProxy retrieve(UUID id) {
        PartyProxy partyProxy;
        if (!this.domainAccess.getContext().fetchExists((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.ID.eq((Object)id))) {
            partyProxy = null;
        } else {
            PartyIdentifiedRecord identifiedRecord = (PartyIdentifiedRecord)this.domainAccess.getContext().fetchOne((Table)Tables.PARTY_IDENTIFIED, Tables.PARTY_IDENTIFIED.ID.eq((Object)id));
            switch (identifiedRecord.getPartyType()) {
                case party_self: {
                    partyProxy = new PersistedPartySelf(this.domainAccess).render(identifiedRecord);
                    break;
                }
                case party_identified: {
                    partyProxy = new PersistedPartyIdentified(this.domainAccess).render(identifiedRecord);
                    break;
                }
                case party_related: {
                    partyProxy = new PersistedPartyRelated(this.domainAccess).render(identifiedRecord);
                    break;
                }
                default: {
                    throw new InternalServerException("Inconsistent Party type detected:" + identifiedRecord.getPartyRefType());
                }
            }
        }
        return partyProxy;
    }

    public UUID getOrCreate(PartyProxy partyProxy) {
        if (PartyUtils.isPartySelf(partyProxy)) {
            return new PersistedPartySelf(this.domainAccess).getOrCreate(partyProxy);
        }
        if (PartyUtils.isPartyRelated(partyProxy)) {
            return new PersistedPartyRelated(this.domainAccess).getOrCreate(partyProxy);
        }
        if (PartyUtils.isPartyIdentified(partyProxy)) {
            return new PersistedPartyIdentified(this.domainAccess).getOrCreate(partyProxy);
        }
        throw new InternalServerException("Unhandled Party type detected:" + partyProxy.getClass().getSimpleName());
    }

    public UUID getOrCreate(String name, String code, String scheme, String namespace, String type, List<DvIdentifier> identifiers) {
        if (identifiers == null || identifiers.isEmpty()) {
            throw new IllegalArgumentException("Can't create PartyIdentified with invalid list of identifiers.");
        }
        identifiers.forEach(dv -> {
            if (!this.isValidDvIdentifier((DvIdentifier)dv)) {
                throw new IllegalArgumentException("Can't create PartyIdentified with an invalid identifier.");
            }
        });
        PartyIdentified partyIdentified = new PartyIdentified(new PartyRef((ObjectId)new GenericId(code, scheme), namespace, type), name, identifiers);
        return this.getOrCreate((PartyProxy)partyIdentified);
    }

    private boolean isValidDvIdentifier(DvIdentifier identifier) {
        return identifier.getId() != null && !identifier.getId().isBlank();
    }
}

