/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.exception.DataAccessException;

public class AsyncSqlQuery
implements Supplier<Map<String, Object>> {
    I_DomainAccess domainAccess;
    String queryString;
    ExecutorService executorService;

    public AsyncSqlQuery(I_DomainAccess domainAccess, String queryString) {
        this.domainAccess = domainAccess;
        this.queryString = queryString;
    }

    public Result<Record> fetchQueryResults() {
        try {
            Result records = this.domainAccess.getContext().fetch(this.queryString);
            return records;
        }
        catch (DataAccessException e) {
            String message = e.getCause().getMessage();
            throw new IllegalArgumentException("SQL exception:" + message.replaceAll("\n", ","));
        }
    }

    public Map<String, Object> toJson(Result<Record> records) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("executedSQL", this.queryString);
        ArrayList resultList = new ArrayList();
        for (Record record : records) {
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            for (Field field : records.fields()) {
                fieldMap.put(field.getName(), record.getValue(field));
            }
            resultList.add(fieldMap);
        }
        resultMap.put("resultSet", resultList);
        return resultMap;
    }

    @Override
    public Map<String, Object> get() {
        Result<Record> records = null;
        try {
            records = this.fetchQueryResults();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (records != null && !records.isEmpty()) {
            Map<String, Object> resultMap = this.toJson(records);
            return resultMap;
        }
        return new HashMap<String, Object>();
    }

    public Map<String, Object> fetch() throws InternalServerException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        CompletableFuture<Map<String, Object>> fetch = CompletableFuture.supplyAsync(this, executorService);
        try {
            return fetch.get();
        }
        catch (ExecutionException e) {
            throw new InternalServerException("fetching of async SQL query failed", (Exception)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InternalServerException("ThreadDeath", (Exception)e);
        }
    }
}

