/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.support;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TerminologyReader
extends DefaultHandler {
    private InputStream source;
    private Hashtable<String, String> languageTable;
    private Hashtable<Integer, String> primaryRubricTable;
    private Hashtable<String, Hashtable<Integer, String>> conceptTable;
    private Hashtable<Integer, Integer> grouperTable;
    private Hashtable<Integer, Vector<Integer>> groupedConceptTable;
    private Hashtable<String, String> terminologyIdTable;
    private Hashtable<Integer, Vector<String>> territoryTable;

    public TerminologyReader(InputStream source) {
        this.source = source;
    }

    public void read() {
        this.initialiseTables();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(this.source, (DefaultHandler)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initialiseTables() {
        this.languageTable = new Hashtable();
        this.primaryRubricTable = new Hashtable();
        this.conceptTable = new Hashtable();
        this.grouperTable = new Hashtable();
        this.groupedConceptTable = new Hashtable();
        this.terminologyIdTable = new Hashtable();
        this.territoryTable = new Hashtable();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            if (qName.equals("Language")) {
                String code = attributes.getValue("code");
                String description = attributes.getValue("Description");
                if (code != null && description != null) {
                    this.languageTable.put(code, description);
                }
            } else if (qName.equals("PrimaryRubric")) {
                Integer id = Integer.parseInt(attributes.getValue("Id"));
                String language = attributes.getValue("Language");
                if (id != null && language != null) {
                    this.primaryRubricTable.put(id, language);
                }
            } else if (qName.equals("Concept")) {
                String language = attributes.getValue("Language");
                int id = Integer.parseInt(attributes.getValue("ConceptID"));
                String rubric = attributes.getValue("Rubric");
                if (this.conceptTable.containsKey(language)) {
                    Hashtable<Integer, String> rubrics = this.conceptTable.get(language);
                    rubrics.put(id, rubric);
                } else {
                    Hashtable<Integer, String> rubrics = new Hashtable<Integer, String>();
                    rubrics.put(id, rubric);
                    this.conceptTable.put(language, rubrics);
                }
            } else if (qName.equals("Grouper")) {
                Integer id = Integer.parseInt(attributes.getValue("id"));
                Integer conceptID = Integer.parseInt(attributes.getValue("ConceptID"));
                this.grouperTable.put(conceptID, id);
            } else if (qName.equals("GroupedConcept")) {
                Integer grouperID = Integer.parseInt(attributes.getValue("GrouperID"));
                Integer childID = Integer.parseInt(attributes.getValue("ChildID"));
                if (this.groupedConceptTable.containsKey(grouperID)) {
                    Vector<Integer> v = this.groupedConceptTable.get(grouperID);
                    v.add(childID);
                } else {
                    Vector<Integer> v = new Vector<Integer>();
                    v.add(childID);
                    this.groupedConceptTable.put(grouperID, v);
                }
            } else if (qName.equals("TerminologyIdentifiers")) {
                String vsab = attributes.getValue("VSAB");
                String sourceName = attributes.getValue("SourceName");
                this.terminologyIdTable.put(vsab, sourceName);
            } else if (qName.equals("Territory")) {
                Integer territoryId = Integer.parseInt(attributes.getValue("NumericCode"));
                String twoLetter = attributes.getValue("TwoLetter");
                String threeLetter = attributes.getValue("ThreeLetter");
                String text = attributes.getValue("Text");
                Vector<String> vattr = new Vector<String>();
                vattr.add(twoLetter);
                vattr.add(threeLetter);
                vattr.add(text);
                this.territoryTable.put(territoryId, vattr);
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    public Hashtable<String, String> getLanguageTable() {
        return this.languageTable;
    }

    public Hashtable<Integer, String> getPrimaryRubricTable() {
        return this.primaryRubricTable;
    }

    public Hashtable<String, Hashtable<Integer, String>> getConceptTable() {
        return this.conceptTable;
    }

    public Hashtable<Integer, Integer> getGrouperTable() {
        return this.grouperTable;
    }

    public Hashtable<Integer, Vector<Integer>> getGroupedConceptTable() {
        return this.groupedConceptTable;
    }

    public Hashtable<Integer, Vector<String>> getTerritoryTable() {
        return this.territoryTable;
    }

    public Hashtable<String, String> getTerminologyIdTable() {
        return this.terminologyIdTable;
    }
}

