/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.service.TerminologyServer;
import org.ehrbase.dao.access.interfaces.I_OpenehrTerminologyServer;
import org.ehrbase.service.FhirTsProps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class FhirTerminologyServerR4AdaptorImpl
implements I_OpenehrTerminologyServer {
    private static final String FHIR_JSON_MEDIA_TYPE = "application/fhir+json";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final HttpClient httpClient;
    private final FhirTsProps props;

    public FhirTerminologyServerR4AdaptorImpl(HttpClient httpClient, FhirTsProps props) {
        this.httpClient = httpClient;
        this.props = props;
    }

    public List<DvCodedText> expand(String valueSetId) {
        String responseBody;
        try {
            responseBody = this.internalGet(valueSetId);
        }
        catch (IOException e) {
            throw new InternalServerException("An error occurred while expanding ValueSet: " + valueSetId, (Exception)e);
        }
        DocumentContext jsonContext = JsonPath.parse((String)responseBody);
        List codeList = (List)jsonContext.read(this.props.getCodePath().replace("\\", ""), new Predicate[0]);
        List systemList = (List)jsonContext.read(this.props.getSystemPath(), new Predicate[0]);
        List displayList = (List)jsonContext.read(this.props.getDisplayPath(), new Predicate[0]);
        ArrayList<DvCodedText> expansionList = new ArrayList<DvCodedText>();
        for (int i = 0; i < codeList.size(); ++i) {
            TerminologyId termId = new TerminologyId((String)systemList.get(i));
            CodePhrase codePhrase = new CodePhrase(termId, (String)codeList.get(i));
            DvCodedText codedText = new DvCodedText((String)displayList.get(i), codePhrase);
            expansionList.add(codedText);
        }
        return expansionList;
    }

    public List<DvCodedText> expandWithParameters(String valueSetId, String ... operationParams) {
        String responseBody;
        Object urlTsServer = this.props.getTsUrl();
        urlTsServer = (String)urlTsServer + "ValueSet/$" + operationParams[0] + "?url=" + valueSetId;
        try {
            responseBody = this.internalGet((String)urlTsServer);
        }
        catch (IOException e) {
            throw new InternalServerException("An error occurred while expanding ValueSet " + valueSetId, (Exception)e);
        }
        DocumentContext jsonContext = JsonPath.parse((String)responseBody);
        List codeList = (List)jsonContext.read(this.props.getCodePath().replace("\\", ""), new Predicate[0]);
        List systemList = (List)jsonContext.read(this.props.getSystemPath(), new Predicate[0]);
        List displayList = (List)jsonContext.read(this.props.getDisplayPath(), new Predicate[0]);
        ArrayList<DvCodedText> expansionList = new ArrayList<DvCodedText>();
        for (int i = 0; i < codeList.size(); ++i) {
            TerminologyId termId = new TerminologyId((String)systemList.get(i));
            CodePhrase codePhrase = new CodePhrase(termId, (String)codeList.get(i));
            DvCodedText codedText = new DvCodedText((String)displayList.get(i), codePhrase);
            expansionList.add(codedText);
        }
        return expansionList;
    }

    public DvCodedText lookUp(String conceptId) {
        return null;
    }

    public Boolean validate(DvCodedText concept, String valueSetId) {
        this.logger.debug("inside the validate method of R4 implementation");
        return false;
    }

    public TerminologyServer.SubsumptionResult subsumes(DvCodedText conceptA, DvCodedText conceptB) {
        return null;
    }

    public Boolean validate(String ... operationParams) {
        String response;
        Object urlTsServer = this.props.getTsUrl();
        urlTsServer = (String)urlTsServer + "ValueSet/$validate-code?" + operationParams[0];
        try {
            response = this.internalGet((String)urlTsServer);
        }
        catch (IOException e) {
            throw new InternalServerException("An error occurred while validating the code: " + operationParams[0], (Exception)e);
        }
        DocumentContext jsonContext = JsonPath.parse((String)response);
        JsonPath jsonPath = JsonPath.compile((String)this.props.getValidationResultPath(), (Predicate[])new Predicate[0]);
        List result = (List)jsonContext.read(jsonPath);
        return !result.isEmpty() && (Boolean)result.get(0) != false;
    }

    private String internalGet(String url) throws IOException {
        HttpGet request = new HttpGet(url);
        request.setHeader("Accept", FHIR_JSON_MEDIA_TYPE);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new InternalServerException("Error response received from FHIR terminology server. HTTP status: " + statusCode + ". Body: " + responseBody);
        }
        return responseBody;
    }
}

