/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.datatypes.CodePhrase;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.TermMapping;
import com.nedap.archie.rm.support.identification.TerminologyId;
import java.util.ArrayList;
import java.util.List;

public class PersistentTermMapping {
    private TermMapping rmTermMapping;

    public PersistentTermMapping(TermMapping rmTermMapping) {
        this.rmTermMapping = rmTermMapping;
    }

    public PersistentTermMapping() {
        this.rmTermMapping = null;
    }

    public String encodeAsString() {
        if (this.rmTermMapping == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rmTermMapping.getMatch()).append("|");
        stringBuilder.append(this.rmTermMapping.getPurpose().getValue()).append("|");
        stringBuilder.append(this.rmTermMapping.getPurpose().getDefiningCode().getTerminologyId().getValue()).append("|");
        stringBuilder.append(this.rmTermMapping.getPurpose().getDefiningCode().getCodeString()).append("|");
        stringBuilder.append(this.rmTermMapping.getTarget().getTerminologyId().getValue()).append("|");
        stringBuilder.append(this.rmTermMapping.getTarget().getCodeString());
        return stringBuilder.toString();
    }

    public TermMapping decode(String termMappingString) {
        String[] attributes = termMappingString.split("\\|");
        return new TermMapping(new CodePhrase(new TerminologyId(attributes[4]), attributes[5]), Character.valueOf(attributes[0].charAt(0)), new DvCodedText(attributes[1], new CodePhrase(new TerminologyId(attributes[2]), attributes[3])));
    }

    public String[] termMappingRepresentation(List<TermMapping> termMappings) {
        ArrayList<String> dvCodedTextTermMappingRecords = new ArrayList<String>();
        for (TermMapping termMapping : termMappings) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(new PersistentTermMapping(termMapping).encodeAsString());
            dvCodedTextTermMappingRecords.add(stringBuilder.toString());
        }
        return dvCodedTextTermMappingRecords.toArray(new String[0]);
    }
}

