/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.service;

import com.nedap.archie.rm.composition.Composition;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rminfo.ArchieRMInfoLookup;
import com.nedap.archie.rminfo.ModelInfoLookup;
import com.nedap.archie.rmobjectvalidator.RMObjectValidationMessage;
import com.nedap.archie.rmobjectvalidator.RMObjectValidator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.UnprocessableEntityException;
import org.ehrbase.api.exception.ValidationException;
import org.ehrbase.api.service.ValidationService;
import org.ehrbase.ehr.knowledge.I_KnowledgeCache;
import org.ehrbase.terminology.openehr.TerminologyService;
import org.ehrbase.validation.Validator;
import org.ehrbase.validation.constraints.terminology.ExternalTerminologyValidationSupport;
import org.ehrbase.validation.terminology.ItemStructureVisitor;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Service;

@Service
public class ValidationServiceImp
implements ValidationService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Pattern NAMESPACE_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9-_:/&+?]*");
    private static final RMObjectValidator RM_OBJECT_VALIDATOR = new RMObjectValidator((ModelInfoLookup)ArchieRMInfoLookup.getInstance(), s -> null);
    private final I_KnowledgeCache knowledgeCache;
    private final TerminologyService terminologyService;
    private final Cache validatorCache;
    private ExternalTerminologyValidationSupport externalTerminologyValidator;

    @Autowired
    public ValidationServiceImp(CacheManager cacheManager, I_KnowledgeCache knowledgeCache, TerminologyService terminologyService, ServerConfig serverConfig) {
        this.validatorCache = cacheManager.getCache("validatorCache");
        this.knowledgeCache = knowledgeCache;
        this.terminologyService = terminologyService;
        if (serverConfig.isDisableStrictValidation()) {
            this.logger.warn("Disabling strict invariant validation. Caution is advised.");
            RM_OBJECT_VALIDATOR.setRunInvariantChecks(false);
        }
    }

    public void check(UUID templateUUID, Composition composition) throws Exception {
        Validator validator = (Validator)this.validatorCache.get((Object)templateUUID, Validator.class);
        if (validator == null) {
            Optional<OPERATIONALTEMPLATE> operationaltemplate = this.knowledgeCache.retrieveOperationalTemplate(templateUUID);
            if (operationaltemplate.isEmpty()) {
                throw new IllegalArgumentException("Not found template uuid:" + templateUUID);
            }
            validator = new Validator(operationaltemplate.get());
            this.validatorCache.put((Object)templateUUID, (Object)validator);
        }
        validator.setExternalTerminologyValidator(this.externalTerminologyValidator);
        validator.check(composition);
        ItemStructureVisitor itemStructureVisitor = new ItemStructureVisitor(this.terminologyService);
        itemStructureVisitor.validate(composition);
    }

    public void check(String templateID, Composition composition) throws Exception {
        Optional<OPERATIONALTEMPLATE> operationaltemplate = this.knowledgeCache.retrieveOperationalTemplate(templateID);
        if (operationaltemplate.isEmpty()) {
            throw new UnprocessableEntityException("Not found template id: " + templateID);
        }
        this.check(UUID.fromString(operationaltemplate.get().getUid().getValue()), composition);
    }

    public void check(Composition composition) throws Exception {
        if (composition.getName() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: name");
        }
        if (composition.getArchetypeNodeId() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: archetype_node_id");
        }
        if (composition.getLanguage() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: language");
        }
        if (composition.getCategory() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: category");
        }
        if (composition.getComposer() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: composer");
        }
        if (composition.getArchetypeDetails() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: archetype details");
        }
        if (composition.getArchetypeDetails().getTemplateId() == null) {
            throw new IllegalArgumentException("Composition missing mandatory attribute: archetype details/template_id");
        }
        List rmObjectValidationMessages = RM_OBJECT_VALIDATOR.validate((Object)composition);
        if (!rmObjectValidationMessages.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (RMObjectValidationMessage rmObjectValidationMessage : rmObjectValidationMessages) {
                stringBuilder.append(rmObjectValidationMessage.toString());
                stringBuilder.append("\n");
            }
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        this.check(composition.getArchetypeDetails().getTemplateId().getValue(), composition);
    }

    public void check(EhrStatus ehrStatus) {
        if (ehrStatus == null) {
            return;
        }
        List rmObjectValidationMessages = RM_OBJECT_VALIDATOR.validate((Object)ehrStatus);
        if (!rmObjectValidationMessages.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (RMObjectValidationMessage rmObjectValidationMessage : rmObjectValidationMessages) {
                stringBuilder.append(rmObjectValidationMessage.toString());
                stringBuilder.append("\n");
            }
            throw new ValidationException(stringBuilder.toString());
        }
        if (ehrStatus.getSubject() == null) {
            throw new ValidationException("subject is required");
        }
        if (ehrStatus.getSubject().getExternalRef() != null) {
            if (ehrStatus.getSubject().getExternalRef().getId() == null || ehrStatus.getSubject().getExternalRef().getId().getValue().isEmpty()) {
                throw new ValidationException("ExternalRef ID is required");
            }
            if (ehrStatus.getSubject().getExternalRef().getNamespace() == null) {
                throw new ValidationException("ExternalRef namespace is required");
            }
            if (!NAMESPACE_PATTERN.matcher(ehrStatus.getSubject().getExternalRef().getNamespace()).matches()) {
                throw new ValidationException("Subject's namespace format invalid");
            }
        }
    }

    public void invalidate() {
        this.validatorCache.invalidate();
    }

    @Autowired(required=false)
    public void setExternalTerminologyValidator(ExternalTerminologyValidationSupport externalTerminologyValidator) {
        this.externalTerminologyValidator = externalTerminologyValidator;
    }
}

