/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.util;

import java.util.Optional;
import java.util.UUID;
import org.openehr.schemas.v1.OBJECTID;
import org.openehr.schemas.v1.OPERATIONALTEMPLATE;

public class TemplateUtils {
    private TemplateUtils() {
    }

    public static String getTemplateId(OPERATIONALTEMPLATE template) {
        if (template == null) {
            throw new IllegalArgumentException("Template must not be null");
        }
        return Optional.ofNullable(template.getTemplateId()).map(OBJECTID::getValue).orElseThrow(() -> new IllegalArgumentException("Template ID must not be null for the given template"));
    }

    public static UUID getUid(OPERATIONALTEMPLATE template) {
        if (template == null) {
            throw new IllegalArgumentException("Template must not be null");
        }
        return Optional.ofNullable(template.getUid()).map(OBJECTID::getValue).map(UUID::fromString).orElseThrow(() -> new IllegalArgumentException("Unique ID must not be null for the given template"));
    }
}

