/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.generic.PartyProxy;
import com.nedap.archie.rm.generic.PartySelf;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.collections.map.MultiValueMap;
import org.ehrbase.api.definitions.ServerConfig;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_EhrAccess;
import org.ehrbase.dao.access.interfaces.I_StatusAccess;
import org.ehrbase.dao.access.interfaces.I_SystemAccess;
import org.ehrbase.dao.access.jooq.AuditDetailsAccess;
import org.ehrbase.dao.access.jooq.ContributionAccess;
import org.ehrbase.dao.access.jooq.StatusAccess;
import org.ehrbase.dao.access.jooq.party.PersistedPartyProxy;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.ContributionDef;
import org.ehrbase.dao.access.util.TransactionTime;
import org.ehrbase.jooq.pg.Routines;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.enums.ContributionDataType;
import org.ehrbase.jooq.pg.tables.records.AdminDeleteEhrFullRecord;
import org.ehrbase.jooq.pg.tables.records.EhrRecord;
import org.ehrbase.jooq.pg.tables.records.IdentifierRecord;
import org.ehrbase.jooq.pg.tables.records.PartyIdentifiedRecord;
import org.ehrbase.jooq.pg.tables.records.StatusHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.StatusRecord;
import org.ehrbase.jooq.pg.udt.records.DvCodedTextRecord;
import org.ehrbase.service.RecordedDvCodedText;
import org.ehrbase.service.RecordedDvText;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhrAccess
extends DataAccess
implements I_EhrAccess {
    private static final Logger log = LoggerFactory.getLogger(EhrAccess.class);
    public static final String JSONB = "::jsonb";
    public static final String EXCEPTION = " exception:";
    public static final String COULD_NOT_RETRIEVE_EHR_FOR_ID = "Could not retrieve EHR for id:";
    public static final String COULD_NOT_RETRIEVE_EHR_FOR_PARTY = "Could not retrieve EHR for party:";
    private EhrRecord ehrRecord;
    private boolean isNew = false;
    private boolean hasStatusChanged = false;
    private ItemStructure otherDetails = null;
    private I_ContributionAccess contributionAccess;
    private I_StatusAccess statusAccess;

    public EhrAccess(DSLContext context, ServerConfig serverConfig, UUID partyId, UUID systemId, UUID directoryId, UUID accessId, UUID ehrId) {
        super(context, null, null, serverConfig);
        this.ehrRecord = (EhrRecord)context.newRecord((Table)Tables.EHR_);
        this.ehrRecord.setId(Objects.requireNonNullElseGet(ehrId, UUID::randomUUID));
        this.statusAccess = new StatusAccess(this, this.ehrRecord.getId());
        this.statusAccess.getStatusRecord().setId(UUID.randomUUID());
        this.statusAccess.getStatusRecord().setIsModifiable(Boolean.valueOf(true));
        this.statusAccess.getStatusRecord().setIsQueryable(Boolean.valueOf(true));
        this.statusAccess.getStatusRecord().setParty(partyId);
        this.statusAccess.getStatusRecord().setEhrId(this.ehrRecord.getId());
        this.ehrRecord.setSystemId(systemId);
        this.ehrRecord.setDirectory(directoryId);
        this.ehrRecord.setAccess(accessId);
        if (this.ehrRecord.getSystemId() == null) {
            this.ehrRecord.setSystemId(I_SystemAccess.createOrRetrieveLocalSystem(this));
        }
        this.isNew = true;
        this.contributionAccess = I_ContributionAccess.getInstance(this, this.ehrRecord.getId());
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
    }

    private EhrAccess(I_DomainAccess domainAccess, UUID ehrId) {
        super(domainAccess);
        this.statusAccess = new StatusAccess(this, ehrId);
        this.contributionAccess = I_ContributionAccess.getInstance(this, ehrId);
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
    }

    public static UUID retrieveInstanceBySubject(I_DomainAccess domainAccess, UUID subjectUuid) {
        Record record;
        DSLContext context = domainAccess.getContext();
        try {
            record = context.select((SelectField)Tables.STATUS.EHR_ID).from((TableLike)Tables.STATUS).where(Tables.STATUS.PARTY.eq((Select)context.select((SelectField)Tables.PARTY_IDENTIFIED.ID).from((TableLike)Tables.PARTY_IDENTIFIED).where(Tables.PARTY_IDENTIFIED.ID.eq((Object)subjectUuid)))).fetchOne();
        }
        catch (Exception e) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_PARTY + subjectUuid + EXCEPTION + e);
            throw new IllegalArgumentException("Could not retrieve  EHR for party:" + subjectUuid + EXCEPTION + e);
        }
        if (record == null || record.size() == 0) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_PARTY + subjectUuid);
            return null;
        }
        return (UUID)record.getValue(0);
    }

    public static UUID retrieveInstanceBySubject(I_DomainAccess domainAccess, String subjectId, String issuerSpace) {
        Record record;
        DSLContext context = domainAccess.getContext();
        IdentifierRecord identifierRecord = (IdentifierRecord)context.fetchOne((Table)Tables.IDENTIFIER, Tables.IDENTIFIER.ID_VALUE.eq((Object)subjectId).and(Tables.IDENTIFIER.ISSUER.eq((Object)issuerSpace)));
        if (identifierRecord == null) {
            throw new IllegalArgumentException("Could not invalidateContent an identified party for code:" + subjectId + " issued by:" + issuerSpace);
        }
        try {
            record = context.select((SelectField)Tables.STATUS.EHR_ID).from((TableLike)Tables.STATUS).where(Tables.STATUS.PARTY.eq((Select)context.select((SelectField)Tables.PARTY_IDENTIFIED.ID).from((TableLike)Tables.PARTY_IDENTIFIED).where(Tables.PARTY_IDENTIFIED.ID.eq((Object)identifierRecord.getParty())))).fetchOne();
        }
        catch (Exception e) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_PARTY + subjectId + EXCEPTION + e);
            throw new IllegalArgumentException(COULD_NOT_RETRIEVE_EHR_FOR_PARTY + subjectId + EXCEPTION + e);
        }
        if (record == null || record.size() == 0) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_PARTY + subjectId);
            return null;
        }
        return (UUID)record.getValue(0);
    }

    public static UUID retrieveInstanceBySubjectExternalRef(I_DomainAccess domainAccess, String subjectId, String issuerSpace) {
        Record record;
        DSLContext context = domainAccess.getContext();
        try {
            record = context.select((SelectField)Tables.STATUS.EHR_ID).from((TableLike)Tables.STATUS).where(Tables.STATUS.PARTY.eq((Select)context.select((SelectField)Tables.PARTY_IDENTIFIED.ID).from((TableLike)Tables.PARTY_IDENTIFIED).where(Tables.PARTY_IDENTIFIED.PARTY_REF_VALUE.eq((Object)subjectId).and(Tables.PARTY_IDENTIFIED.PARTY_REF_NAMESPACE.eq((Object)issuerSpace))))).fetchOne();
        }
        catch (Exception e) {
            log.warn("Could not ehr for party:" + subjectId + EXCEPTION + e);
            throw new IllegalArgumentException(COULD_NOT_RETRIEVE_EHR_FOR_PARTY + subjectId + EXCEPTION + e);
        }
        if (record == null || record.size() == 0) {
            log.warn("Could not retrieve ehr for party:" + subjectId);
            return null;
        }
        return (UUID)record.getValue(0);
    }

    public static I_EhrAccess retrieveInstanceByStatus(I_DomainAccess domainAccess, UUID ehrId, UUID status, Integer version) {
        EhrRecord record;
        if (version < 1) {
            throw new IllegalArgumentException("Version number must be > 0");
        }
        EhrAccess ehrAccess = new EhrAccess(domainAccess, ehrId);
        I_StatusAccess statusAccess = I_StatusAccess.retrieveInstance(domainAccess, status);
        ehrAccess.setStatusAccess(statusAccess);
        Integer versions = domainAccess.getContext().fetchCount((Table)Tables.STATUS_HISTORY, Tables.STATUS_HISTORY.EHR_ID.eq((Object)ehrAccess.getStatusAccess().getStatusRecord().getEhrId())) + 1;
        if (versions > version && !version.equals(versions)) {
            Result result = domainAccess.getContext().selectFrom((Table)Tables.STATUS_HISTORY).where(Tables.STATUS_HISTORY.EHR_ID.eq((Object)ehrId)).orderBy((OrderField)Tables.STATUS_HISTORY.SYS_TRANSACTION.asc()).fetch();
            if (result.isEmpty()) {
                throw new InternalServerException("Error retrieving EHR_STATUS");
            }
            StatusHistoryRecord statusHistoryRecord = (StatusHistoryRecord)result.get(version - 1);
            ehrAccess.getStatusAccess().getStatusRecord().setEhrId(statusHistoryRecord.getEhrId());
            ehrAccess.getStatusAccess().getStatusRecord().setIsQueryable(statusHistoryRecord.getIsQueryable());
            ehrAccess.getStatusAccess().getStatusRecord().setIsModifiable(statusHistoryRecord.getIsModifiable());
            ehrAccess.getStatusAccess().getStatusRecord().setParty(statusHistoryRecord.getParty());
            ehrAccess.getStatusAccess().getStatusRecord().setOtherDetails(statusHistoryRecord.getOtherDetails());
            ehrAccess.getStatusAccess().getStatusRecord().setSysTransaction(statusHistoryRecord.getSysTransaction());
            ehrAccess.getStatusAccess().getStatusRecord().setSysPeriod(statusHistoryRecord.getSysPeriod());
            ehrAccess.getStatusAccess().getStatusRecord().setHasAudit(statusHistoryRecord.getHasAudit());
            ehrAccess.getStatusAccess().getStatusRecord().setAttestationRef(statusHistoryRecord.getAttestationRef());
            ehrAccess.getStatusAccess().getStatusRecord().setInContribution(statusHistoryRecord.getInContribution());
            ehrAccess.getStatusAccess().getStatusRecord().setArchetypeNodeId(statusHistoryRecord.getArchetypeNodeId());
            ehrAccess.getStatusAccess().getStatusRecord().setName(statusHistoryRecord.getName());
        }
        try {
            record = (EhrRecord)domainAccess.getContext().selectFrom((Table)Tables.EHR_).where(Tables.EHR_.ID.eq((Object)ehrAccess.getStatusAccess().getStatusRecord().getEhrId())).fetchOne();
        }
        catch (Exception e) {
            log.warn("Could not retrieveInstanceByNamedSubject ehr for status:" + status + EXCEPTION + e);
            throw new IllegalArgumentException("Could not retrieveInstanceByNamedSubject EHR for status:" + status + EXCEPTION + e);
        }
        if (record.size() == 0) {
            log.warn("Could not retrieveInstanceByNamedSubject ehr for status:" + status);
            return null;
        }
        ehrAccess.ehrRecord = record;
        ehrAccess.isNew = false;
        return ehrAccess;
    }

    public static I_EhrAccess retrieveInstance(I_DomainAccess domainAccess, UUID ehrId) {
        EhrRecord record;
        DSLContext context = domainAccess.getContext();
        EhrAccess ehrAccess = new EhrAccess(domainAccess, ehrId);
        try {
            record = (EhrRecord)context.selectFrom((Table)Tables.EHR_).where(Tables.EHR_.ID.eq((Object)ehrId)).fetchOne();
        }
        catch (Exception e) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_ID + ehrId + EXCEPTION + e);
            throw new IllegalArgumentException(COULD_NOT_RETRIEVE_EHR_FOR_ID + ehrId + EXCEPTION + e);
        }
        if (record == null || record.size() == 0) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_ID + ehrId);
            return null;
        }
        ehrAccess.ehrRecord = record;
        I_StatusAccess statusAccess = I_StatusAccess.retrieveInstanceByEhrId(domainAccess, ehrAccess.ehrRecord.getId());
        ehrAccess.setStatusAccess(statusAccess);
        if (ehrAccess.getStatusAccess().getStatusRecord().getOtherDetails() != null) {
            ehrAccess.otherDetails = ehrAccess.getStatusAccess().getStatusRecord().getOtherDetails();
        }
        ehrAccess.isNew = false;
        ehrAccess.setContributionAccess(I_ContributionAccess.retrieveInstance(domainAccess, ehrAccess.getStatusAccess().getContributionId()));
        return ehrAccess;
    }

    public static Map<String, Object> fetchSubjectIdentifiers(I_DomainAccess domainAccess, UUID ehrId) {
        EhrAccess ehrAccess = (EhrAccess)EhrAccess.retrieveInstance(domainAccess, ehrId);
        DSLContext context = domainAccess.getContext();
        if (ehrAccess == null) {
            throw new IllegalArgumentException("No ehr found for id:" + ehrId);
        }
        MultiValueMap idlist = new MultiValueMap();
        context.selectFrom((Table)Tables.IDENTIFIER).where(Tables.IDENTIFIER.PARTY.eq((Object)EhrAccess.getParty(ehrAccess))).fetch().forEach(arg_0 -> EhrAccess.lambda$fetchSubjectIdentifiers$0((Map)idlist, arg_0));
        context.selectFrom((Table)Tables.PARTY_IDENTIFIED).where(Tables.PARTY_IDENTIFIED.ID.eq((Object)EhrAccess.getParty(ehrAccess))).fetch().forEach(arg_0 -> EhrAccess.lambda$fetchSubjectIdentifiers$1((Map)idlist, arg_0));
        return idlist;
    }

    public static Map<String, Map<String, String>> getCompositionList(I_DomainAccess domainAccess, UUID ehrId) {
        EhrAccess ehrAccess = (EhrAccess)EhrAccess.retrieveInstance(domainAccess, ehrId);
        DSLContext context = domainAccess.getContext();
        if (ehrAccess == null) {
            throw new IllegalArgumentException("No ehr found for id:" + ehrId);
        }
        HashMap<String, Map<String, String>> compositionlist = new HashMap<String, Map<String, String>>();
        context.selectFrom((Table)Tables.ENTRY).where(Tables.ENTRY.COMPOSITION_ID.eq((Select)context.select((SelectField)Tables.COMPOSITION.ID).from((TableLike)Tables.COMPOSITION).where(Tables.COMPOSITION.EHR_ID.eq((Object)ehrId)))).fetch().forEach(record -> {
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("composition_id", record.getCompositionId().toString());
            details.put("templateId", record.getTemplateId());
            details.put("date", record.getSysTransaction().toString());
            compositionlist.put("details", details);
        });
        return compositionlist;
    }

    private static UUID getParty(EhrAccess ehrAccess) {
        return ehrAccess.getStatusRecord().getParty();
    }

    public static boolean removeDirectory(I_DomainAccess domainAccess, UUID ehrId) {
        DSLContext ctx = domainAccess.getContext();
        return ctx.update((Table)Tables.EHR_).setNull((Field)Tables.EHR_.DIRECTORY).where(Tables.EHR_.ID.eq((Object)ehrId)).execute() > 0;
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    @Override
    public void setAccess(UUID access) {
        this.ehrRecord.setAccess(access);
    }

    @Override
    public void setDirectory(UUID directory) {
        this.ehrRecord.setDirectory(directory);
    }

    @Override
    public void setSystem(UUID system) {
        this.ehrRecord.setSystemId(system);
    }

    @Override
    public void setModifiable(Boolean modifiable) {
        this.getStatusAccess().getStatusRecord().setIsModifiable(modifiable);
    }

    @Override
    public void setArchetypeNodeId(String archetypeNodeId) {
        this.getStatusAccess().getStatusRecord().setArchetypeNodeId(archetypeNodeId);
    }

    @Override
    public String getArchetypeNodeId() {
        return this.getStatusAccess().getStatusRecord().getArchetypeNodeId();
    }

    @Override
    public void setName(DvText name) {
        new RecordedDvText().toDB((Record)this.getStatusAccess().getStatusRecord(), (Field<DvCodedTextRecord>)Tables.STATUS.NAME, name);
    }

    @Override
    public void setName(DvCodedText name) {
        new RecordedDvCodedText().toDB((Record)this.getStatusAccess().getStatusRecord(), (Field<DvCodedTextRecord>)Tables.STATUS.NAME, name);
    }

    @Override
    public void setQueryable(Boolean queryable) {
        this.getStatusAccess().getStatusRecord().setIsQueryable(queryable);
    }

    @Override
    public UUID commit(Timestamp transactionTime) {
        this.ehrRecord.setDateCreated(transactionTime);
        this.ehrRecord.setDateCreatedTzid(OffsetDateTime.from(transactionTime.toLocalDateTime().atOffset(ZoneOffset.from(OffsetDateTime.now()))).getOffset().getId());
        this.ehrRecord.store();
        UUID contributionId = this.contributionAccess.commit(transactionTime);
        if (this.isNew && this.getStatusAccess().getStatusRecord() != null && this.hasStatusChanged) {
            this.statusAccess.setContributionId(contributionId);
            this.statusAccess.setEhrId(this.ehrRecord.getId());
            this.statusAccess.setOtherDetails(this.otherDetails);
            this.statusAccess.commit(transactionTime.toLocalDateTime(), contributionId);
            this.hasStatusChanged = false;
        }
        return this.ehrRecord.getId();
    }

    @Override
    @Deprecated
    public UUID commit() {
        throw new InternalServerException("INTERNAL: this commit is not legal");
    }

    @Override
    public UUID commit(UUID committerId, UUID systemId, String description) {
        Timestamp timestamp = TransactionTime.millis();
        this.contributionAccess.setAuditDetailsValues(committerId, systemId, description, I_ConceptAccess.ContributionChangeType.CREATION);
        this.contributionAccess.setDataType(ContributionDataType.ehr);
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
        this.statusAccess.setAuditAndContributionAuditValues(systemId, committerId, description, I_ConceptAccess.ContributionChangeType.CREATION);
        return this.commit(timestamp);
    }

    @Override
    public Boolean update(Timestamp transactionTime) {
        return this.update(transactionTime, false);
    }

    @Override
    public Boolean update(Timestamp transactionTime, boolean force) {
        boolean result = false;
        if (this.hasStatusChanged) {
            this.statusAccess.setContributionAccess(this.contributionAccess);
            this.statusAccess.setAuditDetailsAccess(new AuditDetailsAccess(this, this.contributionAccess.getAuditsSystemId(), this.contributionAccess.getAuditsCommitter(), I_ConceptAccess.ContributionChangeType.MODIFICATION, this.contributionAccess.getAuditsDescription()));
            this.statusAccess.setOtherDetails(this.otherDetails);
            result = this.statusAccess.update(LocalDateTime.ofInstant(transactionTime.toInstant(), ZoneId.systemDefault()), this.contributionAccess.getId());
            this.hasStatusChanged = false;
        }
        if (force || this.ehrRecord.changed()) {
            this.ehrRecord.setDateCreated(transactionTime);
            this.ehrRecord.setDateCreatedTzid(ZonedDateTime.now().getZone().getId());
            result |= this.ehrRecord.update() > 0;
        }
        return result;
    }

    @Override
    @Deprecated
    public Boolean update() {
        throw new InternalServerException("INTERNAL: this update is not legal");
    }

    @Override
    @Deprecated
    public Boolean update(Boolean force) {
        throw new InternalServerException("INTERNAL: this update is not legal");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean update(UUID committerId, UUID systemId, UUID contributionId, ContributionDef.ContributionState state, I_ConceptAccess.ContributionChangeType contributionChangeType, String description) {
        Timestamp timestamp = TransactionTime.millis();
        if (contributionId != null) {
            I_ContributionAccess access = I_ContributionAccess.retrieveInstance(this.getDataAccess(), contributionId);
            if (access == null) throw new InternalServerException("Can't update status with invalid contribution ID.");
            this.contributionAccess = access;
            return this.update(timestamp);
        } else {
            if (!this.hasStatusChanged) return this.update(timestamp);
            this.contributionAccess = new ContributionAccess(this, this.getEhrRecord().getId());
            this.provisionContributionAccess(this.contributionAccess, committerId, systemId, description, state, contributionChangeType);
            this.contributionAccess.commit();
        }
        return this.update(timestamp);
    }

    private void provisionContributionAccess(I_ContributionAccess access, UUID committerId, UUID systemId, String description, ContributionDef.ContributionState state, I_ConceptAccess.ContributionChangeType contributionChangeType) {
        access.setAuditDetailsValues(committerId, systemId, description, contributionChangeType);
        access.setState(state);
        access.setDataType(ContributionDataType.ehr);
        access.setState(ContributionDef.ContributionState.COMPLETE);
    }

    @Override
    @Deprecated
    public Integer delete() {
        throw new InternalServerException("INTERNAL: this delete is not legal");
    }

    @Override
    public UUID reload() {
        EhrRecord record;
        try {
            record = (EhrRecord)this.getContext().selectFrom((Table)Tables.EHR_).where(Tables.EHR_.ID.eq((Object)this.getId())).fetchOne();
        }
        catch (Exception e) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_ID + this.getId() + EXCEPTION + e);
            throw new IllegalArgumentException(COULD_NOT_RETRIEVE_EHR_FOR_ID + this.getId() + EXCEPTION + e);
        }
        if (record == null || record.size() == 0) {
            log.warn(COULD_NOT_RETRIEVE_EHR_FOR_ID + this.getId());
            return null;
        }
        this.ehrRecord = record;
        I_StatusAccess retStatusAccess = I_StatusAccess.retrieveInstanceByEhrId(this.getDataAccess(), this.ehrRecord.getId());
        this.setStatusAccess(retStatusAccess);
        this.isNew = false;
        return this.getId();
    }

    public I_EhrAccess retrieve(UUID id) {
        return EhrAccess.retrieveInstance(this, id);
    }

    @Override
    public EhrRecord getEhrRecord() {
        return this.ehrRecord;
    }

    private StatusRecord getStatusRecord() {
        return this.getStatusAccess().getStatusRecord();
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public UUID getParty() {
        return this.getStatusAccess().getStatusRecord().getParty();
    }

    @Override
    public void setParty(UUID partyId) {
        this.getStatusAccess().getStatusRecord().setParty(partyId);
    }

    @Override
    public UUID getId() {
        return this.ehrRecord.getId();
    }

    @Override
    public Boolean isModifiable() {
        return this.getStatusAccess().getStatusRecord().getIsModifiable();
    }

    @Override
    public Boolean isQueryable() {
        return this.getStatusAccess().getStatusRecord().getIsQueryable();
    }

    @Override
    public UUID getSystemId() {
        return this.ehrRecord.getSystemId();
    }

    @Override
    public UUID getStatusId() {
        return this.statusAccess.getId();
    }

    @Override
    public UUID getDirectoryId() {
        return this.ehrRecord.getDirectory();
    }

    @Override
    public UUID getAccessId() {
        return this.ehrRecord.getAccess();
    }

    @Override
    public void setOtherDetails(ItemStructure otherDetails, String templateId) {
        this.otherDetails = otherDetails;
    }

    @Override
    public ItemStructure getOtherDetails() {
        return this.otherDetails;
    }

    public I_ContributionAccess getContributionAccess() {
        return this.contributionAccess;
    }

    @Override
    public void setContributionAccess(I_ContributionAccess contributionAccess) {
        this.contributionAccess = contributionAccess;
    }

    @Override
    public I_StatusAccess getStatusAccess() {
        return this.statusAccess;
    }

    @Override
    public void setStatusAccess(I_StatusAccess statusAccess) {
        this.statusAccess = statusAccess;
    }

    @Override
    public void setStatus(EhrStatus status) {
        this.setModifiable(status.isModifiable());
        this.setQueryable(status.isQueryable());
        this.setOtherDetails(status.getOtherDetails(), null);
        if (status.getArchetypeNodeId() != null) {
            this.setArchetypeNodeId(status.getArchetypeNodeId());
        }
        if (status.getName() != null) {
            this.setName(status.getName());
        }
        UUID subjectUuid = new PersistedPartyProxy(this.getDataAccess()).getOrCreate((PartyProxy)status.getSubject());
        this.setParty(subjectUuid);
        this.hasStatusChanged = true;
    }

    @Override
    public EhrStatus getStatus() {
        EhrStatus status = new EhrStatus();
        status.setModifiable(this.isModifiable().booleanValue());
        status.setQueryable(this.isQueryable().booleanValue());
        if (this.getStatusAccess().getStatusRecord().getOtherDetails() != null) {
            status.setOtherDetails(this.getStatusAccess().getStatusRecord().getOtherDetails());
        }
        status.setArchetypeNodeId(this.getArchetypeNodeId());
        Object name = new RecordedDvCodedText().fromDB((Record)this.getStatusAccess().getStatusRecord(), (Field<DvCodedTextRecord>)Tables.STATUS.NAME);
        status.setName((DvText)(name instanceof DvText ? (DvText)name : (DvCodedText)name));
        UUID statusId = this.getStatusAccess().getStatusRecord().getId();
        status.setUid((UIDBasedId)new HierObjectId(statusId.toString() + "::" + this.getServerConfig().getNodename() + "::" + I_StatusAccess.getLatestVersionNumber(this, statusId)));
        PartySelf partySelf = (PartySelf)new PersistedPartyProxy(this).retrieve(this.getParty());
        status.setSubject(partySelf);
        return status;
    }

    @Override
    public void adminDeleteEhr() {
        Result result = Routines.adminDeleteEhrFull((Configuration)this.getContext().configuration(), (UUID)this.getId());
        if (result.isEmpty() || !Boolean.TRUE.equals(((AdminDeleteEhrFullRecord)result.get(0)).getDeleted())) {
            throw new InternalServerException("Admin deletion of EHR failed!");
        }
    }

    public static boolean hasEhr(I_DomainAccess domainAccess, UUID ehrId) {
        return domainAccess.getContext().fetchExists((Table)Tables.EHR_, Tables.EHR_.ID.eq((Object)ehrId));
    }

    private static /* synthetic */ void lambda$fetchSubjectIdentifiers$1(Map idlist, PartyIdentifiedRecord record) {
        idlist.put("ref_name_space", record.getPartyRefNamespace());
        idlist.put("id_value", record.getPartyRefValue());
        idlist.put("ref_name_scheme", record.getPartyRefScheme());
        idlist.put("ref_party_type", record.getPartyRefType());
    }

    private static /* synthetic */ void lambda$fetchSubjectIdentifiers$0(Map idlist, IdentifierRecord record) {
        idlist.put("identifier_issuer", record.getIssuer());
        idlist.put("identifier_id_value", record.getIdValue());
    }

    public static enum PARTY_MODE {
        IDENTIFIER,
        EXTERNAL_REF;

    }
}

