/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.jooq;

import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.datavalues.DvCodedText;
import com.nedap.archie.rm.datavalues.DvText;
import com.nedap.archie.rm.ehr.EhrStatus;
import com.nedap.archie.rm.generic.PartySelf;
import com.nedap.archie.rm.support.identification.HierObjectId;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import com.nedap.archie.rm.support.identification.UIDBasedId;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.ehrbase.api.exception.InternalServerException;
import org.ehrbase.api.exception.InvalidApiParameterException;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.dao.access.interfaces.I_AuditDetailsAccess;
import org.ehrbase.dao.access.interfaces.I_ConceptAccess;
import org.ehrbase.dao.access.interfaces.I_ContributionAccess;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.dao.access.interfaces.I_StatusAccess;
import org.ehrbase.dao.access.jooq.AuditDetailsAccess;
import org.ehrbase.dao.access.jooq.party.PersistedPartyProxy;
import org.ehrbase.dao.access.support.DataAccess;
import org.ehrbase.dao.access.util.ContributionDef;
import org.ehrbase.jooq.pg.Tables;
import org.ehrbase.jooq.pg.tables.records.StatusHistoryRecord;
import org.ehrbase.jooq.pg.tables.records.StatusRecord;
import org.ehrbase.jooq.pg.udt.records.DvCodedTextRecord;
import org.ehrbase.service.RecordedDvCodedText;
import org.jooq.Attachable;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.Select;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusAccess
extends DataAccess
implements I_StatusAccess {
    private static final Logger log = LoggerFactory.getLogger(StatusAccess.class);
    private StatusRecord statusRecord = (StatusRecord)this.getContext().newRecord((Table)Tables.STATUS);
    private I_ContributionAccess contributionAccess;
    private I_AuditDetailsAccess auditDetailsAccess;

    public StatusAccess(I_DomainAccess domainAccess, UUID ehrId) {
        super(domainAccess);
        this.contributionAccess = I_ContributionAccess.getInstance(this, ehrId);
        this.contributionAccess.setState(ContributionDef.ContributionState.COMPLETE);
        this.auditDetailsAccess = I_AuditDetailsAccess.getInstance(this.getDataAccess());
    }

    @Override
    public UUID commit(LocalDateTime timestamp, UUID committerId, UUID systemId, String description) {
        this.createAndSetContribution(committerId, systemId, description, I_ConceptAccess.ContributionChangeType.CREATION);
        return this.internalCommit(timestamp);
    }

    @Override
    public UUID commit(LocalDateTime timestamp, UUID contribution) {
        if (contribution == null) {
            throw new InternalServerException("Invalid null valued contribution.");
        }
        this.setContributionId(contribution);
        return this.internalCommit(timestamp);
    }

    private UUID internalCommit(LocalDateTime transactionTime) {
        this.auditDetailsAccess.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, I_ConceptAccess.ContributionChangeType.CREATION));
        if (this.auditDetailsAccess.getChangeType() == null || this.auditDetailsAccess.getSystemId() == null || this.auditDetailsAccess.getCommitter() == null) {
            throw new InternalServerException("Illegal to commit AuditDetailsAccess without setting mandatory fields.");
        }
        UUID auditId = this.auditDetailsAccess.commit();
        this.statusRecord.setHasAudit(auditId);
        this.statusRecord.setSysTransaction(Timestamp.valueOf(transactionTime));
        this.statusRecord.setHasAudit(auditId);
        if (this.statusRecord.store() == 0) {
            throw new InvalidApiParameterException("Input EHR couldn't be stored; Storing EHR_STATUS failed");
        }
        return this.statusRecord.getId();
    }

    @Override
    public boolean update(LocalDateTime timestamp, UUID committerId, UUID systemId, String description, I_ConceptAccess.ContributionChangeType changeType) {
        this.createAndSetContribution(committerId, systemId, description, I_ConceptAccess.ContributionChangeType.MODIFICATION);
        return this.internalUpdate(timestamp);
    }

    @Override
    public boolean update(LocalDateTime timestamp, UUID contribution) {
        if (contribution == null) {
            throw new InternalServerException("Invalid null valued contribution.");
        }
        this.setContributionId(contribution);
        return this.internalUpdate(timestamp);
    }

    private Boolean internalUpdate(LocalDateTime transactionTime) {
        this.auditDetailsAccess.commit();
        this.statusRecord.setHasAudit(this.auditDetailsAccess.getId());
        this.statusRecord.setSysTransaction(Timestamp.valueOf(transactionTime));
        try {
            return this.statusRecord.update() > 0;
        }
        catch (RuntimeException e) {
            throw new InvalidApiParameterException("Couldn't marshall given EHR_STATUS / OTHER_DETAILS, content probably breaks RM rules");
        }
    }

    @Override
    public int delete(LocalDateTime timestamp, UUID committerId, UUID systemId, String description) {
        this.createAndSetContribution(committerId, systemId, description, I_ConceptAccess.ContributionChangeType.DELETED);
        return this.internalDelete(timestamp, committerId, systemId, description);
    }

    @Override
    public int delete(LocalDateTime timestamp, UUID contribution) {
        if (contribution == null) {
            throw new InternalServerException("Invalid null valued contribution.");
        }
        this.setContributionId(contribution);
        I_ContributionAccess newContributionAccess = I_ContributionAccess.retrieveInstance(this.getDataAccess(), contribution);
        UUID systemId = newContributionAccess.getAuditsSystemId();
        UUID committerId = newContributionAccess.getAuditsCommitter();
        String description = newContributionAccess.getAuditsDescription();
        return this.internalDelete(timestamp, committerId, systemId, description);
    }

    private Integer internalDelete(LocalDateTime timestamp, UUID committerId, UUID systemId, String description) {
        this.statusRecord.setSysTransaction(Timestamp.valueOf(timestamp));
        this.statusRecord.delete();
        I_AuditDetailsAccess delAudit = I_AuditDetailsAccess.getInstance(this, systemId, committerId, I_ConceptAccess.ContributionChangeType.DELETED, description);
        UUID delAuditId = delAudit.commit();
        return this.createAndCommitNewDeletedVersionAsHistory(delAuditId, this.statusRecord.getInContribution());
    }

    private int createAndCommitNewDeletedVersionAsHistory(UUID delAuditId, UUID contrib) {
        StatusHistoryRecord newRecord = (StatusHistoryRecord)this.getDataAccess().getContext().newRecord((Table)Tables.STATUS_HISTORY);
        newRecord.setId(this.statusRecord.getId());
        newRecord.setEhrId(this.statusRecord.getEhrId());
        newRecord.setInContribution(contrib);
        newRecord.setArchetypeNodeId(this.statusRecord.getArchetypeNodeId());
        newRecord.setAttestationRef(this.statusRecord.getAttestationRef());
        newRecord.setName(this.statusRecord.getName());
        newRecord.setIsModifiable(this.statusRecord.getIsModifiable());
        newRecord.setIsQueryable(this.statusRecord.getIsQueryable());
        newRecord.setOtherDetails(this.statusRecord.getOtherDetails());
        newRecord.setParty(this.statusRecord.getParty());
        newRecord.setHasAudit(delAuditId);
        this.getDataAccess().getContext().attach(new Attachable[]{newRecord});
        if (newRecord.insert() != 1) {
            throw new InternalServerException("DB inconsistency");
        }
        return 1;
    }

    private void createAndSetContribution(UUID committerId, UUID systemId, String description, I_ConceptAccess.ContributionChangeType changeType) {
        this.contributionAccess.setAuditDetailsChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, changeType));
        if (this.contributionAccess.getAuditsCommitter() == null || this.contributionAccess.getAuditsSystemId() == null) {
            if (committerId == null || systemId == null) {
                throw new InternalServerException("Illegal to commit the contribution's AuditDetailsAccess without setting mandatory fields.");
            }
            this.contributionAccess.setAuditDetailsCommitter(committerId);
            this.contributionAccess.setAuditDetailsSystemId(systemId);
            this.contributionAccess.setAuditDetailsDescription(description);
        }
        UUID contributionId = this.contributionAccess.commit();
        this.setContributionId(contributionId);
    }

    public static I_StatusAccess retrieveInstance(I_DomainAccess domainAccess, UUID statusId) {
        StatusRecord record = (StatusRecord)domainAccess.getContext().fetchOne((Table)Tables.STATUS, Tables.STATUS.ID.eq((Object)statusId));
        if (record == null) {
            return null;
        }
        return StatusAccess.createStatusAccessForRetrieval(domainAccess, record, null);
    }

    public static I_StatusAccess retrieveInstanceByNamedSubject(I_DomainAccess domainAccess, String partyName) {
        DSLContext context = domainAccess.getContext();
        StatusRecord record = (StatusRecord)domainAccess.getContext().fetchOne((Table)Tables.STATUS, Tables.STATUS.PARTY.eq((Select)context.select((SelectField)Tables.PARTY_IDENTIFIED.ID).from((TableLike)Tables.PARTY_IDENTIFIED).where(Tables.PARTY_IDENTIFIED.NAME.eq((Object)partyName))));
        if (record == null) {
            return null;
        }
        return StatusAccess.createStatusAccessForRetrieval(domainAccess, record, null);
    }

    public static I_StatusAccess retrieveInstanceByParty(I_DomainAccess domainAccess, UUID partyIdentified) {
        DSLContext context = domainAccess.getContext();
        StatusRecord record = (StatusRecord)domainAccess.getContext().fetchOne((Table)Tables.STATUS, Tables.STATUS.PARTY.eq((Select)context.select((SelectField)Tables.PARTY_IDENTIFIED.ID).from((TableLike)Tables.PARTY_IDENTIFIED).where(Tables.PARTY_IDENTIFIED.ID.eq((Object)partyIdentified))));
        if (record == null) {
            return null;
        }
        return StatusAccess.createStatusAccessForRetrieval(domainAccess, record, null);
    }

    public static I_StatusAccess retrieveInstanceByEhrId(I_DomainAccess domainAccess, UUID ehrId) {
        StatusRecord record = null;
        if (domainAccess.getContext().fetchExists((Table)Tables.STATUS, Tables.STATUS.EHR_ID.eq((Object)ehrId))) {
            record = (StatusRecord)domainAccess.getContext().fetchOne((Table)Tables.STATUS, Tables.STATUS.EHR_ID.eq((Object)ehrId));
        } else {
            if (!domainAccess.getContext().fetchExists((Table)Tables.STATUS_HISTORY, Tables.STATUS_HISTORY.EHR_ID.eq((Object)ehrId))) {
                throw new InternalServerException("DB inconsistency. No STATUS for given EHR ID: " + ehrId);
            }
            Result recordsRes = domainAccess.getContext().selectFrom((Table)Tables.STATUS_HISTORY).where(Tables.STATUS_HISTORY.EHR_ID.eq((Object)ehrId)).orderBy((OrderField)Tables.STATUS_HISTORY.SYS_TRANSACTION.desc()).fetch();
            if (recordsRes.get(0) != null) {
                record = StatusAccess.historyRecToNormalRec((StatusHistoryRecord)recordsRes.get(0));
            }
        }
        if (record == null) {
            return null;
        }
        return StatusAccess.createStatusAccessForRetrieval(domainAccess, record, null);
    }

    public static Map<ObjectVersionId, I_StatusAccess> retrieveInstanceByContribution(I_DomainAccess domainAccess, UUID contributionId, String node) {
        HashSet statuses = new HashSet();
        domainAccess.getContext().select((SelectField)Tables.STATUS.ID).from((TableLike)Tables.STATUS).where(Tables.STATUS.IN_CONTRIBUTION.eq((Object)contributionId)).fetch().forEach(rec -> statuses.add((UUID)rec.value1()));
        domainAccess.getContext().select((SelectField)Tables.STATUS_HISTORY.ID).from((TableLike)Tables.STATUS_HISTORY).where(Tables.STATUS_HISTORY.IN_CONTRIBUTION.eq((Object)contributionId)).fetch().forEach(rec -> statuses.add((UUID)rec.value1()));
        HashMap<ObjectVersionId, I_StatusAccess> resultMap = new HashMap<ObjectVersionId, I_StatusAccess>();
        for (UUID statusId : statuses) {
            Map<Integer, I_StatusAccess> map = StatusAccess.getVersionMapOfStatus(domainAccess, statusId);
            map.forEach((k, v) -> {
                if (v.getContributionId().equals(contributionId)) {
                    resultMap.put(new ObjectVersionId(statusId.toString(), node, k.toString()), (I_StatusAccess)v);
                }
            });
        }
        return resultMap;
    }

    public static Map<Integer, I_StatusAccess> getVersionMapOfStatus(I_DomainAccess domainAccess, UUID statusId) {
        HashMap<Integer, I_StatusAccess> versionMap = new HashMap<Integer, I_StatusAccess>();
        Integer versionCounter = StatusAccess.getLatestVersionNumber(domainAccess, statusId);
        StatusRecord record = (StatusRecord)domainAccess.getContext().fetchOne((Table)Tables.STATUS, Tables.STATUS.ID.eq((Object)statusId));
        if (record != null) {
            I_StatusAccess statusAccess = StatusAccess.createStatusAccessForRetrieval(domainAccess, record, null);
            versionMap.put(versionCounter, statusAccess);
            Integer n = versionCounter;
            Integer n2 = versionCounter = Integer.valueOf(versionCounter - 1);
        }
        Result historyRecords = domainAccess.getContext().selectFrom((Table)Tables.STATUS_HISTORY).where(Tables.STATUS_HISTORY.ID.eq((Object)statusId)).orderBy((OrderField)Tables.STATUS_HISTORY.SYS_TRANSACTION.desc()).fetch();
        for (StatusHistoryRecord historyRecord : historyRecords) {
            I_StatusAccess historyAccess = StatusAccess.createStatusAccessForRetrieval(domainAccess, null, historyRecord);
            versionMap.put(versionCounter, historyAccess);
            Integer n = versionCounter;
            Integer n3 = versionCounter = Integer.valueOf(versionCounter - 1);
        }
        if (versionCounter != 0) {
            throw new InternalServerException("Version Map generation failed");
        }
        return versionMap;
    }

    private static I_StatusAccess createStatusAccessForRetrieval(I_DomainAccess domainAccess, StatusRecord record, StatusHistoryRecord historyRecord) {
        StatusAccess statusAccess;
        if (record != null) {
            statusAccess = new StatusAccess(domainAccess, record.getEhrId());
            statusAccess.setStatusRecord(record);
        } else if (historyRecord != null) {
            statusAccess = new StatusAccess(domainAccess, historyRecord.getEhrId());
            statusAccess.setStatusRecord(historyRecord);
        } else {
            throw new InternalServerException("Error creating version map of EHR_STATUS");
        }
        I_AuditDetailsAccess auditAccess = new AuditDetailsAccess(domainAccess.getDataAccess()).retrieveInstance(domainAccess.getDataAccess(), statusAccess.getAuditDetailsId());
        statusAccess.setAuditDetailsAccess(auditAccess);
        I_ContributionAccess retContributionAccess = I_ContributionAccess.retrieveInstance(domainAccess, statusAccess.getContributionId());
        statusAccess.setContributionAccess(retContributionAccess);
        return statusAccess;
    }

    @Override
    public UUID getId() {
        return this.statusRecord.getId();
    }

    @Override
    public DataAccess getDataAccess() {
        return this;
    }

    @Override
    public void setStatusRecord(StatusRecord record) {
        this.statusRecord = record;
    }

    @Override
    public void setStatusRecord(StatusHistoryRecord input) {
        this.statusRecord = new StatusRecord(input.getId(), input.getEhrId(), input.getIsQueryable(), input.getIsModifiable(), input.getParty(), input.getOtherDetails(), null, null, input.getHasAudit(), input.getAttestationRef(), input.getInContribution(), input.getArchetypeNodeId(), input.getName());
    }

    @Override
    public StatusRecord getStatusRecord() {
        return this.statusRecord;
    }

    @Override
    public void setAuditDetailsAccess(I_AuditDetailsAccess auditDetailsAccess) {
        this.auditDetailsAccess = auditDetailsAccess;
    }

    @Override
    public void setContributionAccess(I_ContributionAccess contributionAccess) {
        this.contributionAccess = contributionAccess;
    }

    @Override
    public I_AuditDetailsAccess getAuditDetailsAccess() {
        return this.auditDetailsAccess;
    }

    @Override
    public UUID getAuditDetailsId() {
        return this.statusRecord.getHasAudit();
    }

    @Override
    public void setContributionId(UUID contribution) {
        this.statusRecord.setInContribution(contribution);
    }

    @Override
    public UUID getContributionId() {
        return this.statusRecord.getInContribution();
    }

    @Override
    public void setAuditAndContributionAuditValues(UUID systemId, UUID committerId, String description, I_ConceptAccess.ContributionChangeType changeType) {
        if (committerId == null || systemId == null || changeType == null) {
            throw new IllegalArgumentException("arguments not optional");
        }
        this.auditDetailsAccess.setCommitter(committerId);
        this.auditDetailsAccess.setSystemId(systemId);
        this.auditDetailsAccess.setChangeType(I_ConceptAccess.fetchContributionChangeType((I_DomainAccess)this, changeType));
        if (description != null) {
            this.auditDetailsAccess.setDescription(description);
        }
        this.contributionAccess.setAuditDetailsValues(committerId, systemId, description, changeType);
    }

    protected static StatusRecord historyRecToNormalRec(StatusHistoryRecord statusHistoryRecord) {
        return new StatusRecord(statusHistoryRecord.getId(), statusHistoryRecord.getEhrId(), statusHistoryRecord.getIsQueryable(), statusHistoryRecord.getIsModifiable(), statusHistoryRecord.getParty(), statusHistoryRecord.getOtherDetails(), statusHistoryRecord.getSysTransaction(), statusHistoryRecord.getSysPeriod(), statusHistoryRecord.getHasAudit(), statusHistoryRecord.getAttestationRef(), statusHistoryRecord.getInContribution(), statusHistoryRecord.getArchetypeNodeId(), statusHistoryRecord.getName());
    }

    public static Integer getLatestVersionNumber(I_DomainAccess domainAccess, UUID statusId) {
        if (!StatusAccess.hasPreviousVersionOfStatus(domainAccess, statusId)) {
            return 1;
        }
        int versionCount = domainAccess.getContext().fetchCount((Table)Tables.STATUS_HISTORY, Tables.STATUS_HISTORY.ID.eq((Object)statusId));
        return versionCount + 1;
    }

    private static boolean hasPreviousVersionOfStatus(I_DomainAccess domainAccess, UUID ehrStatusId) {
        return domainAccess.getContext().fetchExists((Table)Tables.STATUS_HISTORY, Tables.STATUS_HISTORY.ID.eq((Object)ehrStatusId));
    }

    public static boolean exists(I_DomainAccess domainAccess, UUID ehrStatusId) {
        return domainAccess.getContext().fetchExists((Table)Tables.STATUS, Tables.STATUS.ID.eq((Object)ehrStatusId));
    }

    @Override
    public int getEhrStatusVersionFromTimeStamp(Timestamp time) {
        UUID statusUid = this.statusRecord.getId();
        I_StatusAccess retStatusAccess = I_StatusAccess.retrieveInstance(this.getDataAccess(), statusUid);
        Result result = this.getDataAccess().getContext().selectFrom((Table)Tables.STATUS_HISTORY).where(Tables.STATUS_HISTORY.ID.eq((Object)statusUid)).orderBy((OrderField)Tables.STATUS_HISTORY.SYS_TRANSACTION.desc()).fetch();
        if (time.after(retStatusAccess.getStatusRecord().getSysTransaction())) {
            return StatusAccess.getLatestVersionNumber(this.getDataAccess(), statusUid);
        }
        for (int i = 0; i < result.size(); ++i) {
            if (result.get(i) instanceof StatusHistoryRecord) {
                if (!time.after(((StatusHistoryRecord)result.get(i)).getSysTransaction())) continue;
                return result.size() - i;
            }
            throw new InternalServerException("Problem comparing timestamps of EHR_STATUS versions");
        }
        throw new ObjectNotFoundException("EHR_STATUS", "Could not find EHR_STATUS version matching given timestamp");
    }

    @Override
    public Timestamp getInitialTimeOfVersionedEhrStatus() {
        Result result = this.getDataAccess().getContext().selectFrom((Table)Tables.STATUS_HISTORY).where(Tables.STATUS_HISTORY.EHR_ID.eq((Object)this.statusRecord.getEhrId())).orderBy((OrderField)Tables.STATUS_HISTORY.SYS_TRANSACTION.asc()).fetch();
        if (!result.isEmpty()) {
            StatusHistoryRecord statusHistoryRecord = (StatusHistoryRecord)result.get(0);
            return statusHistoryRecord.getSysTransaction();
        }
        return this.statusRecord.getSysTransaction();
    }

    @Override
    public EhrStatus getStatus() {
        EhrStatus status = new EhrStatus();
        status.setModifiable(this.getStatusRecord().getIsModifiable().booleanValue());
        status.setQueryable(this.getStatusRecord().getIsQueryable().booleanValue());
        if (this.getStatusRecord().getOtherDetails() != null) {
            status.setOtherDetails(this.getStatusRecord().getOtherDetails());
        }
        status.setArchetypeNodeId(this.getStatusRecord().getArchetypeNodeId());
        Object name = new RecordedDvCodedText().fromDB((Record)this.getStatusRecord(), (Field<DvCodedTextRecord>)Tables.STATUS.NAME);
        status.setName((DvText)(name instanceof DvText ? (DvText)name : (DvCodedText)name));
        UUID statusId = this.getStatusRecord().getId();
        status.setUid((UIDBasedId)new HierObjectId(statusId.toString() + "::" + this.getServerConfig().getNodename() + "::" + I_StatusAccess.getLatestVersionNumber(this, statusId)));
        PartySelf partySelf = (PartySelf)new PersistedPartyProxy(this).retrieve(this.getStatusRecord().getParty());
        status.setSubject(partySelf);
        return status;
    }

    @Override
    public void setOtherDetails(ItemStructure otherDetails) {
        if (otherDetails != null) {
            this.statusRecord.setOtherDetails(otherDetails);
        }
    }

    @Override
    public ItemStructure getOtherDetails() {
        return this.statusRecord.getOtherDetails();
    }

    @Override
    public void setEhrId(UUID ehrId) {
        this.statusRecord.setEhrId(ehrId);
    }

    @Override
    public UUID getEhrId() {
        return this.statusRecord.getEhrId();
    }
}

