/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.dao.access.util;

import com.nedap.archie.rm.datastructures.ItemStructure;
import com.nedap.archie.rm.directory.Folder;
import com.nedap.archie.rm.support.identification.ObjectVersionId;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import org.ehrbase.api.exception.ObjectNotFoundException;
import org.ehrbase.dao.access.interfaces.I_FolderAccess;
import org.ehrbase.serialisation.dbencoding.RawJson;
import org.jooq.JSONB;
import org.postgresql.util.PGobject;

public class FolderUtils {
    private FolderUtils() {
    }

    public static I_FolderAccess getPath(I_FolderAccess folderAccess, int currentIndex, String[] path) {
        if (currentIndex >= path.length) {
            return folderAccess;
        }
        String searchFolderName = path[currentIndex];
        if (folderAccess.getSubfoldersList() == null || folderAccess.getSubfoldersList().isEmpty()) {
            throw new ObjectNotFoundException("DIRECTORY", "Folder at path '" + searchFolderName + "' could not be found.");
        }
        Optional<I_FolderAccess> foundFolder = folderAccess.getSubfoldersList().values().stream().filter(subFolderAccess -> searchFolderName.equals(subFolderAccess.getFolderName())).findFirst();
        if (foundFolder.isEmpty()) {
            throw new ObjectNotFoundException("DIRECTORY", "Folder at path '" + searchFolderName + "' could not be found.");
        }
        return FolderUtils.getPath(foundFolder.get(), currentIndex + 1, path);
    }

    public static void updateFolder(Folder update, I_FolderAccess target) {
        if (update.getNameAsString() != null) {
            target.setFolderName(update.getNameAsString());
        }
        if (update.getDetails() != null) {
            target.setFolderDetails(update.getDetails());
        }
        if (update.getArchetypeNodeId() != null) {
            target.setFolderNArchetypeNodeId(update.getArchetypeNodeId());
        }
        if (update.getItems() != null) {
            target.getItems().clear();
            target.getItems().addAll(update.getItems());
        }
    }

    public static void checkSiblingNameConflicts(Folder folder) {
        if (folder.getFolders() != null && !folder.getFolders().isEmpty()) {
            HashSet folderNames = new HashSet();
            folder.getFolders().forEach(subFolder -> {
                if (!folderNames.add(subFolder.getNameAsString())) {
                    throw new IllegalArgumentException("Duplicate folder name " + subFolder.getNameAsString());
                }
                FolderUtils.checkSiblingNameConflicts(subFolder);
            });
        }
    }

    public static UUID extractUuidFromObjectVersionId(ObjectVersionId folderId) {
        String value = folderId.getValue();
        if (value == null) {
            return null;
        }
        int index = value.indexOf("::");
        if (index < 0) {
            return UUID.fromString(value);
        }
        return UUID.fromString(value.substring(0, index));
    }

    public static Integer extractVersionNumberFromObjectVersionId(ObjectVersionId objectVersionId) {
        String value = objectVersionId.getValue();
        if (value == null) {
            return null;
        }
        int index = value.lastIndexOf("::");
        if (index < 0 || index == value.indexOf("::")) {
            return null;
        }
        return Integer.parseInt(value.substring(index + 2));
    }

    public static ItemStructure parseFromJSONB(JSONB dbObject) {
        if (dbObject == null) {
            return null;
        }
        String value = dbObject.data();
        return (ItemStructure)new RawJson().unmarshal(value, ItemStructure.class);
    }

    public static ItemStructure parseFromPGobject(PGobject databaseObject) {
        if (databaseObject == null) {
            return null;
        }
        String value = databaseObject.getValue();
        return (ItemStructure)new RawJson().unmarshal(value, ItemStructure.class);
    }
}

