/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.compiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.commons.lang3.StringUtils;
import org.ehrbase.aql.compiler.OrderAttribute;
import org.ehrbase.aql.compiler.TopAttributes;
import org.ehrbase.aql.definition.ConstantDefinition;
import org.ehrbase.aql.definition.ExtensionDefinition;
import org.ehrbase.aql.definition.FuncParameter;
import org.ehrbase.aql.definition.FuncParameterType;
import org.ehrbase.aql.definition.FunctionDefinition;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.definition.IdentifiedPathVariable;
import org.ehrbase.aql.definition.PredicateDefinition;
import org.ehrbase.aql.definition.VariableDefinition;
import org.ehrbase.aql.parser.AqlBaseListener;
import org.ehrbase.aql.parser.AqlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class QueryCompilerPass2
extends AqlBaseListener {
    private static final int POSTGRESQL_ALIAS_LENGTH_LIMIT = 63;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String[] allowedFunctions = new String[]{"COUNT", "MIN", "MAX", "AVG", "SUM", "SUBSTR", "STRPOS", "SPLIT_PART", "BTRIM", "CONCAT", "CONCAT_WS", "DECODE", "ENCODE", "FORMAT", "INITCAP", "LEFT", "LENGTH", "LPAD", "LTRIM", "REGEXP_MATCH", "REGEXP_REPLACE", "REGEXP_SPLIT_TO_ARRAY", "REGEXP_SPLIT_TO_TABLE", "REPEAT", "REPLACE", "REVERSE", "RIGHT", "RPAD", "RTRIM", "TRANSLATE", "CAST", "NOW"};
    private final Deque<I_VariableDefinition> variableStack = new ArrayDeque<I_VariableDefinition>();
    private final Map<AqlParser.SelectExprContext, PredicateDefinition> predicateDefinitionMap = new HashMap<AqlParser.SelectExprContext, PredicateDefinition>();
    private final Random random = new Random();
    private Deque<OrderAttribute> orderAttributes = null;
    private Integer limitAttribute = null;
    private Integer offsetAttribute = null;
    private TopAttributes topAttributes = null;

    @Override
    public void exitObjectPath(AqlParser.ObjectPathContext objectPathContext) {
        this.logger.debug("Object Path->");
    }

    @Override
    public void exitSelectExpr(AqlParser.SelectExprContext selectExprContext) {
        boolean isDistinct = false;
        AqlParser.IdentifiedPathContext identifiedPathContext = selectExprContext.identifiedPath();
        if (selectExprContext.DISTINCT() != null) {
            isDistinct = true;
        }
        if (identifiedPathContext != null) {
            VariableDefinition variableDefinition = new IdentifiedPathVariable(identifiedPathContext, selectExprContext, isDistinct, this.predicateDefinitionMap.get((Object)selectExprContext)).definition();
            if (variableDefinition.getAlias() != null) {
                variableDefinition.setVoidAlias(false);
            }
            this.pushVariableDefinition(variableDefinition);
        } else if (selectExprContext.stdExpression() != null) {
            this.logger.debug("Found standard expression");
            if (selectExprContext.stdExpression().function() != null) {
                this.handleFunctionDefinition(selectExprContext.stdExpression().function(), selectExprContext);
            } else if (selectExprContext.stdExpression().castFunction() != null) {
                this.handleCastFunctionDefinition(selectExprContext.stdExpression().castFunction(), selectExprContext);
            } else if (selectExprContext.stdExpression().extension() != null) {
                this.handleExtensionDefinition(selectExprContext.stdExpression().extension(), selectExprContext);
            } else {
                this.handleTerminalNodeExpression(selectExprContext.stdExpression(), selectExprContext);
            }
        } else {
            throw new IllegalArgumentException("Could not interpret select context");
        }
    }

    @Override
    public void exitNodePredicateComparable(AqlParser.NodePredicateComparableContext nodePredicateComparableContext) {
        ParserRuleContext ruleContext;
        String operand2 = null;
        String operator = null;
        if (nodePredicateComparableContext.predicateOperand().isEmpty()) {
            return;
        }
        String operand1 = nodePredicateComparableContext.predicateOperand(0).getText();
        if (!CollectionUtils.isEmpty(nodePredicateComparableContext.predicateOperand())) {
            operand2 = nodePredicateComparableContext.predicateOperand(1).getText();
        }
        if (!CollectionUtils.isEmpty((Collection)nodePredicateComparableContext.children)) {
            operator = nodePredicateComparableContext.getChild(1).getText();
        }
        for (ruleContext = nodePredicateComparableContext.getParent(); !(ruleContext instanceof AqlParser.SelectExprContext) && ruleContext != null; ruleContext = ruleContext.getParent()) {
        }
        if (ruleContext instanceof AqlParser.SelectExprContext) {
            PredicateDefinition predicateDefinition = new PredicateDefinition(operand1, operator, operand2);
            this.predicateDefinitionMap.put((AqlParser.SelectExprContext)ruleContext, predicateDefinition);
        }
    }

    private void pushVariableDefinition(I_VariableDefinition variableDefinition) {
        this.isUnique(variableDefinition);
        this.variableStack.push(variableDefinition);
    }

    private void handleFunctionDefinition(AqlParser.FunctionContext functionContext, AqlParser.SelectExprContext inSelectExprContext) {
        this.logger.debug("Found function");
        String name = functionContext.FUNCTION_IDENTIFIER().getText();
        if (!Arrays.asList(this.allowedFunctions).contains(name.toUpperCase())) {
            throw new IllegalArgumentException("Found not supported function:'" + name + "'");
        }
        ArrayList<FuncParameter> parameters = new ArrayList<FuncParameter>();
        int serial = 0;
        for (ParseTree pathTree : functionContext.children) {
            if (pathTree instanceof AqlParser.IdentifiedPathContext) {
                AqlParser.IdentifiedPathContext pathContext = (AqlParser.IdentifiedPathContext)pathTree;
                VariableDefinition variableDefinition = new IdentifiedPathVariable(pathContext, inSelectExprContext, false, null).definition();
                if (variableDefinition.getAlias() == null || variableDefinition.getAlias().isEmpty() || variableDefinition.getAlias().length() > 63) {
                    variableDefinition.setAlias("_FCT_ARG_" + serial++);
                }
                this.pushVariableDefinition(variableDefinition);
                parameters.add(new FuncParameter(FuncParameterType.VARIABLE, variableDefinition.getAlias() == null ? variableDefinition.getPath() : variableDefinition.getAlias()));
                continue;
            }
            if (pathTree instanceof AqlParser.OperandContext) {
                parameters.add(new FuncParameter(FuncParameterType.OPERAND, pathTree.getText()));
                continue;
            }
            if (!(pathTree instanceof TerminalNode)) continue;
            parameters.add(new FuncParameter(FuncParameterType.IDENTIFIER, pathTree.getText()));
        }
        String alias = this.extractAlias(inSelectExprContext);
        if (alias == null) {
            if (inSelectExprContext.IDENTIFIER() == null) {
                alias = name;
            } else {
                inSelectExprContext.IDENTIFIER().getText();
            }
        }
        String path = functionContext.getText();
        FunctionDefinition definition = new FunctionDefinition(name, alias, path, parameters);
        this.pushVariableDefinition(definition);
    }

    private void handleCastFunctionDefinition(AqlParser.CastFunctionContext castFunctionContext, AqlParser.SelectExprContext inSelectExprContext) {
        this.logger.debug("Found CAST function");
        ArrayList<FuncParameter> parameters = new ArrayList<FuncParameter>();
        int serial = 0;
        for (ParseTree pathTree : castFunctionContext.children) {
            if (pathTree instanceof AqlParser.IdentifiedPathContext) {
                AqlParser.IdentifiedPathContext pathContext = (AqlParser.IdentifiedPathContext)pathTree;
                VariableDefinition variableDefinition = new IdentifiedPathVariable(pathContext, inSelectExprContext, false, null).definition();
                if (variableDefinition.getAlias() == null || variableDefinition.getAlias().isEmpty() || variableDefinition.getAlias().length() > 63) {
                    variableDefinition.setAlias("_FCT_ARG_" + serial++);
                }
                this.pushVariableDefinition(variableDefinition);
                parameters.add(new FuncParameter(FuncParameterType.VARIABLE, variableDefinition.getAlias() == null ? variableDefinition.getPath() : variableDefinition.getAlias()));
                continue;
            }
            if (pathTree instanceof AqlParser.OperandContext) {
                parameters.add(new FuncParameter(FuncParameterType.OPERAND, pathTree.getText()));
                continue;
            }
            if (!(pathTree instanceof TerminalNode)) continue;
            Object text = pathTree.getText();
            if (((String)text).contains("'")) {
                text = ((String)text).replace("'", "");
            }
            text = " " + (String)text;
            parameters.add(new FuncParameter(FuncParameterType.IDENTIFIER, (String)text));
        }
        String alias = this.extractAlias(inSelectExprContext);
        if (alias == null) {
            alias = "CAST";
        }
        String path = castFunctionContext.getText();
        FunctionDefinition definition = new FunctionDefinition("CAST", alias, path, parameters);
        this.pushVariableDefinition(definition);
    }

    public void handleExtensionDefinition(AqlParser.ExtensionContext extensionContext, AqlParser.SelectExprContext inSelectExprContext) {
        this.logger.debug("Found extension");
        String context = extensionContext.getChild(2).getText();
        String parsableExpression = extensionContext.getChild(4).getText();
        Object alias = inSelectExprContext.IDENTIFIER() == null ? "_alias_" + this.random.nextLong() : inSelectExprContext.IDENTIFIER().getText();
        ExtensionDefinition definition = new ExtensionDefinition(context, parsableExpression, (String)alias);
        this.pushVariableDefinition(definition);
    }

    public void handleTerminalNodeExpression(AqlParser.StdExpressionContext inStdExpressionContext, AqlParser.SelectExprContext inSelectExprContext) {
        this.logger.debug("Found terminal node");
        Object value = inStdExpressionContext.BOOLEAN() != null ? Boolean.valueOf(inStdExpressionContext.getText()) : (inStdExpressionContext.FALSE() != null ? Boolean.valueOf(false) : (inStdExpressionContext.TRUE() != null ? Boolean.valueOf(true) : (inStdExpressionContext.FLOAT() != null ? Float.valueOf(inStdExpressionContext.getText()) : (inStdExpressionContext.INTEGER() != null ? Integer.valueOf(inStdExpressionContext.getText()) : (inStdExpressionContext.NULL() != null ? null : (inStdExpressionContext.REAL() != null ? Double.valueOf(inStdExpressionContext.getText()) : (inStdExpressionContext.UNKNOWN() != null ? null : (inStdExpressionContext.STRING() != null ? inStdExpressionContext.getText().replace("'", "") : inStdExpressionContext.getText()))))))));
        ConstantDefinition definition = new ConstantDefinition(value, this.extractAlias(inSelectExprContext));
        this.pushVariableDefinition(definition);
    }

    private void isUnique(I_VariableDefinition variableDefinition) {
        if (variableDefinition.isFunction()) {
            return;
        }
        String alias = variableDefinition.getAlias();
        for (I_VariableDefinition stackedVariableDefinition : this.variableStack) {
            if (StringUtils.isEmpty((CharSequence)stackedVariableDefinition.getAlias()) || !stackedVariableDefinition.getAlias().equals(alias)) continue;
            throw new IllegalArgumentException("Duplicated alias detected:" + alias);
        }
    }

    private String extractAlias(AqlParser.SelectExprContext inSelectExprContext) {
        String foundAlias = null;
        if (inSelectExprContext.getChildCount() == 3 && inSelectExprContext.getChild(1).getText().equalsIgnoreCase("AS")) {
            foundAlias = inSelectExprContext.getChild(2).getText();
        }
        return foundAlias;
    }

    @Override
    public void exitTopExpr(AqlParser.TopExprContext context) {
        Integer window = null;
        TopAttributes.TopDirection direction = null;
        if (context.TOP() != null) {
            window = Integer.valueOf(context.INTEGER().getText());
            if (context.BACKWARD() != null) {
                direction = TopAttributes.TopDirection.BACKWARD;
            } else if (context.FORWARD() != null) {
                direction = TopAttributes.TopDirection.FORWARD;
            }
        }
        this.topAttributes = new TopAttributes(window, direction);
    }

    @Override
    public void exitOrderBySeq(AqlParser.OrderBySeqContext context) {
        if (this.orderAttributes == null) {
            this.orderAttributes = new ArrayDeque<OrderAttribute>();
        }
        for (ParseTree tree : context.children) {
            if (!(tree instanceof AqlParser.OrderByExprContext)) continue;
            AqlParser.OrderByExprContext context1 = (AqlParser.OrderByExprContext)tree;
            AqlParser.IdentifiedPathContext identifiedPathContext = context1.identifiedPath();
            String path = identifiedPathContext.objectPath() != null ? identifiedPathContext.objectPath().getText() : null;
            String identifier = identifiedPathContext.IDENTIFIER().getText();
            OrderAttribute orderAttribute = path == null ? new OrderAttribute(new VariableDefinition(path, identifier, null, false)) : new OrderAttribute(new VariableDefinition(path, null, identifier, false));
            if (context1.ASC() != null || context1.ASCENDING() != null) {
                orderAttribute.setDirection(OrderAttribute.OrderDirection.ASC);
            } else if (context1.DESC() != null || context1.DESCENDING() != null) {
                orderAttribute.setDirection(OrderAttribute.OrderDirection.DESC);
            }
            this.orderAttributes.push(orderAttribute);
        }
    }

    @Override
    public void exitOffset(AqlParser.OffsetContext ctx) {
        this.offsetAttribute = Integer.valueOf(ctx.INTEGER().getText());
    }

    @Override
    public void exitLimit(AqlParser.LimitContext ctx) {
        this.limitAttribute = Integer.valueOf(ctx.INTEGER().getText());
    }

    @Override
    public void exitFunction(AqlParser.FunctionContext functionContext) {
        this.logger.debug("in function");
    }

    public List<I_VariableDefinition> getVariables() {
        return new ArrayList<I_VariableDefinition>(this.variableStack);
    }

    TopAttributes getTopAttributes() {
        return this.topAttributes;
    }

    List<OrderAttribute> getOrderAttributes() {
        if (this.orderAttributes == null) {
            return new ArrayList<OrderAttribute>();
        }
        return new ArrayList<OrderAttribute>(this.orderAttributes);
    }

    Integer getLimitAttribute() {
        return this.limitAttribute;
    }

    Integer getOffsetAttribute() {
        return this.offsetAttribute;
    }
}

