/*
 * Decompiled with CFR 0.152.
 */
package org.ehrbase.aql.sql.binding;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ehrbase.aql.compiler.Contains;
import org.ehrbase.aql.compiler.Statements;
import org.ehrbase.aql.containment.IdentifierMapper;
import org.ehrbase.aql.definition.I_VariableDefinition;
import org.ehrbase.aql.sql.PathResolver;
import org.ehrbase.aql.sql.binding.ConstantField;
import org.ehrbase.aql.sql.binding.ExpressionField;
import org.ehrbase.aql.sql.binding.ISelectBinder;
import org.ehrbase.aql.sql.binding.LateralJoins;
import org.ehrbase.aql.sql.binding.SetReturningFunction;
import org.ehrbase.aql.sql.binding.TaggedStringBuilder;
import org.ehrbase.aql.sql.binding.VariableDefinitions;
import org.ehrbase.aql.sql.binding.WhereBinder;
import org.ehrbase.aql.sql.queryimpl.CompositionAttributeQuery;
import org.ehrbase.aql.sql.queryimpl.IQueryImpl;
import org.ehrbase.aql.sql.queryimpl.JsonbEntryQuery;
import org.ehrbase.aql.sql.queryimpl.MultiFields;
import org.ehrbase.aql.sql.queryimpl.MultiFieldsMap;
import org.ehrbase.aql.sql.queryimpl.ObjectQuery;
import org.ehrbase.aql.sql.queryimpl.QualifiedAqlField;
import org.ehrbase.aql.sql.queryimpl.TemplateMetaData;
import org.ehrbase.dao.access.interfaces.I_DomainAccess;
import org.ehrbase.service.IntrospectService;
import org.ehrbase.service.KnowledgeCacheService;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.SelectQuery;
import org.jooq.impl.DSL;

public class SelectBinder
extends TemplateMetaData
implements ISelectBinder {
    public static final String DATA = "data";
    private final JsonbEntryQuery jsonbEntryQuery;
    private final CompositionAttributeQuery compositionAttributeQuery;
    private final PathResolver pathResolver;
    private final VariableDefinitions variableDefinitions;
    private final WhereBinder whereBinder;
    private final I_DomainAccess domainAccess;

    SelectBinder(I_DomainAccess domainAccess, IntrospectService introspectCache, PathResolver pathResolver, VariableDefinitions variableDefinitions, List whereClause, String serverNodeId) {
        super(introspectCache);
        this.domainAccess = domainAccess;
        this.pathResolver = pathResolver;
        this.variableDefinitions = variableDefinitions;
        this.jsonbEntryQuery = new JsonbEntryQuery(domainAccess, introspectCache, pathResolver);
        this.compositionAttributeQuery = new CompositionAttributeQuery(domainAccess, pathResolver, serverNodeId, introspectCache);
        this.whereBinder = new WhereBinder(domainAccess, this.compositionAttributeQuery, whereClause, pathResolver);
    }

    private SelectBinder(I_DomainAccess domainAccess, IntrospectService introspectCache, IdentifierMapper mapper, VariableDefinitions variableDefinitions, List whereClause, String serverNodeId) {
        this(domainAccess, introspectCache, new PathResolver((KnowledgeCacheService)introspectCache, mapper), variableDefinitions, whereClause, serverNodeId);
    }

    public SelectBinder(I_DomainAccess domainAccess, IntrospectService introspectCache, Contains contains, Statements statements, String serverNodeId) {
        this(domainAccess, introspectCache, contains.getIdentifierMapper(), statements.getVariables(), statements.getWhereClause(), serverNodeId);
    }

    public List<MultiFields> bind(String templateId) {
        ObjectQuery.reset();
        ArrayList<MultiFields> multiFieldsList = new ArrayList<MultiFields>();
        while (this.variableDefinitions.hasNext()) {
            MultiFields multiFields;
            I_VariableDefinition variableDefinition = this.variableDefinitions.next();
            if (variableDefinition.isFunction() || variableDefinition.isExtension()) continue;
            if (variableDefinition.isConstant()) {
                multiFields = new MultiFields(variableDefinition, new ConstantField(variableDefinition).toSql(), templateId);
            } else {
                ExpressionField expressionField = new ExpressionField(variableDefinition, this.jsonbEntryQuery, this.compositionAttributeQuery);
                String identifier = variableDefinition.getIdentifier();
                String className = this.pathResolver.classNameOf(identifier);
                multiFields = expressionField.toSql(className, templateId, identifier, IQueryImpl.Clause.SELECT);
                if (multiFields == null || multiFields.isEmpty()) continue;
                this.encodeForLateral(className, templateId, variableDefinition, multiFields);
            }
            multiFieldsList.add(multiFields);
            ObjectQuery.inc();
        }
        return multiFieldsList;
    }

    public Condition getWhereConditions(String templateId, int whereCursor, MultiFieldsMap multiWhereFieldsMap, MultiFieldsMap multiSelectFieldsMap) {
        return this.whereBinder.bind(templateId, whereCursor, multiWhereFieldsMap, multiSelectFieldsMap);
    }

    public CompositionAttributeQuery getCompositionAttributeQuery() {
        return this.compositionAttributeQuery;
    }

    private void encodeForLateral(String className, String templateId, I_VariableDefinition variableDefinition, MultiFields multiFields) {
        Iterator<QualifiedAqlField> it = multiFields.iterator();
        while (it.hasNext()) {
            QualifiedAqlField qualifiedAqlField = it.next();
            Field<?> sqlField = qualifiedAqlField.getSQLField();
            SelectQuery selectQuery = this.domainAccess.getContext().selectQuery();
            selectQuery.addSelect(new SelectFieldOrAsterisk[]{sqlField});
            if (!new SetReturningFunction(selectQuery.toString()).isUsed()) continue;
            String alias = sqlField.getName();
            MultiFields unaliasedFields = new ExpressionField(variableDefinition, this.jsonbEntryQuery, this.compositionAttributeQuery).toSql(className, templateId, variableDefinition.getIdentifier(), IQueryImpl.Clause.WHERE);
            TaggedStringBuilder taggedStringBuilder = new TaggedStringBuilder();
            taggedStringBuilder.append(unaliasedFields.getLastQualifiedField().getSQLField().toString());
            new LateralJoins().create(templateId, taggedStringBuilder, variableDefinition, IQueryImpl.Clause.SELECT);
            variableDefinition.getLastLateralJoin(templateId).setClause(IQueryImpl.Clause.SELECT);
            String sqlToLateralJoin = variableDefinition.getLastLateralJoin(templateId).getTable().getName() + "." + variableDefinition.getLastLateralJoin(templateId).getLateralVariable();
            variableDefinition.setAlias(alias);
            Field substituteField = DSL.field((String)sqlToLateralJoin).as(alias);
            if (variableDefinition.getSelectType() != null) {
                substituteField = DSL.field((String)(sqlToLateralJoin + "::" + variableDefinition.getSelectType().getCastTypeName())).as(alias);
            }
            multiFields.replaceField(qualifiedAqlField, substituteField);
        }
    }
}

